
<?php $__env->startSection('title', 'Nomadic-Upcoming Guests'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Upcoming Guests</h1>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input type="hidden" id="guestId" value="<?php echo e($guestId); ?>" readonly>
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <th>Date & Time</th>
                <th>Invitation Type</th>
                <th>Guest Name</th>
                <th>Status</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <?php if(!empty($data) && $data->count() > 0): ?>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($dt->invitation_date); ?> <?php echo e($dt->invitation_time); ?></td>
                  <td><?php echo e(ucfirst($dt->invitation_type)); ?></td>
                  <td><?php echo e(ucfirst($dt->fname)); ?> <?php echo e(ucfirst($dt->lname)); ?></td>
                  <td class="guest_<?php echo e($dt->guest_uuid); ?>">
                    <?php if($dt->status==0): ?> <span class="txtApproved">Invited</span> 
                    <?php elseif($dt->status==1): ?> <span class="txtPayment">Check In</span> 
                    <?php elseif($dt->status==2): ?> <span class="txtCancelled">Cancelled</span> 
                    <?php elseif($dt->status==3): ?> <span class="txtApproved">Paid</span><?php endif; ?>
                  </td>
                  <td>
                    <i id="guest_<?php echo e($dt->id); ?>" class="bi bi-eye vieweye" data-id="<?php echo e($dt->id); ?>" data-status="<?php echo e($dt->status); ?>" data-gfname="<?php echo e($dt->fname); ?>" data-glname="<?php echo e($dt->lname); ?>" data-gemail="<?php echo e($dt->email); ?>" data-hfname="<?php echo e($dt->host->fname); ?>" data-hlname="<?php echo e($dt->host->lname); ?>" data-invitation-date="<?php echo e($dt->invitation_date); ?>" data-invitation-time="<?php echo e($dt->invitation_time); ?>" data-location="<?php echo e($dt->location->location); ?>" data-hpic="<?php echo e($dt->host->profile_pic); ?>"></i>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>
                <td colspan="4">No record found</td>
              </tr>  
              <?php endif; ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="4">
                  <div class="foot-paging">
                    <?php echo $data->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:400px;">
        <div class="card-body pt-3">
          <div class="row">
            <div class="col-md-6">
              <img id="hpic" src="" class="img-fluid">
            </div>
            <div class="col-md-6">
              <input type="hidden" id="upcomingid" />
              <label class="small text-muted">Name</label>
              <div class="clearboth"></div>
              <label class="lblprofilebind" id="gname"></label>
              <div class="clearboth"></div>
              <label class="small text-muted mt-2">Email</label>
              <div class="clearboth"></div>
              <label class="lblprofile" id="gemail"></label>
              <div class="clearboth"></div>
              <label class="small text-muted mt-2">Invited By</label>
              <div class="clearboth"></div>
              <label class="lblprofile" id="hname"></label>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-6">
              <label class="small text-muted">Date</label>
              <div class="clearboth"></div>
              <label class="lblprofile" id="invdate"></label>
            </div>
            <div class="col-md-6">
                <label class="small text-muted">Location</label>
                <div class="clearboth"></div>
                <label class="lblprofile" id="ulocation"></label>
            </div>
          </div>
          <div class="row mt-4 actionbtns"></div>
        </div>
      </div>
    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
  $(document).ready(function () {
    let guest_id = $('#guestId').val();
    if(guest_id!=""){
      let obj = $('#guest_'+guest_id);
      view_guest(obj);
    }

    $(document).on('click', '.vieweye', function(){
      view_guest($(this));
    });

    $(document).on('click', '.invaction', function(){ 
      let status = $(this).data('status');
      let upcoming_id = $('#upcomingid').val();
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:status},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            window.location.reload();
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/user/upcoming-guest.blade.php ENDPATH**/ ?>