
<?php $__env->startSection('title', 'Nomadic-Sign up'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="sub-head mt-4"><?php echo e(__('Sign up')); ?></h2>
    <div class="row mb-5 d-block"  align="center">
        <div class="col-md-4">
            <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>
            <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
            <form id="signupForm" class="w-100">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="plan" value="<?php echo e($plan); ?>" readonly>
                <div class="form-container">
                    <div class="form-group mb-2">
                        <input type="text" id="fname" name="fname" class="form-control shadow-none" placeholder="<?php echo e(__('First Name')); ?>" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="lname" name="lname" class="form-control shadow-none" placeholder="<?php echo e(__('Last Name')); ?>" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="email" id="email" name="email" class="form-control shadow-none" placeholder="<?php echo e(__('Email')); ?>" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="tel" placeholder="<?php echo e(__('Mobile Number')); ?>" id="telephone" class="form-control shadow-none" maxlength="14"/>
                        <span id="msg" class="error"></span>
                        <input type="hidden" id="mobile_number" name="mobile_number"/>
                    </div>
                    <span><?php echo e(__('By clicking Sign Up, you are indicating that you have read and acknowledge the')); ?> <a class="anc-color" href="<?php echo e(url('reset-password')); ?>"><?php echo e(__('Terms of Service')); ?></a> <?php echo e(__('and')); ?> <a class="anc-color" href="<?php echo e(url('reset-password')); ?>"><?php echo e(__('Privacy Policy')); ?></a>.</span></br>
                    <span><?php echo e(__('By continue your mobile number, you agree to receive SMS for verification.')); ?></span>
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn btn-primary" type="button" id="btn_signup"><?php echo e(__('Sign up')); ?>

                            <div class="spinner-border spinner-border-sm text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden"><?php echo e(__('Loading')); ?>...</span></div>
                        </button>
                    </div>
                    <span><?php echo e(__('Already have an account?')); ?></span> <a class="anc-color" href="<?php echo e(url('login')); ?>"><?php echo e(__('Sign in')); ?></a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/intlTelInput.css')); ?>">
<script src="<?php echo e(asset('js/intlTelInput.js')); ?>"></script> 
<script>
    var errorMap = ["<?php echo e(__('Invalid number')); ?>", "<?php echo e(__('Invalid country code')); ?>", "<?php echo e(__('Too short')); ?>", "<?php echo e(__('Too long')); ?>"];
    var input = document.querySelector("#telephone");
    var msg = document.querySelector("#msg");
    var intl = window.intlTelInput(input, {
        autoPlaceholder: false,
        separateDialCode: true,
        placeholderNumberType: "MOBILE",
        utilsScript: "<?php echo e(asset('js/utils.js')); ?>"
    });
    // Validate on blur event
    input.addEventListener('keyup', function() {
        if(input.value.trim()){
            if(intl.isValidNumber()){
                input.classList.remove("error");
                msg.classList.add("hide");
                //msg.hide();
            }else{
                input.classList.add("error");
                var errorCode = intl.getValidationError();
                msg.innerHTML = errorMap[errorCode];
                msg.classList.remove("hide");
                //msg.show();
            }
        }
        let full_number = intl.getNumber();
        $('#mobile_number').val(full_number);
    });
    //input.addEventListener('keyup', (e) => {
        // let val = e.target.value;
        // e.target.value = val
        // .replace(/\D/g, '')
        // .replace(/(\d{1,4})(\d{1,3})?(\d{1,3})?/g, function(txt, f, s, t) {
        //     if (t) {
        //         return `(${f}) ${s}-${t}`
        //     } else if (s) {
        //         return `(${f}) ${s}`
        //     } else if (f) {
        //         return `(${f})`
        //     }
        // });
    //});
    
    $(document).ready(function () {
        $('#btn_signup').click(function(){
            let isValid1 = false;
            let isValid2 = false;
            if($('#signupForm').valid()){
                isValid1 = true;
            }
            if(intl.isValidNumber()){
                $('#telephone').removeClass('is-invalid');
                isValid2 = true;
            }else{
                $('#telephone').addClass('is-invalid');
                $('#msg').html("<?php echo e(__('This field is required.')); ?>");
                isValid2 = false;
            }
            if(isValid1 && isValid2){
                $('#btn_signup .spinner').show();
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    data: $('#signupForm').serialize(),
                    url: APP_URL+"/signup-validate",
                    success: function(res) {
                        $('#btn_signup .spinner').hide();
                        if(res.status){
                            window.location.href = APP_URL+'/otp-verification';
                        }
                    },
                    error: function(res) {                    
                        $('#btn_signup .spinner').hide();
                        ajax_error(res);
                    }
                });
            }
        });

        $('#signupForm').validate({
            rules: {
                fname: {
                    required: true,
                },
                lname: {
                    required: true,
                },
                email: {
                    required: true,
                    email:true,
                },
                password: {
                    required: true,
                    minlength: 6,
                    
                },
                retype_password: {
                    required: true,
                    minlength: 6,
                    equalTo: "#password"
                },
            },
            messages: {
                // fname: {
                //     required: 'First name is required.'
                // },
                // lname: {
                //     required: 'Last name is required.'
                // },
                // telephone: {
                //     required: 'Mobile number is required.'
                // },
                // password: {
                //     required: 'Password is required.'
                // },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                // error.addClass('invalid-feedback float-start');
                // element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });  

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/auth/signup.blade.php ENDPATH**/ ?>