  
  <?php $__env->startSection('title', 'Nomadic Studios | Manage Users'); ?>
  <?php $__env->startSection('content'); ?>
  <div class="pagetitle">
    <h1><a href="<?php echo e(url('backend/manage-users')); ?>"><i class="bi bi-arrow-left backarrow"></i></a> Back to manage users</h1>
  </div>
  <section class="section profile">
    <div class="col-xl-12">
      <ul class="nav nav-tabs nav-tabs-bordered" id="borderedTab" role="tablist">
        <li class="nav-item" role="presentation">
          <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#bordered-profile" type="button" role="tab" aria-controls="Profile" aria-selected="true">Profile</button>
        </li>
        <li class="nav-item " role="presentation">
          <button class="nav-link" id="application-tab" data-bs-toggle="tab" data-bs-target="#bordered-application" type="button" role="tab" aria-controls="Application" aria-selected="false">Application</button>
        </li>
        <li class="nav-item" role="presentation">
          <button class="nav-link" id="membership-tab" data-bs-toggle="tab" data-bs-target="#bordered-membership" type="button" role="tab" aria-controls="Membership" aria-selected="false">Membership</button>
        </li>
        <li class="nav-item" role="presentation">
          <button class="nav-link" id="booking-tab" data-bs-toggle="tab" data-bs-target="#bordered-booking" type="button" role="tab" aria-controls="Booking" aria-selected="false">Points Balance</button>
        </li>
      </ul>
      <div class="tab-content pt-2" id="borderedTabContent">
        <div class="tab-pane fade show active" id="bordered-profile" role="tabpanel" aria-labelledby="profile-tab">
          <form id="saveProfile">
            <input type="hidden" name="user_uuid" value="<?php echo e($data->uuid); ?>" readonly>
            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                      <label class="lblprofile">Name</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="text" class="form-control" placeholder="First Name" name="fname" value="<?php echo e($data->fname); ?>">
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="text" class="form-control" placeholder="Last Name" name="lname" value="<?php echo e($data->lname); ?>">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Phone number</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="text" class="form-control" placeholder="Phone" name="phone_number" value="<?php echo e($data->mobile_number); ?>">
                      </div>  
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">User profile</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-5 mb-2 position-relative">
                        <?php if($data->profile_pic): ?>
                        <img src="<?php echo e(asset('storage/profile-pic')); ?>/<?php echo e($data->profile_pic); ?>" class="img-fluid w-100" style="border-radius: 5px;">
                        <?php else: ?>
                        <img src="<?php echo e(asset('images/user-img.png')); ?>" class="img-fluid w-100" style="border-radius: 5px;">
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Description</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <textarea name="description" class="form-control txtarea mb-3" rows="8">Lorem ipsum dolor sit amet, consectetur  adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</textarea>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Language Spoken</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                      <?php echo e($data->languages); ?>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Creative Role</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <?php echo e($data->user_role->role_name); ?>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-4">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Home City</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-8 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                      <?php if(isset($data->user_location->location)): ?><?php echo e($data->user_location->location); ?><?php endif; ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mt-3">
              <div class="col-md-12 text-center">
                <input id="btn_saveprofile" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
              </div>
            </div>
          </form>
        </div>
        <div class="tab-pane fade" id="bordered-application" role="tabpanel" aria-labelledby="application-tab">
          <input type="hidden" id="user_uuid" value="<?php echo e($data->uuid); ?>" readonly>
          <label class="lblprofile">Details</label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Membership Level</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php if($data->user_plan): ?><?php echo e($data->user_plan->name); ?><?php endif; ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">What is your home city?</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php if(isset($data->user_location->location)): ?><?php echo e($data->user_location->location); ?><?php endif; ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">What are you creating?</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($creator_interest); ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Link to Portfolio</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($data->profile_link); ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Link to Instagram</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($data->instagram_link); ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Link to Facebook</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($data->facebook_link); ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Link to Twitter</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($data->twitter_link); ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Link to SM</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($data->sm_link); ?></label>
          <div class="clearboth"></div>
          <label class="lblprofile2 text-muted mt-4">Please provide the name of member who referred you.</label>
          <div class="clearboth"></div>
          <label class="lblprofile2"><?php echo e($data->referred_by); ?></label>
          <div class="clearboth"></div>
          <div class="txt-status">
            <?php if($data->status==2): ?><span class="txtApproved">Approved</span>
            <?php elseif($data->status==3): ?><span class="txtDenied">Denied</span>
            <?php elseif($data->status==4): ?><span class="txtDenied">Suspended</span>
            <?php elseif($data->status==5): ?><span class="txtDenied">Blocked</span>
            <?php endif; ?>
          </div>
          <div class="row mt-3">
            <?php if($data->status!=4): ?>
            <div class="col-md-2">
              <input type="button" class="btn btn-dark btnappaction w-100 mb-2" data-type="muser" data-action="4" value="Suspend">
            </div>
            <?php endif; ?>
            <?php if($data->status!=5): ?>
            <div class="col-md-2">
              <input type="button" class="btn btn-danger btnappaction w-100 mb-2" data-type="muser" data-action="5" value="Block User">
            </div>
            <?php endif; ?>
            <?php if($data->status==4 || $data->status==5): ?>
            <div class="col-md-2">
              <input type="button" class="btn btn-success btnappaction w-100 mb-2" data-type="muser" data-action="2" value="Make Active">
            </div>
            <?php endif; ?>
          </div>
        </div>
        <div class="tab-pane fade" id="bordered-membership" role="tabpanel" aria-labelledby="membership-tab">
          <div class="row mb-4">
            <div class="heading3 mt-3 mb-2">Membership level</div>
            <div class="col-md-11 border border-dark">
            <?php if($plan): ?>
              <div class="p-2 mb-4"><?php echo e($plan->name); ?></div>
              <h3 class="mb-4"><b>$<?php echo e($plan->price); ?></b><span>/<?php echo e($plan->frequency); ?></span></h3>
              <div class="p-2"><i class="bi bi-check2 me-2"></i><?php echo e($plan->points); ?> Pts</div>
              <div class="p-2"><i class="bi bi-check2 me-2"></i>
              <?php if($plan->stripe_plan==""): ?>
              Must be invited by member
              <?php else: ?>
              Book up <?php echo e($plan->advance_duration); ?> <?php echo e($plan->advance_frequency); ?> in advance
              <?php endif; ?>
              </div>
              <div class="p-2"><i class="bi bi-check2 me-2"></i><?php echo e($guests[$plan->num_of_guest]); ?> guests</div>
            <?php else: ?>
              <div class="p-2 mb-4">Guest</div>
            <?php endif; ?>
            </div>
          </div>
          <div class="row ms-1">
            <div class="heading3 ps-0 mb-2">Transactions</div>
            <table class="table">
              <thead>  
                <tr>
                  <td>Date</td>
                  <td>Status</td>
                  <td>Total cost</td>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($point->action=='MEMBERSHIP_CREDIT' || $point->action=='POINTS_PURCHASED'): ?>
                <tr>
                  <td><?php echo e(date('d M Y',strtotime($point->created_at))); ?></td>
                  <td><?php echo e($points_action[$point->action]); ?> <?php if($point->plan_id): ?> (<?php echo e($point->plan->name); ?>) <?php endif; ?></td>
                  <td><?php if($point->amount): ?><?php echo e(convertCurrency($point->amount)); ?><?php else: ?> 0 <?php endif; ?>  <?php echo e(session()->get('user_currency')); ?></td>
                </tr>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div> 
        </div>
        <div class="tab-pane fade" id="bordered-booking" role="tabpanel" aria-labelledby="booking-tab">
          <div class="row mb-4">
            <div class="heading3 mt-3 mb-2">Points balance</div>
            <div class="col-md-11 border border-dark ms-3">
              <div class="row p-2 pt-4">
                <div class="col-md-6">Last month booking cost</div>
                <div class="col-md-5 text-end"><?php echo e($last_month_booking_cost); ?>pts</div>
              </div>
              <div class="row p-2">
                <div class="col-md-6">Current month booking cost</div>
                <div class="col-md-5 text-end"><?php echo e($current_month_booking_cost); ?>pts</div>
              </div>
              <div class="row p-2 pb-4">
                <div class="col-md-6"><b>Current balance</b></div>
                <div class="col-md-5 text-end"><b><?php echo e($current_balance); ?>pts</b></div>
              </div>
            </div>
          </div>
          <div class="row ms-1">
            <div class="heading3 ps-0 mb-2">Transactions</div>
            <table class="table">
              <thead>  
                <tr>
                  <td>Date</td>
                  <td>Status</td>
                  <td>Total cost</td>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e(date('d M Y',strtotime($point->created_at))); ?></td>
                  <td><?php echo e($points_action[$point->action]); ?></td>
                  <td>
                    <?php if($point->action=='POINTS_SENT_EVENT' || $point->action=='POINTS_SENT' || $point->action=='BOOK_EVENT'): ?> <?php echo e($point->debit); ?>pts
                    <?php else: ?> <?php echo e($point->credit); ?>pts <?php endif; ?>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div> 
        </div>
      </div>
    </div>
  </section>
  <?php $__env->stopSection(); ?>
  <?php $__env->startSection('footer_scripts'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('css/quill.snow.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('css/quill.bubble.css')); ?>">
  <script src="<?php echo e(asset('js/quill.min.js')); ?>"></script>
  <script>
    $(document).ready(function () {
      $(document).on('click', '#btn_saveprofile', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#saveProfile').serialize(),
            url: APP_URL+"/save-profile",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status){
                $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                $('#alertMsg').modal('show');
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });
    });
  </script>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/global/user-management.blade.php ENDPATH**/ ?>