
<?php $__env->startSection('title', 'Nomadic-Manage News'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1 class="float-start">Manage News</h1>
  <a class="btn btn-primary float-end" href="<?php echo e(url('backend/news/'.$locId)); ?>"><i class="bi bi-plus"></i> Create News</a>
</div>

<section class="section profile">
  <?php if(session()->has('success')): ?>
  <div class="alert alert-success"><?php echo e(session()->get('success')); ?></div>
  <?php endif; ?>
  <?php if(session()->has('error')): ?>
  <div class="alert alert-danger"><?php echo e(session()->get('error')); ?></div>
  <?php endif; ?>
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search" value="<?php if(request()->get('name')): ?><?php echo e(request()->get('name')); ?><?php endif; ?>">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Date</td>
                <td>Title</td>
                <td>Tags</td>
                <td>CreatedBy</td>
                <td>UpdatedBy</td>
                <td>Action</td>
              </tr>
            </thead>
            <tbody>
              <?php if($data->count()>0): ?>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e(date('d M Y',strtotime($dt->created_at))); ?></td>
                  <td><?php echo e(ucfirst($dt->name)); ?></td>
                  <td><?php echo e($dt->tags); ?></td>
                  <td><?php if($dt->createdBy): ?> <?php echo e($dt->createdBy->fname); ?> <?php echo e($dt->createdBy->lname); ?> <?php endif; ?></td>
                  <td><?php if($dt->updatedBy): ?> <?php echo e($dt->updatedBy->fname); ?> <?php echo e($dt->updatedBy->lname); ?> <?php endif; ?></td>
                  <td>
                    <a href="<?php echo e(url('backend/news/'.$dt->location_id.'/'.$dt->id)); ?>"><i class="bi bi-pencil"></i></a>
                    <a class="delete-record pointer" data-url="<?php echo e(url('backend/delete-news/'.$dt->location_id.'/'.$dt->id)); ?>"><i class="bi bi-trash"></i></a>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>
                <td colspan="6">No record found</td>
              </tr>  
              <?php endif; ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="6">
                  <div class="foot-paging">
                    <?php echo $data->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/content-editing/manage-news.blade.php ENDPATH**/ ?>