
  <?php $__env->startSection('title', 'Nomadic-Account Setting'); ?>
  <?php $__env->startSection('content'); ?>
  <div class="banner"></div>
  <div class="container position-relative" data-aos="fade-up" style="top:50px;padding-bottom:30px;max-width:100%;">
    <h2 class="mt-4 mb-4"><?php echo e(__('Account Settings')); ?></h2>
    <?php if(session('error')): ?>
    <div class="alert alert-danger p-2"><?php echo e(session('error')); ?></div>
    <?php elseif(session('success')): ?>
    <div class="alert alert-success p-2"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <span id="page" style="display:none;">account-setting</span>
    <div class="row mb-5 d-block">
      <div class="col-xl-12">
        <!-- Responsive Tab Dropdown for Mobile -->
        <div class="d-block d-md-none mb-3 position-relative">
          <select class="form-control" id="accountTabDropdown">
            <option value="profile">My Profile</option>
            <option value="membership">Membership</option>
            <option value="booking">Points Balance</option>
            <option value="security">Security</option>
            <option value="calendar" selected>Calendar</option>
          </select>
          <i class="bi bi-caret-down-fill searchicon"></i>
        </div>
        <ul class="nav nav-tabs nav-tabs-bordered d-none d-md-flex" id="borderedTab2" role="tablist">
          <li class="nav-item" role="presentation">
            <a class="nav-link" href="<?php echo e(url('account-setting#profile-tab')); ?>">My Profile</a>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" href="<?php echo e(url('account-setting#membership-tab')); ?>">Membership</a>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" href="<?php echo e(url('account-setting#booking-tab')); ?>">Points Balance</a>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" href="<?php echo e(url('account-setting#security-tab')); ?>">Security</a>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="calendar-tab" data-bs-toggle="tab" data-bs-target="#bordered-calendar" type="button" role="tab" aria-controls="Calendar" aria-selected="false">Calendar</button>
          </li>
        </ul>
        <div class="tab-content pt-2" id="borderedTabContent2">
          <div class="tab-pane fade show active" id="bordered-calendar" role="tabpanel" aria-labelledby="calendar-tab">
            <div class="row mt-4">
              <div class="col-md-8">
                <div id="calendar"></div> 
              </div>
              <div class="col-md-4">
                <div class="col-md-12 p-0">
                  <input type="hidden" id="daily_rate" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>">
                  <input type="hidden" id="hourly_rate" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>">
                  <form id="scheduleCalendar">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="type" name="type" value="resource" readonly>
                    <input type="hidden" id="refrence_id" name="refrence_id" value="<?php echo e($refrence_id); ?>" readonly>
                    <input type="hidden" id="schedule_id" name="schedule_id" value="">
                    <input type="hidden" id="edit_schedule_type" name="edit_schedule_type" value="">
                    <h5 class="fw-bolder mt-2">Availablitiy & prices</h5>
                    
                    <label>Minimum Booking Time</label>
                    <div class="row mb-3">
                      <div class="col-md-3 position-relative mb-1">
                        <select class="form-control" id="min_days" name="min_days">
                          <option value="0" selected>Days</option>
                          <?php for($i = 1; $i <= 30; $i++): ?>
                            <?php $value = str_pad($i, 2, '0', STR_PAD_LEFT); ?>
                            <option value="<?php echo e($value); ?>" <?php if($i==$min_booking['min_days']): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                          <?php endfor; ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                      <div class="col-md-3 position-relative  mb-1">
                        <select class="form-control" id="min_hours" name="min_hours">
                          <option value="00">Hours</option>  
                          <?php for($i = 1; $i <= 23; $i++): ?>
                            <?php $value = str_pad($i, 2, '0', STR_PAD_LEFT); ?>
                            <option value="<?php echo e($value); ?>" <?php if(($i==2 && empty($min_booking['min_hours'])) || $i==$min_booking['min_hours']): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                          <?php endfor; ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                      <div class="col-md-3 position-relative  mb-1">
                        <select class="form-control" id="min_minutes" name="min_minutes">
                          <option value="00" <?php if(00==$min_booking['min_minutes']): ?> selected <?php endif; ?>>Minutes</option>  
                          <option value="15" <?php if(15==$min_booking['min_minutes']): ?> selected <?php endif; ?>>15</option>
                          <option value="30" <?php if(30==$min_booking['min_minutes']): ?> selected <?php endif; ?>>30</option>
                          <option value="45" <?php if(45==$min_booking['min_minutes']): ?> selected <?php endif; ?>>45</option>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                    </div>

                    <label>Maximum Booking Time</label>
                    <div class="row">
                      <div class="col-md-3 position-relative mb-1">
                        <select class="form-control" id="max_days" name="max_days">
                          <option value="0">Days</option>
                          <?php for($i = 1; $i <= 30; $i++): ?>
                            <?php $value = str_pad($i, 2, '0', STR_PAD_LEFT); ?>
                            <option value="<?php echo e($value); ?>" <?php if(($i==5 && empty($max_booking['max_days'])) || $i==$max_booking['max_days']): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                          <?php endfor; ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                      <div class="col-md-3 position-relative mb-1">
                        <select class="form-control" id="max_hours" name="max_hours">
                          <option value="00">Hours</option>  
                          <?php for($i = 1; $i <= 23; $i++): ?>
                            <?php $value = str_pad($i, 2, '0', STR_PAD_LEFT); ?>
                            <option value="<?php echo e($value); ?>" <?php if($i==$max_booking['max_hours']): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                          <?php endfor; ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                      <div class="col-md-3 position-relative mb-1">
                        <select class="form-control" id="max_minutes" name="max_minutes">
                          <option value="00" <?php if(00==$max_booking['max_minutes']): ?> selected <?php endif; ?>>Minutes</option>  
                          <option value="15" <?php if(15==$max_booking['max_minutes']): ?> selected <?php endif; ?>>15</option>
                          <option value="30" <?php if(30==$max_booking['max_minutes']): ?> selected <?php endif; ?>>30</option>
                          <option value="45" <?php if(45==$max_booking['max_minutes']): ?> selected <?php endif; ?>>45</option>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                    </div>
                    
                    <div class="row mt-3">
                      <div class="col-md-11 position-relative">
                        <select class="form-control" id="schedule_location" name="schedule_location">
                          <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($key); ?>"><?php echo e($val); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                    </div>
                    <div class="row mt-3">
                      <div class="col-md-11 position-relative">
                        <select class="form-control" name="availability_type">
                          <option value="0">Daily availability</option>
                          <option value="1">Recurring availability</option>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                      </div>
                    </div>
                    <div id="dailyAvailCont" class="mt-3">
                      <div style="overflow-x:auto">
                        <table class="table table-borderless tbl_boolingdtlsiner avlpricetbl">
                          <thead class="borderbottomnone">
                            <tr>
                              <td class="avltxt" colspan="3"><i class="bi bi-clock"></i> Daily Availability</td>
                              <td class="avltxtsmall">Daily (<?php echo e(session()->get('user_currency')); ?>)</td>
                              <td class="avltxtsmall">Hourly (<?php echo e(session()->get('user_currency')); ?>)</td>
                              <td class="avltxt"><i id="add_daily_click" class="bi bi-plus float-right f20"></i></td>
                            </tr>
                          </thead>
                          <tbody id="daily_container">
                            <tr>
                              <td>
                                <input name="daily_start_date[0]" type="date" class="form-control"  style="width:100px;" data-index="0" onkeyup="validateDateTime(0)">
                              </td>
                              <td><input name="daily_start_time[0]" type="text" class="form-control timepicker" placeholder="Start time" readonly data-index="0" onkeyup="validateDateTime(0)"></td>
                              <td><input name="daily_end_time[0]" type="text" class="form-control timepicker1" placeholder="End time" readonly data-index="0" onkeyup="validateDateTime(0)"></td>
                              <td><input name="daily_daily_rate[0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="daily_hourly_rate[0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td><i class="bi bi-trash daily-trash f20"></i></td>
                            </tr>
                          </tbody>
                        </table>
                      </div>
                      <div class="clearfix"></div>
                    </div>
                    <div id="recuAvailCont" class="mt-4" style="display:none;">
                      <div style="overflow-x:auto">
                        <table class="table table-borderless tbl_boolingdtlsiner mt-4 avlpricetbl">
                          <thead class="borderbottomnone">
                            <tr>
                              <td class="avltxt" colspan="3"><i class="bi bi-clock"></i> Recurring Availability</td>
                              <td class="avltxtsmall">Daily (<?php echo e(session()->get('user_currency')); ?>)</td>
                              <td class="avltxtsmall">Hourly (<?php echo e(session()->get('user_currency')); ?>)</td>
                              <td class="avltxt"></td>
                            </tr>
                          </thead>
                          <tbody>
                            <tr class="row-0">
                              <td class="fw-bold"><input class="recurrchk" data-day="0" name="recurring_days[0]" type="checkbox" value="0">Mon</td>
                              <td>
                                <input name="recurring_start_time[0][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(0,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[0][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(0,0)">
                              </td>
                              <td><input name="recurring_daily_rate[0][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[0][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="0"></i>
                              </td>
                            </tr>
                            <tr class="row-1">
                              <td class="fw-bold"><input class="recurrchk" data-day="1" name="recurring_days[1]" type="checkbox" value="1">Tue</td>
                              <td>
                                <input name="recurring_start_time[1][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(1,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[1][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(1,0)">
                              </td>
                              <td><input name="recurring_daily_rate[1][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[1][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="1"></i>
                              </td>
                            </tr>
                            <tr class="row-2">
                              <td class="fw-bold"><input class="recurrchk" data-day="2" name="recurring_days[2]" type="checkbox" value="2">Wed</td>
                              <td>
                                <input name="recurring_start_time[2][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(2,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[2][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(2,0)">
                              </td>
                              <td><input name="recurring_daily_rate[2][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[2][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="2"></i>
                              </td>
                            </tr>
                            <tr class="row-3">
                              <td class="fw-bold"><input class="recurrchk" data-day="3" name="recurring_days[3]" type="checkbox" value="3">Thu</td>
                              <td>
                                <input name="recurring_start_time[3][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(3,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[3][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(3,0)">
                              </td>
                              <td><input name="recurring_daily_rate[3][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[3][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="3"></i>
                              </td>
                            </tr>
                            <tr class="row-4">
                              <td class="fw-bold"><input class="recurrchk" data-day="4" name="recurring_days[4]" type="checkbox" value="4">Fri</td>
                              <td>
                                <input name="recurring_start_time[4][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(4,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[4][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(4,0)">
                              </td>
                              <td><input name="recurring_daily_rate[4][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[4][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="4"></i>
                              </td>
                            </tr>
                            <tr class="row-5">
                              <td class="fw-bold"><input class="recurrchk" data-day="5" name="recurring_days[5]" type="checkbox" value="5">Sat</td>
                              <td>
                                <input name="recurring_start_time[5][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(5,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[5][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(5,0)">
                              </td>
                              <td><input name="recurring_daily_rate[5][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[5][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="5"></i>
                              </td>
                            </tr>
                            <tr class="row-6">
                              <td class="fw-bold"><input class="recurrchk" data-day="6" name="recurring_days[6]" type="checkbox" value="6">Sun</td>
                              <td>
                                <input name="recurring_start_time[6][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(6,0)">
                              </td>
                              <td>
                                <input name="recurring_end_time[6][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(6,0)">
                              </td>
                              <td><input name="recurring_daily_rate[6][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->daily_rate)); ?>"></td>
                              <td><input name="recurring_hourly_rate[6][0]" type="number" class="form-control" placeholder="0" value="<?php echo e(convertCurrency(auth()->user()->hourly_rate)); ?>"></td>
                              <td>
                                <i class="bi bi-plus add-recurring-days f20" data-day="6"></i>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </div>
                    </div>
                    <!-- <h6 class="fw-bold mt-3 mb-3"><i class="bi bi-globe2"></i> Timeszones</h6> -->
                    <div class="col-md-12 mb-2 mt-2 position-relative">
                      <!-- <select class="form-control">
                        <option>Bali, Indonesia (GMT + 8)</option>
                      </select> 
                      <i class="bi bi-caret-down-fill searchicon rgt0"></i> -->
                      <div class="text-center mt-4 mb-2">
                        <button id="schedule_save" type="button" class="btn btn-primary">Save</button>
                        <button id="schedule_reset" type="button" class="btn btn-primary">Reset</button>
                      </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- <div class="modal fade" id="otp_modal" style="display:none;z-index:10000;"></div> -->
  <?php $__env->stopSection(); ?>
  <?php $__env->startSection('footer_scripts'); ?>
  <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
  <script src='https://cdn.jsdelivr.net/npm/@fullcalendar/bootstrap5@6.1.9/index.global.min.js'></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
  <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script> -->
  <script>
    $(document).ready(function (){
      scheduleCalendarInit();
      
      $(document).on('change','#accountTabDropdown', function() {
        var val = $(this).val();
        console.log(val);
        if(val === 'calendar') {
          // Already on calendar, do nothing
        } else {
          var url = '';
          if(val === 'profile') url = "<?php echo e(url('account-setting#profile-tab')); ?>";
          if(val === 'membership') url = "<?php echo e(url('account-setting#membership-tab')); ?>";
          if(val === 'booking') url = "<?php echo e(url('account-setting#booking-tab')); ?>";
          if(val === 'security') url = "<?php echo e(url('account-setting#security-tab')); ?>";
          if(url) window.location.href = url;
        }
      });
    })
</script>
 <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/user/account-setting-calendar.blade.php ENDPATH**/ ?>