
<?php $__env->startSection('title', 'My Profile'); ?>
<?php $__env->startSection('content'); ?>
<div class="logged-in-home-page">
  <?php if(auth()->user()->role!='guest'): ?>
  <section class="search-section container">
    <div class="row">
      <div class="col-md-12 search-form-container">
        <h1>What you need to create</h1>
        <input type="hidden" id="myemail" value="<?php echo e(auth()->user()->email); ?>" readonly>
        <form id="bookingForm">
          <?php echo csrf_field(); ?>
          <div class="row">
            <div class="col-md-2 position-relative mb-4">
              <h6 class="lblbooking">Where</h6>
              <select name="txt_location" class="form-control">
                <option value="">Location</option>
                <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($loc->id); ?>"><?php echo e($loc->location); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-2 mb-4">
              <h6 class="lblbooking">Start</h6>
              <input name="txt_start_date" type="date" class="form-control" min="<?php echo e($advance_date_flag); ?>" onkeydown="return false;" />
            </div>
            <div class="col-md-2 mb-4">
              <h6 class="lblbooking">&nbsp;</h6>
              <input name="txt_start_time" type="text" class="form-control timepicker" readonly>
            </div>
            <div class="col-md-2 mb-4">
              <h6 class="lblbooking">End</h6>
              <input name="txt_end_date" type="date" class="form-control" min="<?php echo e($advance_date_flag); ?>" onkeydown="return false;" />
            </div>
            <div class="col-md-2 mb-4">
              <h6 class="lblbooking">&nbsp;</h6>
              <input name="txt_end_time" type="text" class="form-control timepicker1" readonly>
            </div>
            <div class="col-md-2 mb-4">
              <button id="btn_booking_form" type="button" class="btn btn-primary d-block mt27">Search <div class="spinner-border spinner-border-sm text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">Loading...</span></div></button>
            </div>
          </div>
          <div class="row">
            <?php if($pending_booking!=""): ?>
            <div class="col-md-4 pending-booking">
              <div class="minimumtimeinfo mb-2">
                <a href="<?php echo e($pending_booking); ?>"><i class="bi bi-clock"></i> Resume in-progress booking</a>
                <span class="ms-2"><i class="bi bi-trash pointer clear-booking"></i></span>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </form>
      </div>
    </div>
  </section>
  <section>
  <?php endif; ?>

  <section <?php if(auth()->user()->role=='guest'): ?> class="mt-9" <?php endif; ?>>
    <div class="container" data-aos="fade-up">
      <div class="row gx-5">
        <div class="col-md-7">
          <div class="heading5 p-2">Upcoming reservations</div>
          <div class="org-line1 mb-4"></div>
          <div class="clearfx"></div>
          <?php if($bookings->count() > 0): ?>
          <div class="row">
            <div class="col-md-12">
              <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="row">
                <div class="card boxshadow">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-4 mb-2 position-relative">
                        <div class="imgbox1">
                          <img class="imgfluidlogged" src="<?php echo e(url('storage/location/'.$book->locLanding->banner_picture)); ?>" height="200">
                        </div>
                      </div>
                      <div class="col-md-8 mb-2 position-relative">
                        <label>Date</label>
                        <div class="cleaefix"></div>
                        <div class="fw-bold">
                        <?php echo e(date('d M, Y', strtotime($book->start_date))); ?> <?php echo e(date('g:i A',strtotime($book->start_time))); ?> - <?php echo e(date('d M, Y', strtotime($book->end_date))); ?> <?php echo e(date('g:i A',strtotime($book->end_time))); ?>

                        </div>
                        <div class="cleaefix"></div>
                        <table class="table table-borderless">
                          <thead>
                            <tr>
                              <td>Location</td>
                              <td>Studio</td>
                              <td>Equipment</td>
                              <td>Resource</td> 
                            </tr>
                          </thead>
                          <tbody>
                            <tr>
                              <th><?php echo e($book->loc->location); ?></th>
                              <th><?php if($book->studioNum): ?> Y <?php endif; ?></th>
                              <th><?php if($book->equipNum): ?> Y <?php endif; ?></th>
                              <th><?php if($book->resourceNum): ?> Y <?php endif; ?></th>
                            </tr>
                            <tr>
                              <th colspan="3">
                                <label class="fw-bold"><?php echo e($book->total_points); ?> pts</label>
                              </th>
                              <th>
                                <a href="<?php echo e(url('booking-confirmed/'.$book->booking_id)); ?>" style="color:#000000;">See Detail
                                  <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
                                  </svg>
                                </a>
                              </th>
                            </tr>            
                          </tbody>
                        </table>
                      </div>
                    </div>        
                  </div>
                </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <div>
                <a href="<?php echo e(url('booking-list')); ?>" style="color:#000000;">See All
                  <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
                </svg>
                </a>
              </div>
            </div>
          </div>
          <?php else: ?>
          <div class="row">
            <div class="col-md-8 mx-auto" style="margin:60px 0">
              <div class="row create-booking-images">
                <div class="col-md-4" style="margin-top:100px;">
                  <img src="<?php echo e(asset('images/profile-1.png')); ?>" class="img-fluid" />
                </div>
                <div class="col-md-4" style="margin-top:100px;">
                  <img src="<?php echo e(asset('images/profile-2.png')); ?>" class="img-fluid" />
                </div>
                <div class="col-md-4 mt-2">
                  <img src="<?php echo e(asset('images/profile-3.png')); ?>" class="img-fluid" />
                </div>
              </div>
              <div class="row mt-4">
                <div class="col-md-8 mx-auto text-center">
                  <h5>What you need to create</h5>
                  <button type="button" class="btn btn-primary mt-2">Create booking </button>
                </div>
              </div>
            </div>
          </div>
          <?php endif; ?>
        </div>
        <div class="col-md-5">
          <div class="row">
            <div class="col-md-6">
              <div class="heading5 p-2">Guest invitations</div>
            </div>
            <div class="col-md-6">
              <a class="btn btn-primary mt-2" href="<?php echo e(url('invite-guest')); ?>">Invite Guest</a>
            </div>
          </div>
          <div class="org-line1 mb-4"></div>
          <div class="clearfx"></div>
          <?php if($invitations->count() > 0): ?>
            <div class="row">
              <div class="col-md-12">
                <?php $__currentLoopData = $invitations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row">
                  <div class="card boxshadow height165 invitedcard pointer" data-id="<?php echo e($inv->id); ?>">
                    <div class="card-body pt-3">
                      <div class="row">
                        <div class="col-md-4 mb-2 position-relative">
                          <div class="imgbox150">
                            <?php if($inv->profile_pic): ?>
                            <img src="<?php echo e(asset('storage/profile-pic')); ?>/<?php echo e($data->profile_pic); ?>" class="imgfluidlogged1" height="150">
                            <?php else: ?>
                            <img src="<?php echo e(asset('images/user-img.png')); ?>" class="imgfluidlogged1" height="150">
                            <?php endif; ?>
                          </div>
                        </div>
                        <div class="col-md-8 mb-2 position-relative">
                          <label>Date</label>
                          <div class="cleaefix"></div>
                          <div class="fw-bold"><?php echo e(date('g:i A',strtotime($inv->invitation_time))); ?>, <?php echo e(date('d M Y', strtotime($inv->invitation_date))); ?></div>
                          <div class="cleaefix"></div>
                          <table class="table table-borderless">
                            <thead>
                              <tr>
                                <td>Location</td>
                                <td>My <?php if($inv->host_uuid==auth()->user()->uuid): ?>Guest <?php else: ?> By <?php endif; ?></td>
                              </tr>
                            </thead>
                            <tbody>
                              <tr>
                                <th><?php echo e(ucfirst($inv->location->location)); ?></th>
                                <th>
                                  <?php echo e(ucfirst($inv->guest->fname)); ?> <?php echo e(ucfirst($inv->guest->lname)); ?>

                                </th>
                              </tr>
                            </tbody>
                          </table>
                        </div>
                      </div>        
                    </div>
                  </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
            <?php if($invcount > 3): ?>
            <a href="<?php echo e(url('invitations')); ?>" style="color:#000000;">See All
              <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
              </svg>
            </a>
            <?php endif; ?>
          <?php else: ?>
            <?php if(in_array(auth()->user()->role,['member','admin','super-admin'])): ?>
            <div class="row">
              <div class="col-md-8 mx-auto">
                <div class="text-center">
                  <img src="<?php echo e(asset('images/avatar-1.png')); ?>" class="img-fluid" />
                  <img src="<?php echo e(asset('images/avatar-3.png')); ?>" class="img-fluid avtr3" />
                  <img src="<?php echo e(asset('images/avatar-2.png')); ?>" class="img-fluid avtr2" />
                </div>
                <div class="row mt-4">
                  <div class="col-md-12 text-center">
                    <h5>Do you want to bring guest?</h5>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent tristique leo vitae purus lacinia, ut euismod nulla viverra. Duis rutrum fringilla vestibulum. Quisque gravida, tortor eget accumsan aliquet.</p>
                    <a class="btn btn-primary mt-3" href="<?php echo e(url('invite-guest')); ?>">Invite Guest </a>
                    <a class="btn btn-primary ms-3 mt-3" href="<?php echo e(url('invited-guest')); ?>">Guest List</a>
                  </div>
                </div>
              </div>
            </div>
            <?php else: ?>
            <div class="row">
              <div class="col-md-12 text-center">
                <p>No pending invitation.</p>
              </div>
            </div>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>

  <section class="p-0">
    <div class="container" data-aos="fade-up">
      <div class="row gx-5">
        <div class="col-md-8">
          <div class="heading5 p-2">Related news</div>
          <div class="org-line1 mb-4"></div>
          <div class="clearfx"></div>
          <div class="row">
          <?php if($related_news): ?>
            <?php $__currentLoopData = $related_news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rnews): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4">
              <div class="card boxshadow">
                <div class="card-body pt-3">
                  <div class="col-md-12 mb-2 position-relative">
                    <img src="<?php echo e(asset('storage/location/news/'.$rnews->conclusion_picture)); ?>" class="img-thumbnail rounded-0 p-0">
                    <div class="clearfix"></div>
                    <small class="mt-2 mb-2 d-block text-success"><?php echo e(Str::limit($rnews->tags,20)); ?></small>
                    <div class="clearfix"></div>
                    <div class="float-start">
                      <h5><?php echo e(Str::limit($rnews->name,20)); ?></h5>
                    </div>
                    <div class="float-end">
                    <a href="<?php echo e(url('view-news/'.$rnews->id)); ?>" style="color:#000000;"><i class="bi bi-arrow-up-right" style="cursor:pointer;"></i></a>
                    </div>
                    <div class="clearfix"></div>
                    <p class="mb-2 d-block font13px"><?php echo e(Str::limit($rnews->heading_intro,30)); ?></p>
                    <div class="clearfix"></div>
                    <div class="d-inline">
                      <?php if($rnews->createdBy->profile_pic): ?>
                      <img src="<?php echo e(asset('storage/profile-pic/'.$rnews->createdBy->profile_pic)); ?>" alt="Profile" class="rounded-circle height35">
                      <?php else: ?>
                      <img src="<?php echo e(asset('images/user-img.png')); ?>" alt="Profile" class="rounded-circle height35">
                      <?php endif; ?>
                    </div>
                    <div class="d-inline">
                      <span class="font13px" style="font-weight:100;"><?php echo e(ucfirst($rnews->createdBy->fname)); ?> <?php echo e(ucfirst($rnews->createdBy->lname)); ?></span>
                      <div class="font12px" style="margin-top:-15px;margin-left:40px;"><?php echo e(date('d l Y',strtotime($rnews->created_at))); ?></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
          </div>
        </div>
        <div class="col-md-4">
          <div class="heading5 p-2">Social feed</div>
          <div class="org-line1 mb-4"></div>
          <div class="clearfx"></div>
          <div class="row">
            <div class="col-md-12">
              <div class="card bordertop2">
                <div class="card-body pt-3">
                  <div class="col-md-12 mb-2 position-relative">
                    <div class="d-inline">
                      <img src="http://localhost/nomadic/public/images/user-img.png" alt="Profile" class="rounded-circle height35">
                    </div>
                    <div class="d-inline">
                    <b>Nolan Stanton</b> <a class="text-primary">@Nolan Stanton</a><a class="text-primary m-lg-3">25s</a>
                    <div class="clearfix"></div>
                    <div class="font13px offset-1 mb-2">13 Places Where You Can See the Bluest Water in 
                      the World</div>
                    </div>
                    <img src="http://localhost/nomadic/public/img/socialfeed1.jpg" class="imgfluid imgradius">
                    <div class="clearfix"></div>
                    <div class="float-start w-50 mt-3">
                    <div class="d-inline">
                    <i class="bi bi-chat text-primary"></i>
                    <a class="text-primary ms-3 font13px">61</a>
                    <i class="bi bi-repeat ms-3 text-primary"></i>
                    <a class="text-primary ms-3 font13px">12</a>
                    </div>
                    
                    </div>
                    <div class="float-end w-50 mt-3">
                      <div class="d-inline">
                        <i class="bi bi-heart-fill text-danger"></i>
                        <a class="text-danger ms-3 fw-bold font13px">6.2k</a>
                        <i class="bi bi-upload ms-5 text-primary"></i>
                        <a class="text-primary ms-3 font13px">61</a>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <small class="mt-2 mb-2 d-block fw-bold text-primary">Show this thread</small>
                    
                  </div>
              </div>
            </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12">
              <div class="card bordertop2">
                <div class="card-body pt-3">
                  <div class="col-md-12 mb-2 position-relative">
                    <div class="d-inline">
                      <img src="http://localhost/nomadic/public/images/user-img.png" alt="Profile" class="rounded-circle height35">
                    </div>
                    <div class="d-inline">
                    <b>Nolan Stanton</b> <a class="text-primary">@Nolan Stanton</a><a class="text-primary m-lg-3">25s</a>
                    <div class="clearfix"></div>
                    <div class="font13px offset-1 mb-2">13 Places Where You Can See the Bluest Water in 
                      the World</div>
                    </div>
                    <img src="http://localhost/nomadic/public/img/socialfeed1.jpg" class="imgfluid imgradius">
                    <div class="clearfix"></div>
                    <div class="float-start w-50 mt-3">
                    <div class="d-inline">
                    <i class="bi bi-chat text-primary"></i>
                    <a class="text-primary ms-3 font13px">61</a>
                    <i class="bi bi-repeat ms-3 text-primary"></i>
                    <a class="text-primary ms-3 font13px">12</a>
                    </div>
                    
                    </div>
                    <div class="float-end w-50 mt-3">
                      <div class="d-inline">
                        <i class="bi bi-heart-fill text-danger"></i>
                        <a class="text-danger ms-3 fw-bold font13px">6.2k</a>
                        <i class="bi bi-upload ms-5 text-primary"></i>
                        <a class="text-primary ms-3 font13px">61</a>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <small class="mt-2 mb-2 d-block fw-bold text-primary">Show this thread</small>       
                  </div>
              </div>
            </div>
            </div>
          </div>    
          <div class="text-center">
            <button type="button" class="btn2 btnseedetails">See all
              <i class="bi bi-arrow-up-right mlmr"></i>
              </button>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="upcomingeventbg mt-5">
    <?php echo $__env->make('frontend.event.upcoming-events', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </section>
</div>
<script>
  $(document).ready(function(){
    $(document).on('click', '.invaction', function(){ 
      let upcoming_id = $(this).data('guest');
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:1},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            $('#guest_modal').modal('hide');
            $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">CheckedIn successfully.</div>');
            $('#alertMsg').modal('show');
          }else{
            $('#general_modal .modal-title').html('Recharge your wallet');
            $('#general_modal .modal-body').html(res.content);
            $('#general_modal').modal('show');
          }
        },
        error: function(res) {                    
          //ajax_error(res);
        }
      });
    });
  });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/my-profile.blade.php ENDPATH**/ ?>