
<?php $__env->startSection('title', 'Booking | Select Equipment'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Create something with us!')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/booking-banner.png')); ?>">
</div>

<section class="visible">
    <div class="container text-dark mt-3" data-aos="fade-up">
        <div class="row">
            <div class="col-md-8">
                <?php if($equipments->count() > 0): ?>
                <h2 class="mb-4">Select equipment you want to rent</h2>
                <?php $__currentLoopData = $equipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row col-md-12 mt-3 <?php if(!$equipment->available): ?> text-muted <?php endif; ?>">
                    <div class="col-md-1">
                        <div>
                            <input id="checkbox-<?php echo e($loop->index); ?>" class="checkbox-custom" value="<?php echo e($equipment->id); ?>" name="booking_equipment" type="radio" data-type="equipment" data-days="<?php echo e($equipment->booking_days); ?>" data-hours="<?php echo e($equipment->booking_hours); ?>" <?php if(session()->has('temp-booking-equipment-selection') && session()->get('temp-booking-equipment-selection')==$equipment->id): ?>checked <?php endif; ?> <?php if(!$equipment->available): ?> disabled <?php endif; ?>>
                            <label for="checkbox-<?php echo e($loop->index); ?>" class="checkbox-custom-label"></label>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <h3><?php echo e($equipment->name); ?></h3>
                        <?php if(isset($equipment->resourceTypes->name)): ?><p class="fw-bold c-red text-center mt-4">Require <?php echo e($equipment->resourceTypes->name); ?></p><?php endif; ?>
                        <?php if($equipment->description): ?>
                        <div class="mt-2"><?php echo e($equipment->description); ?></div>
                        <?php endif; ?>
                        <?php if(!$equipment->available): ?>
                        <p>equipment is booked at this time please select different time. <span class="text-primary pointer check-availability">check availability</span></p>
                        <div class="availability-calendar" data-id="<?php echo e($equipment->id); ?>" data-type="equipment"></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-2">
                        <h3><?php echo e($equipment->equipment_points); ?>pts</h3>
                    </div>
                    <div class="col-md-4">
                        <div class="imgbox">
                            <img src="<?php echo e(url('storage/rental/'.$equipment->photo)); ?>" class="imgfluidlogged <?php if(!$equipment->available): ?> opacity-50 <?php endif; ?>" />
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="row col-md-12 mt-5">
                    <div class="foot-paging">
                    <?php echo $equipments->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                    </div>
                </div>
                <?php else: ?>
                <h2 class="mt-4">Equipments are not available this time.</h2>
                <?php endif; ?>
            </div>
            <div class="col-md-4 p-0">
                <?php echo $__env->make('frontend.booking.booking-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script>
    $(document).ready(function () {
        
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/booking/equipment.blade.php ENDPATH**/ ?>