
<?php $__env->startSection('title', 'Nomadic-Profile Picture'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="sub-head mt-4 mb-4"><?php echo e(__('Upload profile picture')); ?></h2>
    <span><?php echo e(__('Please upload your profile picture.')); ?></span>
    <input type="hidden" id="sessuuid" value="<?php echo e($sess_uuid); ?>" readonly>
    <input type="hidden" id="selected_plan" value="<?php echo e($selected_plan); ?>" readonly>
    <?php if(is_null(auth()->user()->profile_pic)): ?>
    <div id="webcamcls" class="row mb-5 mt-4" align="center">
        <input type="hidden" name="image" class="image-tag">
        <div class="col-md-6">
            <div id="my_camera"></div>
        </div>
        <div class="col-md-6">
            <div id="cam_picture"></div>
        </div>
    </div>
    <div id="drpzonecls" class="row mt-4" align="center">
        <div class="col-md-12">
            <form action="<?php echo e(url('save-profile-picture')); ?>" method="post" enctype="multipart/form-data" id="imageUpload" class="dropzone">
                <?php echo csrf_field(); ?>
                <div class="upicon mt-3">
                    <!-- <i class="bi bi-cloud-upload uploadcamra" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Upload" data-bs-original-title="Upload"></i> -->
                    <i class="bi bi-camera uploadcamra" onclick="openCam()" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Camra" data-bs-original-title="Camera"></i>
                </div>
            </form>
        </div>
    </div>
    <div class="row mt-4 d-block" align="center">
        <div class="form-container">
            <div class="btnconter mt-3 mb-4">
                <button class="btn btn-primary" type="button" id="btn_uploadpicture"><?php echo e(__('Upload picture')); ?>

                    <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden"><?php echo e(__('Loading')); ?>...</span></div>
                </button>
                <button class="btn btn-primary" type="button" id="btn_snapshot" style="display:none;" onClick="take_snapshot()"><?php echo e(__('Take Snapshot')); ?></button>
                <button class="btn btn-primary" type="button" id="btn_cancel" style="display:none;"><?php echo e(__('Cancel')); ?></button>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="row mt-4 mb-4 d-block" align="center">
        <div class="col-md-4">
            <img src="<?php echo e(url('/')); ?>/storage/profile-pic/<?php echo e(auth()->user()->profile_pic); ?>" class="img-fluid w-100" style="border-radius:5px;">
            <i class="bi bi-trash3 dlteprofilepic dlteppic1" data-uuid="<?php echo e($sess_uuid); ?>" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Delete" data-bs-original-title="Delete"></i>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script src="<?php echo e(asset('js/webcam.min.js')); ?>"></script>
<link href="<?php echo e(asset('css/dropzone.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('css/dropzone.custom.css')); ?>" rel="stylesheet">
<script src="<?php echo e(asset('js/dropzone.js')); ?>"></script>
<style>
    #my_camera video{
        object-fit:cover;
    }
</style>
<script>
    Dropzone.autoDiscover = false;
    var myDropzone = new Dropzone("#imageUpload",{ 
        maxFiles: 1,
        maxFilesize: 100,
        autoProcessQueue: false,
        uploadMultiple: false, 
        addRemoveLinks: true,
        acceptedFiles: ".jpeg,.jpg,.png,.pdf",
        //disablePreviews:true
    });
    myDropzone.on("addedfiles", function(files) {
        console.log(files.length + ' files added');
        $('.upicon').hide();
    });
    myDropzone.on("sending", function(file, xhr, formData) {
        $('#btn_uploadpicture .spinner').show();
       formData.append("uuid", $('#sessuuid').val());
    });
    myDropzone.on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    myDropzone.on("complete", function (file) {
      console.log('completed');
    });
    myDropzone.on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
        $('#btn_uploadpicture .spinner').hide();
    });
    myDropzone.on("success", function (file, errorMessage) {
        console.log('success');
        $('#btn_uploadpicture .spinner').hide();
        let selected_plan = $('#selected_plan').val();
        let redirect = (selected_plan=='guest') ? APP_URL + '/congratulations' : APP_URL + '/plans/'+selected_plan;
        window.location.href = redirect;
    });
    myDropzone.on("removedfile", function (file) {
      console.log('removed');
      $('.upicon').show();
    });
    $(document).ready(function(){
        $("#btn_uploadpicture").click(function (e) {
            let datauri = $.trim($('.image-tag').val());
            if(datauri!=""){
                let uuid = $('#sessuuid').val();
                $('#btn_uploadpicture .spinner').show();
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    data: {_token:_token, uuid:uuid, type:'cam', image:datauri},
                    url: APP_URL+"/save-profile-picture",
                    success: function(res) {
                        $('#btn_uploadpicture .spinner').hide();
                        if(res.status){
                            let selected_plan = $('#selected_plan').val();
                            let redirect = (selected_plan=='guest') ? APP_URL + '/congratulations' : APP_URL + '/plans/'+selected_plan;
                            window.location.href = redirect;
                        }
                    },
                    error: function(res) {                    
                        $('#btn_uploadpicture .spinner').hide();
                        ajax_error(res);
                    }
                });
            }else{
                e.preventDefault();
                myDropzone.processQueue();
            }
        });

        $(document).on('click','#btn_cancel',function(){
            $('.image-tag').val('');
            $('#btn_cancel').hide();
            $('#btn_snapshot').hide();
            $('#drpzonecls').show();
            $('#webcamcls').hide();
            //$('#webcamcls').removeAttr('display');
            Webcam.reset();
        });
    });
    function openCam(){
        $('#btn_cancel').show();
        $('#btn_snapshot').show();
        $('#drpzonecls').hide();
        $('#webcamcls').css('display','flex');
        Webcam.set({
            // width: 490,
            // height: 350,
            image_format: 'jpeg',
            jpeg_quality: 90
        });
        Webcam.attach('#my_camera');
    }
    function take_snapshot() {
        Webcam.snap( function(data_uri) {
            $(".image-tag").val(data_uri);
            $('#cam_picture').html('<img src="'+data_uri+'"/>');
        } );
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/auth/profile-picture.blade.php ENDPATH**/ ?>