import { Outlet } from "react-router-dom";

export default function Layout() {
	return (
		<div className="min-h-screen bg-background">
			<header className="border-b">
				<div className="container mx-auto px-4 py-4">
					<div className="flex items-center justify-between">
						<div className="flex items-center space-x-2">
							<h1 className="text-2xl font-bold">Nomadics</h1>
							<span className="text-sm text-muted-foreground">Studios</span>
						</div>
					</div>
				</div>
			</header>

			<main className="container mx-auto px-4 py-8">
				<Outlet />
			</main>

			<footer className="border-t mt-16">
				<div className="container mx-auto px-4 py-8">
					<div className="text-center text-sm text-muted-foreground">
						© 2024 Nomadics. All rights reserved.
					</div>
				</div>
			</footer>
		</div>
	);
}
