import { SectionHeader } from "~/components/shared/SectionHeader";
import { LocationAccordion } from "./components/LocationAccordion";
import { getAllLocations, type Location } from "~/config/cities";

// Use the centralized city/location system
const locationsData = getAllLocations();

export function LocationsSection() {
  return (
    <section className="relative w-full bg-neutral-900 text-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        {/* Header */}
        <div className="mb-10 lg:mb-16">
          <SectionHeader
            eyebrow="COMMUNITIES"
            title="SEE OUR LOCATIONS"
            className="flex-1 max-w-[991px] [&_span]:text-white/60 [&_h2]:text-white"
          />
        </div>

        {/* Accordion List */}
        <LocationAccordion locations={locationsData} />
      </div>
    </section>
  );
}
