import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "~/components/ui/accordion";
import { ChevronDown, ArrowRight } from "lucide-react";
import { Button } from "~/components/ui/button";
import type { Location } from "../LocationsSection";

interface LocationAccordionProps {
  locations: Location[];
}

export function LocationAccordion({ locations }: LocationAccordionProps) {
  return (
    <Accordion type="single" collapsible className="w-full" defaultValue="1">
      {locations.map((location, index) => {
        const formattedIndex = String(index + 1).padStart(2, "0");

        return (
          <AccordionItem
            key={location.id}
            value={location.id}
            className="border-b border-white/10"
          >
            <AccordionTrigger className="hover:no-underline py-8 group [&[data-state=open]>div>svg]:rotate-180">
              <div
                className="grid grid-cols-1 md:grid-cols-2 
     items-center w-full"
              >
                <div className="flex items-center gap-8">
                  <span className="text-heading-3 font-light text-white/30 min-w-[4rem]">
                    {formattedIndex}
                  </span>
                  <div>
                    <h3 className="text-heading-5 lg:text-heading-4 tracking-[-0.01em] text-white uppercase text-left">
                      {location.name}
                    </h3>
                  </div>
                </div>
                <span className="text-body-3 text-left  text-white/60 uppercase tracking-wider ">
                  {location.meta}
                </span>
                <div></div>
              </div>
            </AccordionTrigger>

            <AccordionContent className="pb-8 pl-[6rem]">
              <div className="grid grid-cols-1 lg:grid-cols-2 gap-4 mb-6">
                <div className="aspect-[4/3] overflow-hidden rounded-lg">
                  <img
                    src={location.image}
                    alt={`${location.name}, ${location.country}`}
                    className="h-full w-full object-cover max-w-[500px]"
                    loading="lazy"
                  />
                </div>
                <div className="aspect-[4/3] overflow-hidden rounded-lg">
                  <img
                    src={location.image}
                    alt="Studio interior"
                    className="h-full w-full object-cover max-w-[500px]"
                    loading="lazy"
                  />
                </div>
              </div>

              <p className="text-body-3 text-white/80 mb-6 ">
                {location.content}
              </p>

              <div className="flex items-center justify-end">
                <Button
                  asChild
                  variant="outline-white"
                  size="lg"
                  className="bg-transparent border-white/30 text-white hover:bg-white/10 hover:border-white/50 uppercase tracking-wider font-medium "
                >
                  <a href={location.href} className="flex items-center gap-2">
                    EXPLORE {location.name} STUDIOS
                    <ArrowRight className="h-4 w-4" />
                  </a>
                </Button>
              </div>
            </AccordionContent>
          </AccordionItem>
        );
      })}
    </Accordion>
  );
}
