import { HeroSection } from "./components/HeroSection";
import { HeroActions } from "./components/HeroActions";

const heroActions = [
  {
    label: "Apply for membership",
    href: "/apply",
    variant: "fill-white" as const,
    icon: true,
  },
  {
    label: "Explore services",
    href: "/services",
    variant: "outline-white" as const,
  },
];

export function WelcomeSection() {
  return (
    <HeroSection
      backgroundImage="/images/home/welcome.png"
      title="WHAT YOU NEED <br /> TO CREATE"
      subtitle={{
        mobile:
          "We empower creators to transform ideas into reality wherever they are",
        desktop:
          "Nomadic Studios empowers creators to transform ideas into reality wherever they are",
      }}
    >
      <HeroActions actions={heroActions} />
    </HeroSection>
  );
}
