import { Link } from "@remix-run/react";
import { ArrowRight } from "lucide-react";
import { Button } from "~/components/ui/button";

interface HeroAction {
  label: string;
  href?: string;
  onClick?: () => void;
  variant: "fill-white" | "outline-white";
  icon?: boolean;
}

interface HeroActionsProps {
  actions: HeroAction[];
}

export function HeroActions({ actions }: HeroActionsProps) {
  return (
    <div className="flex flex-col sm:flex-row items-center gap-4">
      {actions.map((action, index) => {
        if (action.onClick) {
          return (
            <Button
              key={index}
              variant={action.variant}
              size="lg"
              className="w-full sm:w-auto"
              onClick={action.onClick}
            >
              {action.label}
              {action.icon && <ArrowRight className="h-5 w-5" />}
            </Button>
          );
        }
        
        return (
          <Button
            key={index}
            asChild
            variant={action.variant}
            size="lg"
            className="w-full sm:w-auto"
          >
            <Link to={action.href!}>
              {action.label}
              {action.icon && <ArrowRight className="h-5 w-5" />}
            </Link>
          </Button>
        );
      })}
    </div>
  );
}
