import { SectionHeader } from "~/components/shared/SectionHeader";
import { LocationIcon } from "./components/LocationIcon";
import { ClockIcon } from "./components/ClockIcon";
import { PhoneIcon } from "./components/PhoneIcon";
import { EmailIcon } from "./components/EmailIcon";

interface PlanYourVisitSectionProps {
  address: string;
  hours: string;
  phone: string;
  email: string;
  additionalInfo: string;
  title?: string;
  location?: string;
}

export function PlanYourVisitSection({
  address,
  hours,
  phone,
  email,
  additionalInfo,
  title,
  location,
}: PlanYourVisitSectionProps) {
  return (
    <section className="relative w-full bg-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        {title && <SectionHeader title={title} className="mb-4" />}

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 lg:gap-12 mb-12 lg:mb-16">
          <div className="border-r border-black/10 pr-8 lg:pr-12">
            <div className="flex items-center gap-3 mb-4">
              <h3 className="text-plan-header text-black/60">ADDRESS</h3>
            </div>
            <div className="flex items-start gap-3">
              <div className="mt-1">
                <LocationIcon />
              </div>
              <p className="text-body-3 !text-black">{address}</p>
            </div>
          </div>

          <div className="border-r border-black/10 pr-8 lg:pr-12">
            <div className="flex items-center gap-3 mb-4">
              <h3 className="text-plan-header text-black/60">OPENING HOURS</h3>
            </div>
            <div className="flex items-center gap-3">
              <ClockIcon />
              <p className="text-body-3 !text-black">{hours}</p>
            </div>
          </div>

          <div className="border-r border-black/10 pr-8 lg:pr-12">
            <div className="flex items-center gap-3 mb-4">
              <h3 className="text-plan-header text-black/60">CONTACT</h3>
            </div>
            <div className="space-y-4">
              <div className="flex items-center gap-3">
                <div>
                  <PhoneIcon />
                </div>
                <p className="text-body-3 !text-black">{phone}</p>
              </div>
              <div className="flex items-start gap-3">
                <div className="mt-1">
                  <EmailIcon />
                </div>
                <p className="text-body-3 !text-black">{email}</p>
              </div>
            </div>
          </div>

          <div>
            <div className="flex items-center gap-3 mb-4">
              <h3 className="text-plan-header text-black/60">
                ADDITIONAL INFORMATION
              </h3>
            </div>
            <p className="text-body-3 !text-black">{additionalInfo}</p>
          </div>
        </div>

        <div className="mapouter" style={{ width: "100%", height: "400px" }}>
          <iframe
            className="gmap_iframe"
            width="100%"
            height="400"
            frameBorder={0}
            scrolling="no"
            marginHeight={0}
            marginWidth={0}
            src={`https://maps.google.com/maps?width=1324&height=400&hl=en&q=${encodeURIComponent(
              location || address
            )}&t=&z=14&ie=UTF8&iwloc=B&output=embed`}
          ></iframe>
        </div>
      </div>
    </section>
  );
}
