import { SectionHeader } from "~/components/shared/SectionHeader";
import { ImageGrid, type ImageGridItem } from "~/components/shared/ImageGrid";
import { useNavigate } from "@remix-run/react";

interface Studio {
  id: string;
  image: string;
  title: string;
}

interface StudiosData {
  sectionTitle: string;
  studios: Studio[];
}

interface StudiosSectionProps {
  data: StudiosData;
}

export function StudiosSection({ data }: StudiosSectionProps) {
  const navigate = useNavigate();
  console.log("StudiosSection data:", data);
  const items: ImageGridItem[] = data.studios.map((studio) => ({
    id: studio.id,
    image: studio.image,
    title: studio.title,
    onClick: () => navigate(`/book-studio/${studio.id}`),
  }));

  return (
    <section id="studios-section" className="relative w-full bg-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        {/* <SectionHeader title={data.sectionTitle} className="mb-4 px-2 lg:px-6" /> */}
        <ImageGrid items={items} />
      </div>
    </section>
  );
}
