import { ImageGrid, type ImageGridItem } from "~/components/shared/ImageGrid";

interface BookData {
  items: ImageGridItem[];
}

interface BookSectionProps {
  title: string;
  description: string;
  data: BookData;
}

export function BookSection({ title, description, data }: BookSectionProps) {
  return (
    <section className="relative w-full bg-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-12 sm:py-16 lg:py-24">
        {/* Header */}
        <div className="text-center mb-12">
          <h2 className="text-3xl lg:text-5xl font-medium uppercase tracking-tight text-[#121212] font-clash-grotesk mb-4">
            {title}
          </h2>
          <p className="text-lg lg:text-xl text-[rgba(18,18,18,0.7)] max-w-2xl mx-auto mb-8">
            {description}
          </p>
        </div>

        {/* Studio Options Grid */}
        <ImageGrid items={data.items} />
      </div>
    </section>
  );
}
