interface PhotoData {
  title: string;
  description: string;
  image1: string;
  title1: string;
  subtitle1: string;
  image2: string;
  title2: string;
  subtitle2: string;
  image3: string;
  title3: string;
  image4: string;
  title4: string;
  image5: string;
  title5: string;
  image6: string;
  title6: string;
  subtitle6: string;
}

interface PhotoSectionProps {
  data: PhotoData;
}

export function PhotoSection({ data }: PhotoSectionProps) {
  return (
    <section className="w-full bg-gradient-to-b from-white to-[#F5F4F0]">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-12 lg:py-24">
        {/* Section Header */}
        <div className="text-center mb-12">
          <h2 className="text-3xl lg:text-5xl font-medium uppercase tracking-tight text-[#121212] font-clash-grotesk mb-4">
            {data.title}
          </h2>
          <p className="text-lg lg:text-xl text-[rgba(18,18,18,0.7)] max-w-3xl mx-auto">
            {data.description}
          </p>
        </div>

        {/* Gallery Grid */}
        <div className="grid gap-6">
          {/* Top row - 2 large images */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div className="group relative h-[300px] lg:h-[400px] overflow-hidden rounded-xl shadow-lg">
              <img
                src={data.image1}
                alt="Video production studio"
                className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 flex items-end p-6">
                <div>
                  <h3 className="text-white text-xl font-medium uppercase">
                    {data.title1}
                  </h3>
                  <p className="text-white/80 text-sm mt-1">{data.subtitle1}</p>
                </div>
              </div>
            </div>
            <div className="group relative h-[300px] lg:h-[400px] overflow-hidden rounded-xl shadow-lg">
              <img
                src={data.image2}
                alt="Music recording studio"
                className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 flex items-end p-6">
                <div>
                  <h3 className="text-white text-xl font-medium uppercase">
                    {data.title2}
                  </h3>
                  <p className="text-white/80 text-sm mt-1">{data.subtitle2}</p>
                </div>
              </div>
            </div>
          </div>

          {/* Middle row - 3 medium images */}
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div className="group relative h-[250px] overflow-hidden rounded-xl shadow-lg">
              <img
                src={data.image3}
                alt="Photography studio"
                className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 flex items-end p-4">
                <h3 className="text-white text-lg font-medium uppercase">
                  {data.title3}
                </h3>
              </div>
            </div>
            <div className="group relative h-[250px] overflow-hidden rounded-xl shadow-lg">
              <img
                src={data.image4}
                alt="Creative workspace"
                className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 flex items-end p-4">
                <h3 className="text-white text-lg font-medium uppercase">
                  {data.title4}
                </h3>
              </div>
            </div>
            <div className="group relative h-[250px] overflow-hidden rounded-xl shadow-lg">
              <img
                src={data.image5}
                alt="Production suite"
                className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 flex items-end p-4">
                <h3 className="text-white text-lg font-medium uppercase">
                  {data.title5}
                </h3>
              </div>
            </div>
          </div>

          {/* Bottom row - 1 wide image */}
          <div className="group relative h-[250px] lg:h-[350px] overflow-hidden rounded-xl shadow-lg">
            <img
              src={data.image6}
              alt="Multi-purpose studio space"
              className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-700"
            />
            <div className="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 flex items-end p-6">
              <div>
                <h3 className="text-white text-2xl font-medium uppercase">
                  {data.title6}
                </h3>
                <p className="text-white/80 text-base mt-2">{data.subtitle6}</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
