interface StudioItem {
  title: string;
  description: string;
  image: string;
  imagePosition: "left" | "right";
}

interface StudiosSectionProps {
  data: StudioItem[];
}

interface StudioRowProps {
  item: StudioItem;
}

function StudioRow({ item }: StudioRowProps) {
  return (
    <div className="flex flex-col lg:flex-row lg:justify-end lg:items-center w-full  border-t border-[rgba(18,18,18,0.2)]">
      {item.imagePosition === "right" ? (
        <>
          {/* Mobile: Image on top, Desktop: Text on left */}
          <div className="lg:hidden w-full p-4">
            <img
              src={item.image}
              alt={item.title}
              className="w-full h-full object-cover"
            />
          </div>

          {/* Text Content - Mobile: Below image, Desktop: Left Side */}
          <div className="flex flex-col items-start px-4 lg:px-14 py-8 lg:py-0 gap-4 lg:flex-1 lg:self-center">
            <h2 className="text-[24px] lg:text-[40px] leading-[32px] lg:leading-[48px] font-medium uppercase tracking-[-0.01em] text-[#121212] font-clash-grotesk">
              {item.title}
            </h2>
            <p className="text-[16px] lg:text-[24px] leading-[24px] lg:leading-[32px] font-normal text-[rgba(18,18,18,0.8)] font-clash-grotesk">
              {item.description}
            </p>
          </div>

          {/* Image - Desktop: Right Side */}
          <div className="hidden lg:flex flex-row items-center px-14 gap-2 w-[612px] h-[551px] border-l border-[rgba(18,18,18,0.2)]">
            <div className="flex flex-col items-start p-10 gap-2 w-[500px] h-[375px] flex-1">
              <img
                src={item.image}
                alt={item.title}
                className="w-full h-full object-cover"
              />
            </div>
          </div>
        </>
      ) : (
        <>
          {/* Mobile: Image on top, Desktop: Image on left */}
          <div className="lg:hidden w-full h-[300px] p-4">
            <img
              src={item.image}
              alt={item.title}
              className="w-full h-full object-cover"
            />
          </div>

          {/* Image - Desktop: Left Side */}
          <div className="hidden lg:flex flex-row items-center px-14 gap-2 w-[612px] h-[551px] border-r border-[rgba(18,18,18,0.2)]">
            <div className="flex flex-col items-start p-10 gap-2 w-[500px] h-[375px] flex-1">
              <img
                src={item.image}
                alt={item.title}
                className="w-full h-full object-cover"
              />
            </div>
          </div>

          {/* Text Content - Mobile: Below image, Desktop: Right Side */}
          <div className="flex flex-col items-start px-4 lg:px-14 py-8 lg:py-0 gap-4 lg:flex-1  lg:self-center">
            <h2 className="text-[24px] lg:text-[40px] leading-[32px] lg:leading-[48px] font-medium uppercase tracking-[-0.01em] text-[#121212] font-clash-grotesk">
              {item.title}
            </h2>
            <p className="text-[16px] lg:text-[24px] leading-[24px] lg:leading-[32px] font-normal text-[rgba(18,18,18,0.8)] font-clash-grotesk">
              {item.description}
            </p>
          </div>
        </>
      )}
    </div>
  );
}

export function StudiosSection({ data }: StudiosSectionProps) {
  return (
    <section id="studios" className="w-full bg-white">
      <div className="mx-auto w-full max-w-[1328px]">
        {data.map((item, index) => (
          <StudioRow key={index} item={item} />
        ))}
      </div>
    </section>
  );
}
