import { Link } from "@remix-run/react";
import { ArrowRight } from "lucide-react";
import { Button } from "~/components/ui/button";
import { cn } from "~/lib/utils";

interface MembershipSectionProps {
  theme?: "white" | "black";
}

export function MembershipSection({ theme = "white" }: MembershipSectionProps) {
  const isWhiteTheme = theme === "white";
  
  return (
    <section 
      className={cn(
        "relative w-full overflow-hidden",
        isWhiteTheme ? "bg-white" : "bg-black"
      )}
    >
      {/* Background decorative circles */}
      <div className="absolute inset-0">
        <div 
          className={cn(
            "absolute top-[-100px] right-[-100px] w-[400px] h-[400px] border rounded-full",
            isWhiteTheme ? "border-black/10" : "border-white/10"
          )} 
        />
        <div 
          className={cn(
            "absolute bottom-[-150px] left-[-150px] w-[500px] h-[500px] border rounded-full",
            isWhiteTheme ? "border-black/10" : "border-white/10"
          )} 
        />
        <div 
          className={cn(
            "absolute top-[200px] left-[50%] transform -translate-x-1/2 w-[300px] h-[300px] border rounded-full opacity-50",
            isWhiteTheme ? "border-black/10" : "border-white/10"
          )} 
        />
      </div>

      <div className="relative mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-[120px]">
        <div className="flex flex-col items-center text-center gap-6 lg:gap-10">
          <div className="max-w-[950px]">
            <h2 
              className={cn(
                "text-[32px] leading-[1.1] md:text-[56px] lg:text-heading-2-bold uppercase mb-6 font-bold tracking-[-0.02em]",
                isWhiteTheme ? "!text-black" : "!text-white"
              )}
            >
              CONNECT, COLLABORATE AND GROW
            </h2>
            <p 
              className={cn(
                "text-body-3 md:text-body-2 lg:text-body-1 max-w-[600px] mx-auto",
                isWhiteTheme ? "!text-black/80" : "!text-white/80"
              )}
            >
              Be part of something bigger. Nomadic Studios is more than just a
              place to work - it's a vibrant network of creatives who inspire
              and support each other.
            </p>
          </div>

          <div className="flex justify-center">
            <Button asChild variant={isWhiteTheme ? "fill-black" : "fill-white"} size="lg">
              <Link to="/membership/apply">
                APPLY FOR MEMBERSHIP
                <ArrowRight className="h-5 w-5" />
              </Link>
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
}
