import type { FilterOptions } from "../PeopleSection";

interface PeopleToolbarProps {
  filters: {
    location: string;
    role: string;
  };
  filterOptions: FilterOptions;
  onChange: (filters: { location: string; role: string }) => void;
}

export function PeopleToolbar({
  filters,
  filterOptions,
  onChange,
}: PeopleToolbarProps) {
  const handleLocationChange = (location: string) => {
    onChange({
      ...filters,
      location: filters.location === location ? "" : location,
    });
  };

  const handleRoleChange = (role: string) => {
    onChange({
      ...filters,
      role: filters.role === role ? "" : role,
    });
  };

  return (
    <div className="mb-8 lg:mb-12">
      {/* Profession Filter */}
      <div className="mb-6">
        <label className="block text-body-3 mb-4 uppercase font-normal" style={{ color: '#000000' }}>
          PROFESSION
        </label>
        <div className="flex flex-wrap gap-3">
          <button
            className={`px-6 py-2.5 rounded-full font-normal text-body-3 transition-all ${
              !filters.role
                ? "bg-black border-2 border-black"
                : "bg-white border-2 border-black hover:bg-gray-100"
            }`}
            style={{ color: !filters.role ? '#FFFFFF' : '#000000' }}
            onClick={() => handleRoleChange("")}
          >
            ALL CREW
          </button>
          {filterOptions.roles.map((role) => (
            <button
              key={role}
              className={`px-6 py-2.5 rounded-full font-normal text-body-3 transition-all ${
                filters.role === role
                  ? "bg-black border-2 border-black"
                  : "bg-white border-2 border-black hover:bg-gray-100"
              }`}
              style={{ color: filters.role === role ? '#FFFFFF' : '#000000' }}
              onClick={() => handleRoleChange(role)}
            >
              {role.toUpperCase()}
            </button>
          ))}
        </div>
      </div>

      {/* Location Filter */}
      <div>
        <label className="block text-body-3 mb-4 uppercase font-normal" style={{ color: '#000000' }}>
          LOCATION
        </label>
        <div className="flex flex-wrap gap-3">
          <button
            className={`px-6 py-2.5 rounded-full font-normal text-body-3 transition-all ${
              !filters.location
                ? "bg-black border-2 border-black"
                : "bg-white border-2 border-black hover:bg-gray-100"
            }`}
            style={{ color: !filters.location ? '#FFFFFF' : '#000000' }}
            onClick={() => handleLocationChange("")}
          >
            ALL LOCATIONS
          </button>
          {filterOptions.locations.map((location) => (
            <button
              key={location}
              className={`px-6 py-2.5 rounded-full font-normal text-body-3 transition-all ${
                filters.location === location
                  ? "bg-black border-2 border-black"
                  : "bg-white border-2 border-black hover:bg-gray-100"
              }`}
              style={{ color: filters.location === location ? '#FFFFFF' : '#000000' }}
              onClick={() => handleLocationChange(location)}
            >
              {location.toUpperCase()}
            </button>
          ))}
        </div>
      </div>
    </div>
  );
}