export type StudioType = "video" | "music" | "photo";

export interface StudioItem {
  title: string;
  description: string;
  image: string;
  imagePosition: "left" | "right";
}

export interface BookingItem {
  id: string;
  image: string;
  title: string;
}

export interface StudioConfig {
  meta: {
    title: string;
    description: string;
  };
  welcome: {
    title: string;
    subtitle: string;
    backgroundImage: string;
    ctaLabel: string;
    ctaHref: string;
  };
  studios: StudioItem[];
  book: {
    title: string;
    description: string;
    items: BookingItem[];
  };
}

export const studiosConfig: Record<StudioType, StudioConfig> = {
  video: {
    meta: {
      title: "Video Studios | Nomadics",
      description: "Professional video studios for filming, livestreaming, and editing"
    },
    welcome: {
      title: "STUDIOS TO CREATE STORIES",
      subtitle: "Professional video studios for filming, livestreaming, and editing",
      backgroundImage: "/images/studios/welcome.png",
      ctaLabel: "Book a video studio",
      ctaHref: "/studios/video/book",
    },
    studios: [
      {
        title: "A Space Designed for Video Creators",
        description: "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality.",
        image: "/images/studios/studio-1.png",
        imagePosition: "right",
      },
      {
        title: "Professional Lighting & Backdrops",
        description: "Our video studios feature comprehensive lighting grids, green screens, and customizable backdrops. From key lights to fill lights, diffusers to reflectors, create the perfect lighting setup for any production style or mood.",
        image: "/images/studios/studio-2.png",
        imagePosition: "left",
      },
      {
        title: "Live Streaming & Post-Production",
        description: "Equipped with high-speed internet, streaming encoders, and powerful editing workstations. Whether you're broadcasting live or perfecting your final cut, our studios provide the technical infrastructure for seamless production workflows.",
        image: "/images/studios/studio-3.png",
        imagePosition: "right",
      },
    ],
    book: {
      title: "Book a Video Studio",
      description: "Choose the perfect space for your video production needs",
      items: [
        {
          id: "studio-a",
          image: "/images/studios/studio-1.png",
          title: "STUDIO A",
        },
        {
          id: "studio-b",
          image: "/images/studios/studio-2.png",
          title: "STUDIO B",
        },
        {
          id: "studio-c",
          image: "/images/studios/studio-3.png",
          title: "STUDIO C",
        },
      ],
    }
  },
  music: {
    meta: {
      title: "Music Studios | Nomadics", 
      description: "Professional music studios with treated rooms, pro interfaces, and backline on request"
    },
    welcome: {
      title: "SPACES TO MAKE YOUR MUSIC HEARD",
      subtitle: "Acoustically treated rooms with pro interfaces and backline on request",
      backgroundImage: "/images/studios/music-1.png",
      ctaLabel: "Book a music studio",
      ctaHref: "/studios/music/book",
    },
    studios: [
      {
        title: "Professional Recording Environment",
        description: "Our music studios feature acoustically treated rooms designed for optimal sound quality. From vocal booths to live rooms, every space is engineered to capture the perfect take. Professional-grade soundproofing ensures your sessions remain private and distraction-free.",
        image: "/images/studios/music-1.png",
        imagePosition: "right",
      },
      {
        title: "Industry-Standard Equipment",
        description: "Record with confidence using our curated selection of industry-standard interfaces, microphones, and monitoring systems. From vintage analog gear to cutting-edge digital processors, we provide the tools that professional producers and engineers trust.",
        image: "/images/studios/music-2.png",
        imagePosition: "left",
      },
      {
        title: "Backline and Instruments Available",
        description: "Need instruments? We've got you covered. Our studios offer a selection of quality instruments and backline equipment available on request. From drum kits to keyboards, guitars to synthesizers, expand your sonic palette without the hassle of transport.",
        image: "/images/studios/music-3.png",
        imagePosition: "right",
      },
    ],
    book: {
      title: "Book a Music Studio",
      description: "Find the ideal acoustic environment for your recording session",
      items: [
        {
          id: "recording-room",
          image: "/images/studios/music-1.png",
          title: "RECORDING ROOM",
        },
        {
          id: "mixing-suite",
          image: "/images/studios/music-2.png",
          title: "MIXING SUITE",
        },
        {
          id: "live-room",
          image: "/images/studios/music-3.png",
          title: "LIVE ROOM",
        },
      ],
    }
  },
  photo: {
    meta: {
      title: "Photo Studios | Nomadics",
      description: "Photography studios equipped for everything from product shoots to portrait sessions"
    },
    welcome: {
      title: "CAPTURE YOUR VISION",
      subtitle: "Photography studios equipped for everything from product shoots to portraits",
      backgroundImage: "/images/studios/photo-1.png",
      ctaLabel: "Book a photo studio", 
      ctaHref: "/studios/photo/book",
    },
    studios: [
      {
        title: "Versatile Shooting Spaces",
        description: "Our photography studios adapt to your creative vision. From intimate portrait sessions to large-scale product shoots, each space offers the flexibility you need. Customizable backdrops, moveable walls, and modular sets let you create the perfect environment for any project.",
        image: "/images/studios/photo-1.png",
        imagePosition: "right",
      },
      {
        title: "Professional Lighting Systems",
        description: "Light your subjects perfectly with our comprehensive lighting setups. Each studio includes professional strobe systems, continuous LED panels, and a full range of modifiers. From softboxes to beauty dishes, create any mood or style with our extensive lighting equipment.",
        image: "/images/studios/photo-2.png",
        imagePosition: "left",
      },
      {
        title: "Props and Backgrounds",
        description: "Access our curated collection of backgrounds and props to enhance your shoots. Choose from seamless paper rolls in various colors, textured backdrops, and themed props. Whether you're shooting fashion, products, or portraits, we have the elements to complete your vision.",
        image: "/images/studios/photo-1.png",
        imagePosition: "right",
      },
    ],
    book: {
      title: "Book a Photo Studio",
      description: "Select the perfect backdrop for your photography project",
      items: [
        {
          id: "daylight-studio",
          image: "/images/studios/photo-1.png",
          title: "DAYLIGHT STUDIO",
        },
        {
          id: "blackout-studio",
          image: "/images/studios/photo-2.png",
          title: "BLACKOUT STUDIO",
        },
        {
          id: "infinity-cove",
          image: "/images/studios/photo-1.png",
          title: "INFINITY COVE",
        },
      ],
    }
  }
};