import { ProtectedRoute } from "~/components/RouteProtection";
import type { MetaFunction } from "@remix-run/node";
import { useSearchParams, Link } from "@remix-run/react";
import { AppHeader } from "~/components/AppHeader";
import { AppFooter } from "~/components/AppFooter";
import { Button } from "~/components/ui/button";

export const meta: MetaFunction = () => {
  return [
    { title: "Booking Confirmation - Nomadics Studios" },
    {
      name: "description",
      content: "Your booking has been confirmed successfully.",
    },
  ];
};

export default function BookConfirmation() {
  const [searchParams] = useSearchParams();
  const studio = searchParams.get("studio");
  const equipment = searchParams.get("equipment");
  const support = searchParams.get("support");

  return (
    <ProtectedRoute>
      <div className="min-h-screen bg-white text-black">
        <AppHeader theme="dark" />
      
      {/* Hero Section */}
      <section className="relative bg-black text-white py-16">
        <div className="absolute inset-0 bg-black/20" />
        <div className="relative z-10 max-w-7xl mx-auto px-4">
          <h1 className="text-4xl md:text-5xl font-light mb-4">
            Create something with us!
          </h1>
        </div>
      </section>

      {/* Success Image */}
      <section className="py-12">
        <div className="max-w-4xl mx-auto px-4">
          <img
            src="/images/booking-success.jpg"
            alt="Booking Success"
            className="w-full h-64 object-cover rounded-lg"
            onError={(e) => {
              e.currentTarget.src = "https://via.placeholder.com/800x256/22c55e/ffffff?text=Booking+Success";
            }}
          />
        </div>
      </section>

      <main className="max-w-4xl mx-auto px-4 pb-16">
        {/* Congratulations Section */}
        <div className="text-center mb-12">
          <h2 className="text-4xl font-light text-black mb-4">
            Congratulations!
          </h2>
          <p className="text-xl text-gray-600">
            Your booking is confirmed.
          </p>
        </div>

        {/* Booking Details */}
        <div className="bg-white border border-gray-200 rounded-lg p-8 mb-8">
          <h3 className="text-2xl font-light text-black mb-8">Details</h3>

          <div className="space-y-8">
            {/* Location */}
            <div className="flex items-start gap-6">
              <div className="w-24 font-medium text-gray-700">Location</div>
              <div className="flex items-center gap-4">
                <img
                  src="/images/locations/bali.jpg"
                  alt="Bali"
                  className="w-16 h-16 object-cover rounded"
                  onError={(e) => {
                    e.currentTarget.src = "https://via.placeholder.com/64x64/f3f4f6/9ca3af?text=Bali";
                  }}
                />
                <span className="text-lg text-black">Bali</span>
              </div>
            </div>

            {/* Date */}
            <div className="flex items-start gap-6">
              <div className="w-24 font-medium text-gray-700">Date</div>
              <div className="text-lg text-black">
                17 May 2023 - 23 May 2023 (7 days)
              </div>
            </div>

            {/* Room Type */}
            <div className="flex items-start gap-6">
              <div className="w-24 font-medium text-gray-700">Room type</div>
              <div className="flex items-start gap-4">
                <img
                  src="/images/rooms/medium-room.jpg"
                  alt="Medium Room"
                  className="w-16 h-16 object-cover rounded"
                  onError={(e) => {
                    e.currentTarget.src = "https://via.placeholder.com/64x64/f3f4f6/9ca3af?text=Room";
                  }}
                />
                <div>
                  <div className="text-lg text-black mb-2">Medium</div>
                  <div className="text-right text-lg font-medium">100 pts</div>
                  
                  <div className="text-sm text-gray-600 mt-2">
                    <h4 className="font-medium text-black mb-1">DETAILS</h4>
                    <ul className="space-y-1">
                      <li>✓ Room 30m2</li>
                      <li>✓ Balcony</li>
                      <li>✓ Ensuite bathroom</li>
                      <li>✓ Full bed</li>
                      <li>✓ Air conditioning</li>
                      <li>✓ Flat screen</li>
                      <li>✓ Free WiFi</li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>

            {/* Type of Studio */}
            <div className="flex items-start gap-6">
              <div className="w-24 font-medium text-gray-700">Type of studio</div>
              <div className="flex items-start gap-4">
                <img
                  src="/images/studios/music-studio-large.jpg"
                  alt="Music Studio"
                  className="w-16 h-16 object-cover rounded"
                  onError={(e) => {
                    e.currentTarget.src = "https://via.placeholder.com/64x64/f3f4f6/9ca3af?text=Studio";
                  }}
                />
                <div>
                  <div className="text-lg text-black mb-2">Music</div>
                  <div className="text-right text-lg font-medium">150 pts</div>
                  
                  <div className="text-sm text-gray-600 mt-2">
                    <h4 className="font-medium text-black mb-1">HARDWARE</h4>
                    <ul className="space-y-1">
                      <li>✓ Pro Computer & Monitor</li>
                    </ul>
                    
                    <h4 className="font-medium text-black mb-1 mt-2">SOFTWARE</h4>
                    <ul className="space-y-1">
                      <li>✓ Ableton Live</li>
                      <li>✓ Logic Pro</li>
                      <li>✓ 16 TB Sample library</li>
                    </ul>
                    
                    <h4 className="font-medium text-black mb-1 mt-2">INSTRUMENTS</h4>
                    <ul className="space-y-1">
                      <li>✓ Pioneer CDJ3000</li>
                      <li>✓ Pioneer DJM V10</li>
                      <li>✓ Solid State Logic AWS 924</li>
                    </ul>
                    
                    <h4 className="font-medium text-black mb-1 mt-2">SERVICES</h4>
                    <ul className="space-y-1">
                      <li>✓ Graphic Design</li>
                      <li>✓ Music Label Services</li>
                      <li>✓ Music Publishing</li>
                      <li>✓ Social Media Management</li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>

            {/* Equipment */}
            <div className="flex items-start gap-6">
              <div className="w-24 font-medium text-gray-700">Equipment</div>
              <div className="flex items-start gap-4">
                <img
                  src="/images/equipment/pioneer-cdj3000-large.jpg"
                  alt="Pioneer CDJ3000"
                  className="w-16 h-16 object-cover rounded"
                  onError={(e) => {
                    e.currentTarget.src = "https://via.placeholder.com/64x64/f3f4f6/9ca3af?text=Equip";
                  }}
                />
                <div>
                  <div className="text-lg text-black">Pioneer CDJ3000</div>
                  <div className="text-right text-lg font-medium">95 pts</div>
                </div>
              </div>
            </div>
          </div>

          {/* Pricing Summary */}
          <div className="border-t border-gray-200 mt-8 pt-6">
            <div className="flex justify-between items-center mb-4">
              <span className="text-lg font-medium text-black">Booking cost</span>
              <span className="text-lg font-medium text-black">345 pts</span>
            </div>
            <div className="flex justify-between items-center">
              <span className="text-lg font-medium text-black">Points left</span>
              <span className="text-lg font-medium text-black">1125 pts</span>
            </div>
          </div>
        </div>

        {/* Action Buttons */}
        <div className="flex flex-col sm:flex-row gap-4 justify-center">
          <Button
            variant="fill-black"
            size="md"
            className="px-8 uppercase tracking-wider font-medium transition-all duration-200 hover:shadow-lg"
          >
            Print receipt
          </Button>
          
          <Button
            variant="outline-black"
            size="md"
            className="px-8 uppercase tracking-wider font-medium transition-all duration-200 hover:shadow-md"
          >
            Modify your booking
          </Button>
          
          <Link to="/home">
            <Button
              variant="fill-black"
              size="md"
              className="w-full px-8 uppercase tracking-wider font-medium transition-all duration-200 hover:shadow-lg bg-orange-500 hover:bg-orange-600 border-orange-500"
            >
              Return home
            </Button>
          </Link>
        </div>
      </main>

      {/* <AppFooter /> */}
      </div>
    </ProtectedRoute>
  );
}