import type { MetaFunction } from "@remix-run/node";
import { AppHeader } from "~/components/AppHeader";
import { AppFooter } from "~/components/AppFooter";

export const meta: MetaFunction = () => {
  return [
    { title: "Partners - Nomadic Studios" },
    {
      name: "description",
      content: "Discover partnership opportunities and learn how to collaborate with Nomadic Studios.",
    },
  ];
};

export default function Partners() {
  return (
    <div className="min-h-screen bg-black">
      <AppHeader theme="dark" />
      
      <main className="pt-20">
        <section className="relative w-full bg-black">
          <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-[120px]">
            <div className="text-center">
              <h1 className="text-4xl md:text-6xl font-light tracking-wider text-white mb-8">
                Partners
              </h1>
              <p className="text-lg text-white/70 max-w-2xl mx-auto">
                This page is currently under construction. Please check back soon for partnership opportunities.
              </p>
            </div>
          </div>
        </section>
      </main>
    </div>
  );
}