import type { MetaFunction } from "@remix-run/node";
import { AppHeader } from "~/components/AppHeader";
import { AppFooter } from "~/components/AppFooter";

export const meta: MetaFunction = () => {
  return [
    { title: "Privacy Policy - Nomadic Studios" },
    {
      name: "description",
      content: "Learn about how we collect, use, and protect your personal information at Nomadic Studios.",
    },
  ];
};

export default function Privacy() {
  return (
    <div className="min-h-screen bg-black">
      <AppHeader theme="dark" />
      
      <main className="pt-20">
        <section className="relative w-full bg-black">
          <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-[120px]">
            <div className="text-center">
              <h1 className="text-4xl md:text-6xl font-light tracking-wider text-white mb-8">
                Privacy Policy
              </h1>
              <p className="text-lg text-white/70 max-w-2xl mx-auto">
                This page is currently under construction. Please check back soon for our complete privacy policy.
              </p>
            </div>
          </div>
        </section>
      </main>
    </div>
  );
}