import React from "react";
import { API_BASE_URL, IMAGE_BASE_URL } from "~/lib/api";
import { useLanguage } from "~/hooks/useLanguage";

export default function services() {
  const { t } = useLanguage();

  const servicesData = [
    {
      title: t("services.items.socialMedia.title", "SOCIAL MEDIA STRATEGY"),
      description: t(
        "services.items.socialMedia.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-two.png`,
      reverse: false,
    },
    {
      title: t(
        "services.items.contentCreation.title",
        "CONTENT CREATION (IMAGES, VIDEOS, COPY)"
      ),
      description: t(
        "services.items.contentCreation.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-three.png`,
      reverse: true,
    },
    {
      title: t("services.items.paidAds.title", "PAID AD CAMPAIGNS"),
      description: t(
        "services.items.paidAds.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-four.png`,
      reverse: false,
    },
    {
      title: t("services.items.analytics.title", "ANALYTICS AND INSIGHTS"),
      description: t(
        "services.items.analytics.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-five.png`,
      reverse: true,
    },
  ];

  return (
    <div className="bg-black text-white min-h-screen font-sans">
      {/* Hero Section */}
      <section className="relative min-h-screen">
        {/* Background Image */}
        <div className="absolute inset-0 bg-[#030303]" />
        <img
          src="https://nomadicstudios.net:444/images/fe/services-sec-one.png"
          alt=""
          className="absolute inset-0 h-full w-full object-cover"
        />
        <div className="absolute inset-0 bg-black/50" />

        <div className="relative z-10 max-w-7xl mx-auto px-6 py-20 min-h-screen flex flex-col justify-center">
          <h1 className="text-6xl md:text-7xl font-black mb-8 leading-tight">
            {t("services.hero.title", "GROW YOUR AUDIENCE, BUILD YOUR BRAND.")}
          </h1>
          <div className="flex flex-col md:flex-row md:items-center gap-8 mb-16">
            <div className="md:w-1/2"></div>
            <div className="md:w-1/2 text-lg text-gray-200">
              {t(
                "services.hero.description",
                "Our team offers a complete suite of social media and marketing services, including content creation, post-scheduling, analytics, and campaign management. Whether you're an emerging artist or a seasoned professional, we help you stand out in a crowded digital landscape."
              )}
            </div>
          </div>
          <div className="flex flex-col md:flex-row gap-6 justify-center mb-16">
            <button className="border border-white rounded-full px-10 py-6 text-lg font-medium text-white hover:bg-white hover:text-black transition w-full md:w-auto">
              {t("services.hero.expandReach", "EXPAND YOUR REACH")}
            </button>
            <button className="border border-white rounded-full px-10 py-6 text-lg font-medium text-white hover:bg-white hover:text-black transition w-full md:w-auto">
              {t("services.hero.generateIncome", "GENERATE PASSIVE INCOME")}
            </button>
            <button className="border border-white rounded-full px-10 py-6 text-lg font-medium text-white hover:bg-white hover:text-black transition w-full md:w-auto">
              {t("services.hero.simplifyMonetization", "SIMPLIFY MONETIZATION")}
            </button>
          </div>
        </div>
      </section>

      {/* Service Sections */}
      <div className="bg-white text-black py-20">
        <div className="max-w-7xl mx-auto px-6 grid gap-20">
          {servicesData.map((service, idx) => (
            <div
              key={service.title}
              className={`grid md:grid-cols-2 gap-0 items-stretch`}
            >
              {/* Alternate image/text position for each row */}
              {idx % 2 === 0 ? (
                <>
                  <div className="flex items-center justify-center p-8">
                    <img
                      src={service.image}
                      alt={service.title}
                      className="rounded-xl w-full h-64 object-cover shadow-lg"
                    />
                  </div>
                  <div className="flex flex-col justify-center p-8">
                    <h2 className="text-3xl font-bold mb-4">{service.title}</h2>
                    <p className="text-lg text-gray-700 leading-relaxed">
                      {service.description}
                    </p>
                  </div>
                </>
              ) : (
                <>
                  <div className="flex flex-col justify-center p-8">
                    <h2 className="text-3xl font-bold mb-4">{service.title}</h2>
                    <p className="text-lg text-gray-700 leading-relaxed">
                      {service.description}
                    </p>
                  </div>
                  <div className="flex items-center justify-center p-8">
                    <img
                      src={service.image}
                      alt={service.title}
                      className="rounded-xl w-full h-64 object-cover shadow-lg"
                    />
                  </div>
                </>
              )}
            </div>
          ))}
        </div>
      </div>

      {/* CTA Section */}
      <section className="bg-black text-white py-24 text-center">
        <h2 className="text-5xl md:text-6xl font-black mb-8">
          {t(
            "services.cta.title",
            "JOIN US TO LEARN HOW TO GET STARTED WITH ONLINE SERVICES."
          )}
        </h2>
        <p className="text-lg text-gray-200 mb-8 max-w-2xl mx-auto">
          {t(
            "services.cta.description",
            "Be part of something bigger. Nomadic Studios is more than just a place to work – it's a vibrant network of creatives who inspire and support each other."
          )}
        </p>
        <button className="bg-white text-black font-semibold px-10 py-5 rounded shadow hover:bg-gray-200 transition text-lg">
          {t("services.cta.button", "APPLY FOR MEMBERSHIP")} &rarr;
        </button>
      </section>
    </div>
  );
}
