import {
  authAPI
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  useLocation,
  useNavigate
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/auth/ResetPasswordOtp.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\ResetPasswordOtp.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\ResetPasswordOtp.tsx"
  );
  import.meta.hot.lastModified = "1760464886203.3677";
}
var ResetPasswordOtp = () => {
  _s();
  const navigate = useNavigate();
  const location = useLocation();
  const [isVisible, setIsVisible] = (0, import_react.useState)(false);
  const [otp, setOtp] = (0, import_react.useState)(["", "", "", "", "", ""]);
  const [passwords, setPasswords] = (0, import_react.useState)({
    password: "",
    confirmPassword: ""
  });
  const [isLoading, setIsLoading] = (0, import_react.useState)(false);
  const [error, setError] = (0, import_react.useState)(null);
  const [resendTimer, setResendTimer] = (0, import_react.useState)(30);
  const [canResend, setCanResend] = (0, import_react.useState)(false);
  const [showPassword, setShowPassword] = (0, import_react.useState)(false);
  const [showConfirmPassword, setShowConfirmPassword] = (0, import_react.useState)(false);
  const email = location.state?.email || "";
  const mobile_number = location.state?.mobile_number || "";
  const requestType = location.state?.requestType || "reset-password";
  (0, import_react.useEffect)(() => {
    if (!email || !mobile_number) {
      navigate("/reset-password");
      return;
    }
    setIsVisible(true);
    const timer = setInterval(() => {
      setResendTimer((prev) => {
        if (prev <= 1) {
          setCanResend(true);
          clearInterval(timer);
          return 0;
        }
        return prev - 1;
      });
    }, 1e3);
    return () => clearInterval(timer);
  }, [email, mobile_number, navigate]);
  const handleOtpChange = (index, value) => {
    if (value.length > 1)
      return;
    const newOtp = [...otp];
    newOtp[index] = value;
    setOtp(newOtp);
    if (value && index < 5) {
      const nextInput = document.getElementById(`otp-${index + 1}`);
      nextInput?.focus();
    }
    if (error)
      setError(null);
  };
  const handleOtpKeyDown = (index, e) => {
    if (e.key === "Backspace" && !otp[index] && index > 0) {
      const prevInput = document.getElementById(`otp-${index - 1}`);
      prevInput?.focus();
    }
  };
  const handlePasswordChange = (e) => {
    const {
      name,
      value
    } = e.target;
    setPasswords((prev) => ({
      ...prev,
      [name]: value
    }));
    if (error)
      setError(null);
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    setError(null);
    const otpString = otp.join("");
    if (otpString.length !== 6) {
      setError("Please enter the complete 6-digit OTP");
      setIsLoading(false);
      return;
    }
    if (passwords.password !== passwords.confirmPassword) {
      setError("Passwords do not match");
      setIsLoading(false);
      return;
    }
    if (passwords.password.length < 8) {
      setError("Password must be at least 8 characters long");
      setIsLoading(false);
      return;
    }
    try {
      const response = await authAPI.verifyOTP(mobile_number, otpString, requestType, {
        password: passwords.password,
        confirm_password: passwords.confirmPassword
      });
      if (response.status) {
        navigate("/login", {
          state: {
            message: "Password reset successfully! Please login with your new password.",
            type: "success"
          }
        });
      } else {
        setError(response.error || "Failed to reset password. Please try again.");
      }
    } catch (err) {
      console.error("Reset password OTP verification error:", err);
      setError(err instanceof Error ? err.message : "An unexpected error occurred. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  const handleResendOTP = async () => {
    if (!canResend)
      return;
    try {
      setIsLoading(true);
      const response = await authAPI.forgotPassword(email);
      if (response.status) {
        setCanResend(false);
        setResendTimer(30);
        setError(null);
        const timer = setInterval(() => {
          setResendTimer((prev) => {
            if (prev <= 1) {
              setCanResend(true);
              clearInterval(timer);
              return 0;
            }
            return prev - 1;
          });
        }, 1e3);
        setError(null);
      } else {
        setError(response.error || "Failed to resend OTP");
      }
    } catch (err) {
      setError("Failed to resend OTP");
    } finally {
      setIsLoading(false);
    }
  };
  const formatTime = (seconds) => {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${mins}:${secs.toString().padStart(2, "0")}`;
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 190,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 191,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/ResetPasswordOtp.tsx",
      lineNumber: 189,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 196,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 200,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 203,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 206,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/ResetPasswordOtp.tsx",
      lineNumber: 195,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "RESET PASSWORD" }, void 0, false, {
          fileName: "app/components/auth/ResetPasswordOtp.tsx",
          lineNumber: 216,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: "Enter the OTP sent to your mobile and set new password" }, void 0, false, {
          fileName: "app/components/auth/ResetPasswordOtp.tsx",
          lineNumber: 219,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 215,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-full max-w-md transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h2", { className: "text-2xl font-semibold mb-8 text-white text-center uppercase tracking-wider", children: "Verify & Reset" }, void 0, false, {
          fileName: "app/components/auth/ResetPasswordOtp.tsx",
          lineNumber: 227,
          columnNumber: 13
        }, this),
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/ResetPasswordOtp.tsx",
          lineNumber: 232,
          columnNumber: 23
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("form", { onSubmit: handleSubmit, className: "space-y-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-4", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-white/80 text-sm mb-2", children: "Enter 6-digit OTP" }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 240,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-white/60 text-xs", children: [
                "Sent to ",
                mobile_number ? mobile_number.replace(/(\d{2})(\d{4})(\d{4})/, "$1****$3") : "your registered mobile number"
              ] }, void 0, true, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 241,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 239,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex justify-center space-x-3", children: otp.map((digit, index) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { id: `otp-${index}`, type: "text", inputMode: "numeric", pattern: "[0-9]*", maxLength: 1, value: digit, onChange: (e) => handleOtpChange(index, e.target.value), onKeyDown: (e) => handleOtpKeyDown(index, e), className: "w-12 h-12 text-center text-xl font-bold bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 text-white backdrop-blur-sm transition-all", disabled: isLoading }, index, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 247,
              columnNumber: 46
            }, this)) }, void 0, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 246,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center", children: canResend ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", onClick: handleResendOTP, disabled: isLoading, children: "Resend OTP" }, void 0, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 252,
              columnNumber: 32
            }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-white/60 text-sm", children: [
              "Resend OTP in ",
              formatTime(resendTimer)
            ] }, void 0, true, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 254,
              columnNumber: 33
            }, this) }, void 0, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 251,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 238,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "New Password" }, void 0, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 262,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: showPassword ? "text" : "password", name: "password", placeholder: "Enter new password", value: passwords.password, onChange: handlePasswordChange, className: "w-full px-4 py-4 pr-12 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading, minLength: 8 }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 264,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { type: "button", onClick: () => setShowPassword(!showPassword), className: "absolute right-3 top-1/2 transform -translate-y-1/2 text-white/60 hover:text-white/80 transition-colors", children: showPassword ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-5 h-5", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 267,
                columnNumber: 25
              }, this) }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 266,
                columnNumber: 37
              }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-5 h-5", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z" }, void 0, false, {
                  fileName: "app/components/auth/ResetPasswordOtp.tsx",
                  lineNumber: 269,
                  columnNumber: 25
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" }, void 0, false, {
                  fileName: "app/components/auth/ResetPasswordOtp.tsx",
                  lineNumber: 270,
                  columnNumber: 25
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 268,
                columnNumber: 32
              }, this) }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 265,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 263,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 261,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Confirm New Password" }, void 0, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 278,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: showConfirmPassword ? "text" : "password", name: "confirmPassword", placeholder: "Confirm new password", value: passwords.confirmPassword, onChange: handlePasswordChange, className: "w-full px-4 py-4 pr-12 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading, minLength: 8 }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 280,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { type: "button", onClick: () => setShowConfirmPassword(!showConfirmPassword), className: "absolute right-3 top-1/2 transform -translate-y-1/2 text-white/60 hover:text-white/80 transition-colors", children: showConfirmPassword ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-5 h-5", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 283,
                columnNumber: 25
              }, this) }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 282,
                columnNumber: 44
              }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-5 h-5", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z" }, void 0, false, {
                  fileName: "app/components/auth/ResetPasswordOtp.tsx",
                  lineNumber: 285,
                  columnNumber: 25
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" }, void 0, false, {
                  fileName: "app/components/auth/ResetPasswordOtp.tsx",
                  lineNumber: 286,
                  columnNumber: 25
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 284,
                columnNumber: 32
              }, this) }, void 0, false, {
                fileName: "app/components/auth/ResetPasswordOtp.tsx",
                lineNumber: 281,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 279,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 277,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
              fileName: "app/components/auth/ResetPasswordOtp.tsx",
              lineNumber: 295,
              columnNumber: 21
            }, this),
            "Resetting Password..."
          ] }, void 0, true, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 294,
            columnNumber: 30
          }, this) : "Reset Password" }, void 0, false, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 293,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center pt-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", onClick: () => navigate("/reset-password"), children: "Back to Reset Password" }, void 0, false, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 302,
            columnNumber: 17
          }, this) }, void 0, false, {
            fileName: "app/components/auth/ResetPasswordOtp.tsx",
            lineNumber: 301,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/ResetPasswordOtp.tsx",
          lineNumber: 236,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 226,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/ResetPasswordOtp.tsx",
        lineNumber: 225,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/ResetPasswordOtp.tsx",
      lineNumber: 213,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/ResetPasswordOtp.tsx",
    lineNumber: 187,
    columnNumber: 10
  }, this);
};
_s(ResetPasswordOtp, "0ghpdrDvgPnKUO81se4+d4u3/go=", false, function() {
  return [useNavigate, useLocation];
});
_c = ResetPasswordOtp;
var ResetPasswordOtp_default = ResetPasswordOtp;
var _c;
$RefreshReg$(_c, "ResetPasswordOtp");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

export {
  ResetPasswordOtp_default
};
//# sourceMappingURL=build/_shared/chunk-CPVE4DTD.js.map
