import {
  PublicRoute
} from "./build/_shared/chunk-MYKE2GOT.js";
import "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import "./build/_shared/chunk-Y3M5FCCQ.js";
import {
  Link,
  useParams
} from "./build/_shared/chunk-5EQN7Y3V.js";
import "./build/_shared/chunk-2Y2CKKWM.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import "./build/_shared/chunk-ZFLKADV3.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/routes/news.$slug.tsx
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\routes\\\\news.$slug.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\routes\\news.$slug.tsx"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}
var styles = `
  .line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
  }
  .line-clamp-3 {
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
  }
`;
var meta = ({
  params
}) => {
  return [{
    title: `${params.slug?.replace(/-/g, " ")} - Nomadics Studios`
  }, {
    name: "description",
    content: "Read the latest news and insights from the creative community at Nomadics Studios."
  }];
};
var newsArticles = [{
  id: 1,
  title: "Travel as a failure",
  category: "Travel",
  author: {
    name: "Akanksha Bhartaure",
    avatar: "/placeholder-avatar.jpg",
    bio: "Travel Writer & Creative Director"
  },
  publishedAt: "5 min ago",
  readTime: "5 min read",
  image: "/bw (1).png",
  slug: "travel-as-a-failure",
  excerpt: "A story about a trip to Barcelona and the lessons learned from unexpected challenges along the way.",
  content: `
      <h2>A story about travel</h2>
      
      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent tristique leo vitae purus lacinia, ut euismod nulla viverra. Duis rutrum fringilla vestibulum. Quisque gravida, tortor eget accumsan aliquet.</p>
      
      <h3>A story about a trip to Barcelona 2</h3>
      
      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent tristique leo vitae purus lacinia, ut euismod nulla viverra. Duis rutrum fringilla vestibulum. Quisque gravida, tortor eget accumsan aliquet.</p>
      
      <p>Travel opens our minds to new possibilities and perspectives that we might never encounter in our daily routines. When we step outside our comfort zones and immerse ourselves in different cultures, we gain invaluable insights that can transform our creative work.</p>
      
      <p>Sometimes, the most valuable lessons come from the moments when things don't go according to plan. Failed connections, missed opportunities, and unexpected detours often become the foundation for our most compelling stories and creative breakthroughs.</p>
    `,
  tags: ["Travel", "Lessons", "Barcelona", "Growth"]
}, {
  id: 2,
  title: "Travel as a fresh perspective",
  category: "Travel",
  author: {
    name: "Super Admin",
    avatar: "/placeholder-avatar.jpg",
    bio: "Creative Director at Nomadics Studios"
  },
  publishedAt: "2 hours ago",
  readTime: "4 min read",
  image: "/image.png",
  slug: "travel-as-a-fresh-perspective",
  excerpt: "A story about travel and how it opens our minds to new creative possibilities and fresh perspectives.",
  content: `
      <h2>A story about travel</h2>
      
      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent tristique leo vitae purus lacinia, ut euismod nulla viverra. Duis rutrum fringilla vestibulum. Quisque gravida, tortor eget accumsan aliquet.</p>
      
      <h3>The Creative Impact of Travel</h3>
      
      <p>For creators, travel is more than just a break from routine\u2014it's a source of inspiration that can revolutionize their approach to their craft. Whether you're a filmmaker seeking new locations, a photographer hunting for unique lighting, or a musician searching for fresh sounds, travel provides the raw material for creative breakthroughs.</p>
      
      <p>At Nomadics Studios, we've seen firsthand how our community members return from their travels with renewed energy and innovative ideas. The stories they share, the techniques they've learned, and the perspectives they've gained all contribute to the rich tapestry of our creative community.</p>
    `,
  tags: ["Travel", "Creativity", "Inspiration", "Community"]
}];
function findArticleBySlug(slug) {
  return newsArticles.find((article) => article.slug === slug) || newsArticles[0];
}
function getRelatedArticles(currentSlug) {
  return newsArticles.filter((article) => article.slug !== currentSlug).slice(0, 3);
}
function NewsDetailsPage() {
  _s();
  const {
    slug
  } = useParams();
  const article = findArticleBySlug(slug || "");
  const relatedArticles = getRelatedArticles(slug || "");
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(PublicRoute, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative bg-white min-h-screen", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("style", { dangerouslySetInnerHTML: {
      __html: styles
    } }, void 0, false, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 127,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "fixed top-4 right-4 z-50 bg-red-500 text-white px-4 py-2 rounded text-sm font-bold", children: "NEWS DETAILS PAGE" }, void 0, false, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 132,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("section", { className: "relative h-[70vh] lg:h-[80vh] overflow-hidden", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: article.image, alt: article.title, className: "h-full w-full object-cover", onError: (e) => {
          e.currentTarget.src = "/placeholder-news.jpg";
        } }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 139,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-b from-black/30 via-black/50 to-black/70" }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 142,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 138,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 h-full flex items-end", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mx-auto w-full max-w-[1000px] px-4 lg:px-8 pb-16 lg:pb-24", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("nav", { className: "mb-6", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Link, { to: "/news", className: "text-sm text-white/80 hover:text-white transition-colors uppercase tracking-wider flex items-center gap-2", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-4 h-4", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M15 19l-7-7 7-7" }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 152,
            columnNumber: 21
          }, this) }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 151,
            columnNumber: 19
          }, this),
          "Back to News"
        ] }, void 0, true, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 150,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 149,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-4 text-white/60 text-sm bg-black/20 p-2 rounded", children: [
          'Debug: Slug = "',
          slug,
          '" | Article = "',
          article.title,
          '"'
        ] }, void 0, true, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 159,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "inline-block px-4 py-2 bg-white/20 backdrop-blur-sm text-white text-sm font-medium uppercase tracking-wider rounded", children: article.category }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 165,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 164,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-3xl lg:text-5xl font-bold text-white mb-6 leading-tight max-w-4xl", children: article.title }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 171,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex flex-col sm:flex-row sm:items-center gap-4 text-white/90", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center gap-3", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: article.author.avatar, alt: article.author.name, className: "w-10 h-10 rounded-full object-cover bg-white/20", onError: (e) => {
            e.currentTarget.src = "/placeholder-avatar.jpg";
          } }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 178,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "font-medium text-white", children: article.author.name }, void 0, false, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 182,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-sm text-white/70", children: [
              article.publishedAt,
              " \u2022 ",
              article.readTime
            ] }, void 0, true, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 183,
              columnNumber: 21
            }, this)
          ] }, void 0, true, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 181,
            columnNumber: 19
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 177,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 176,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 147,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 146,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 136,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("section", { className: "bg-white py-16 lg:py-24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mx-auto w-full max-w-[800px] px-4 lg:px-8", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "prose prose-lg max-w-none mb-16", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "article-content \n                  [&_h2]:text-2xl [&_h2]:lg:text-3xl [&_h2]:font-bold [&_h2]:text-black [&_h2]:mb-6 [&_h2]:mt-12 [&_h2]:leading-tight\n                  [&_h3]:text-xl [&_h3]:lg:text-2xl [&_h3]:font-bold [&_h3]:text-black [&_h3]:mb-4 [&_h3]:mt-8 [&_h3]:leading-tight\n                  [&_p]:text-black/80 [&_p]:text-base [&_p]:lg:text-lg [&_p]:leading-relaxed [&_p]:mb-6\n                  [&_img]:rounded-lg [&_img]:shadow-lg [&_img]:my-8", dangerouslySetInnerHTML: {
        __html: article.content
      } }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 197,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 196,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex flex-wrap gap-3 mb-12 pb-8 border-b border-gray-200", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-sm font-medium text-gray-600 mr-2", children: "Tags:" }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 208,
          columnNumber: 15
        }, this),
        article.tags.map((tag) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "px-4 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-full hover:bg-gray-200 transition-colors cursor-pointer", children: tag }, tag, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 209,
          columnNumber: 40
        }, this))
      ] }, void 0, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 207,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-gray-50 rounded-2xl p-8 mb-12", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-start gap-4", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: article.author.avatar, alt: article.author.name, className: "w-16 h-16 rounded-full object-cover bg-gray-200", onError: (e) => {
          e.currentTarget.src = "/placeholder-avatar.jpg";
        } }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 217,
          columnNumber: 17
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex-1", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h3", { className: "text-xl font-bold text-black mb-2", children: article.author.name }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 221,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-gray-600 mb-4", children: article.author.bio }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 222,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex gap-3", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "sm", children: "Follow" }, void 0, false, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 224,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "sm", children: "View Profile" }, void 0, false, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 225,
              columnNumber: 21
            }, this)
          ] }, void 0, true, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 223,
            columnNumber: 19
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 220,
          columnNumber: 17
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 216,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 215,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h3", { className: "text-xl font-bold text-black mb-4", children: "Share this article" }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 233,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex justify-center gap-3", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "md", children: "Twitter" }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 235,
            columnNumber: 17
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "md", children: "LinkedIn" }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 236,
            columnNumber: 17
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "md", children: "Facebook" }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 237,
            columnNumber: 17
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "fill-black", size: "md", arrowRight: true, children: "Subscribe" }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 238,
            columnNumber: 17
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 234,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 232,
        columnNumber: 13
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 193,
      columnNumber: 11
    }, this) }, void 0, false, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 192,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("section", { className: "bg-gray-50", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mx-auto w-full max-w-[1200px] px-4 lg:px-8 py-16 lg:py-24", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center mb-16", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h2", { className: "text-3xl lg:text-4xl font-bold text-black mb-4", children: "Related news" }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 250,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "w-24 h-1 bg-black mx-auto" }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 253,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 249,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "grid grid-cols-1 lg:grid-cols-3 gap-8 mb-12", children: relatedArticles.map((relatedArticle) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Link, { to: `/news/${relatedArticle.slug}`, className: "group block bg-white shadow-sm hover:shadow-lg transition-all duration-300 overflow-hidden hover:transform hover:scale-[1.02] rounded-lg", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "aspect-[4/3] overflow-hidden bg-neutral-100", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: relatedArticle.image, alt: relatedArticle.title, className: "h-full w-full object-cover transition-transform duration-500 group-hover:scale-105", onError: (e) => {
          e.currentTarget.src = "/placeholder-news.jpg";
        } }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 259,
          columnNumber: 21
        }, this) }, void 0, false, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 258,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "p-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "inline-block px-3 py-1 bg-gray-100 text-gray-600 text-xs font-medium uppercase tracking-wider rounded mb-3", children: relatedArticle.category }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 264,
            columnNumber: 21
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h3", { className: "text-lg font-bold text-black mb-3 group-hover:text-black/80 transition-colors leading-tight", children: relatedArticle.title }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 267,
            columnNumber: 21
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-gray-600 text-sm line-clamp-2 mb-4", children: relatedArticle.excerpt }, void 0, false, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 270,
            columnNumber: 21
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center gap-2 text-xs text-gray-500", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { children: relatedArticle.author.name }, void 0, false, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 274,
              columnNumber: 23
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { children: "\u2022" }, void 0, false, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 275,
              columnNumber: 23
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { children: relatedArticle.publishedAt }, void 0, false, {
              fileName: "app/routes/news.$slug.tsx",
              lineNumber: 276,
              columnNumber: 23
            }, this)
          ] }, void 0, true, {
            fileName: "app/routes/news.$slug.tsx",
            lineNumber: 273,
            columnNumber: 21
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.$slug.tsx",
          lineNumber: 263,
          columnNumber: 19
        }, this)
      ] }, relatedArticle.id, true, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 257,
        columnNumber: 54
      }, this)) }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 256,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "lg", arrowRight: true, className: "text-black", onClick: () => window.location.href = "/news", children: "View All News" }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 283,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/routes/news.$slug.tsx",
        lineNumber: 282,
        columnNumber: 13
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 248,
      columnNumber: 11
    }, this) }, void 0, false, {
      fileName: "app/routes/news.$slug.tsx",
      lineNumber: 247,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/routes/news.$slug.tsx",
    lineNumber: 126,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/routes/news.$slug.tsx",
    lineNumber: 125,
    columnNumber: 10
  }, this);
}
_s(NewsDetailsPage, "DpOdpe+T7d3Ytb7f6neHj0L13w0=", false, function() {
  return [useParams];
});
_c = NewsDetailsPage;
var _c;
$RefreshReg$(_c, "NewsDetailsPage");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;
export {
  NewsDetailsPage as default,
  meta
};
//# sourceMappingURL=build/routes/news.$slug-SEGO46LP.js.map
