"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  config: () => config,
  createRequestHandler: () => createRequestHandler,
  handleRequest: () => handleRequest
});
module.exports = __toCommonJS(index_exports);

// src/classic-compiler/defaultRemixConfig.ts
var config = {
  ignoredRouteFiles: ["**/.*"],
  server: "./server.ts",
  serverBuildPath: "./.netlify/functions-internal/server.mjs",
  serverModuleFormat: "esm"
};

// src/classic-compiler/entry.server.tsx
var import_node_stream = require("stream");
var import_node = require("@remix-run/node");
var import_react = require("@remix-run/react");
var import_isbot = require("isbot");
var import_server = require("react-dom/server");
var import_jsx_runtime = require("react/jsx-runtime");
var ABORT_DELAY = 5e3;
function handleRequest(request, responseStatusCode, responseHeaders, remixContext, _loadContext) {
  const bot = (0, import_isbot.isbot)(request.headers.get("user-agent"));
  return new Promise((resolve, reject) => {
    let shellRendered = false;
    const body = new import_node_stream.PassThrough();
    const stream = (0, import_node.createReadableStreamFromReadable)(body);
    const { pipe, abort } = (0, import_server.renderToPipeableStream)(
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react.RemixServer, { context: remixContext, url: request.url, abortDelay: ABORT_DELAY }),
      {
        onShellReady() {
          if (!bot) {
            shellRendered = true;
            responseHeaders.set("Content-Type", "text/html");
            resolve(
              new Response(stream, {
                headers: responseHeaders,
                status: responseStatusCode
              })
            );
            pipe(body);
          }
        },
        onShellError(error) {
          reject(error);
        },
        onAllReady() {
          clearTimeout(timer);
          if (bot) {
            shellRendered = true;
            responseHeaders.set("Content-Type", "text/html");
            resolve(
              new Response(stream, {
                headers: responseHeaders,
                status: responseStatusCode
              })
            );
            pipe(body);
          }
        },
        onError(error) {
          responseStatusCode = 500;
          if (shellRendered) {
            console.error(error);
          }
        }
      }
    );
    const timer = setTimeout(() => {
      abort();
    }, ABORT_DELAY);
  });
}

// src/common/server.ts
var import_node2 = require("@remix-run/node");
function createRequestHandler({
  build,
  mode,
  getLoadContext
}) {
  const remixHandler = (0, import_node2.createRequestHandler)(build, mode);
  return async (request, context) => {
    const start = Date.now();
    console.log(`[${request.method}] ${request.url}`);
    try {
      const loadContext = await (getLoadContext == null ? void 0 : getLoadContext(request, context)) || context;
      const response = await remixHandler(request, loadContext);
      response.headers.set("x-nf-runtime", "Node");
      console.log(`[${response.status}] ${request.url} (${Date.now() - start}ms)`);
      return response;
    } catch (error) {
      console.error(error);
      return new Response("Internal Error", { status: 500 });
    }
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  config,
  createRequestHandler,
  handleRequest
});
