// src/classic-compiler/defaultRemixConfig.ts
var config = {
  ignoredRouteFiles: ["**/.*"],
  server: "./server.ts",
  serverBuildPath: "./.netlify/functions-internal/server.mjs",
  serverModuleFormat: "esm"
};

// src/classic-compiler/entry.server.tsx
import { PassThrough } from "node:stream";
import { createReadableStreamFromReadable } from "@remix-run/node";
import { RemixServer } from "@remix-run/react";
import { isbot } from "isbot";
import { renderToPipeableStream } from "react-dom/server";
import { jsx } from "react/jsx-runtime";
var ABORT_DELAY = 5e3;
function handleRequest(request, responseStatusCode, responseHeaders, remixContext, _loadContext) {
  const bot = isbot(request.headers.get("user-agent"));
  return new Promise((resolve, reject) => {
    let shellRendered = false;
    const body = new PassThrough();
    const stream = createReadableStreamFromReadable(body);
    const { pipe, abort } = renderToPipeableStream(
      /* @__PURE__ */ jsx(RemixServer, { context: remixContext, url: request.url, abortDelay: ABORT_DELAY }),
      {
        onShellReady() {
          if (!bot) {
            shellRendered = true;
            responseHeaders.set("Content-Type", "text/html");
            resolve(
              new Response(stream, {
                headers: responseHeaders,
                status: responseStatusCode
              })
            );
            pipe(body);
          }
        },
        onShellError(error) {
          reject(error);
        },
        onAllReady() {
          clearTimeout(timer);
          if (bot) {
            shellRendered = true;
            responseHeaders.set("Content-Type", "text/html");
            resolve(
              new Response(stream, {
                headers: responseHeaders,
                status: responseStatusCode
              })
            );
            pipe(body);
          }
        },
        onError(error) {
          responseStatusCode = 500;
          if (shellRendered) {
            console.error(error);
          }
        }
      }
    );
    const timer = setTimeout(() => {
      abort();
    }, ABORT_DELAY);
  });
}

// src/common/server.ts
import { createRequestHandler as createRemixRequestHandler } from "@remix-run/node";
function createRequestHandler({
  build,
  mode,
  getLoadContext
}) {
  const remixHandler = createRemixRequestHandler(build, mode);
  return async (request, context) => {
    const start = Date.now();
    console.log(`[${request.method}] ${request.url}`);
    try {
      const loadContext = await (getLoadContext == null ? void 0 : getLoadContext(request, context)) || context;
      const response = await remixHandler(request, loadContext);
      response.headers.set("x-nf-runtime", "Node");
      console.log(`[${response.status}] ${request.url} (${Date.now() - start}ms)`);
      return response;
    } catch (error) {
      console.error(error);
      return new Response("Internal Error", { status: 500 });
    }
  };
}
export {
  config,
  createRequestHandler,
  handleRequest
};
