"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/vite/plugin.ts
var plugin_exports = {};
__export(plugin_exports, {
  netlifyPlugin: () => netlifyPlugin
});
module.exports = __toCommonJS(plugin_exports);
var import_promises = require("fs/promises");
var import_node_path = require("path");
var import_posix = require("path/posix");

// package.json
var name = "@netlify/remix-adapter";
var version = "2.6.1";

// src/vite/plugin.ts
var NETLIFY_FUNCTIONS_DIR = ".netlify/functions-internal";
var FUNCTION_FILENAME = "remix-server.mjs";
var FUNCTION_HANDLER_CHUNK = "server";
var FUNCTION_HANDLER_MODULE_ID = "virtual:netlify-server";
var RESOLVED_FUNCTION_HANDLER_MODULE_ID = `\0${FUNCTION_HANDLER_MODULE_ID}`;
var toPosixPath = (path) => path.split(import_node_path.sep).join(import_posix.sep);
var FUNCTION_HANDLER = (
  /* js */
  `
import { createRequestHandler } from "@netlify/remix-adapter";
import * as build from "virtual:remix/server-build";
export default createRequestHandler({
  build,
  getLoadContext: async (_req, ctx) => ctx,
});
`
);
function generateNetlifyFunction(handlerPath) {
  return (
    /* js */
    `
    export { default } from "${handlerPath}";

    export const config = {
      name: "Remix server handler",
      generator: "${name}@${version}",
      path: "/*",
      preferStatic: true,
    };
    `
  );
}
function netlifyPlugin() {
  let resolvedConfig;
  let currentCommand;
  let isSsr;
  return {
    name: "vite-plugin-remix-netlify-functions",
    config(config, { command, isSsrBuild }) {
      var _a, _b;
      currentCommand = command;
      isSsr = isSsrBuild;
      if (command === "build") {
        if (isSsrBuild) {
          if (typeof ((_b = (_a = config.build) == null ? void 0 : _a.rollupOptions) == null ? void 0 : _b.input) === "string") {
            config.build.rollupOptions.input = {
              [FUNCTION_HANDLER_CHUNK]: FUNCTION_HANDLER_MODULE_ID,
              index: config.build.rollupOptions.input
            };
            if (config.build.rollupOptions.output && !Array.isArray(config.build.rollupOptions.output)) {
              config.build.rollupOptions.output.entryFileNames = "[name].js";
            }
          }
        }
      }
    },
    async resolveId(source) {
      if (source === FUNCTION_HANDLER_MODULE_ID) {
        return RESOLVED_FUNCTION_HANDLER_MODULE_ID;
      }
    },
    // See https://vitejs.dev/guide/api-plugin#virtual-modules-convention.
    load(id) {
      if (id === RESOLVED_FUNCTION_HANDLER_MODULE_ID) {
        return FUNCTION_HANDLER;
      }
    },
    async configResolved(config) {
      resolvedConfig = config;
    },
    // See https://rollupjs.org/plugin-development/#writebundle.
    async writeBundle() {
      if (currentCommand === "build" && isSsr) {
        const functionsDirectory = (0, import_node_path.join)(resolvedConfig.root, NETLIFY_FUNCTIONS_DIR);
        await (0, import_promises.mkdir)(functionsDirectory, { recursive: true });
        const handlerPath = (0, import_node_path.join)(resolvedConfig.build.outDir, `${FUNCTION_HANDLER_CHUNK}.js`);
        const relativeHandlerPath = toPosixPath((0, import_node_path.relative)(functionsDirectory, handlerPath));
        await (0, import_promises.writeFile)((0, import_node_path.join)(functionsDirectory, FUNCTION_FILENAME), generateNetlifyFunction(relativeHandlerPath));
      }
    }
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  netlifyPlugin
});
