import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";

// app/lib/api.ts
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\lib\\api.ts"
  );
  import.meta.hot.lastModified = "1760465839325.3445";
}
var API_BASE_URL = "https://nomadicstudios.net:444/api";
var getAuthToken = () => {
  if (typeof window !== "undefined") {
    return localStorage.getItem("auth_token");
  }
  return null;
};
var setAuthToken = (token) => {
  if (typeof window !== "undefined") {
    localStorage.setItem("auth_token", token);
  }
};
var removeAuthToken = () => {
  if (typeof window !== "undefined") {
    localStorage.removeItem("auth_token");
    localStorage.removeItem("user_data");
  }
};
var setUserData = (user) => {
  if (typeof window !== "undefined") {
    localStorage.setItem("user_data", JSON.stringify(user));
  }
};
var getUserData = () => {
  if (typeof window !== "undefined") {
    const userData = localStorage.getItem("user_data");
    return userData ? JSON.parse(userData) : null;
  }
  return null;
};
async function apiRequest(endpoint, options = {}) {
  const token = getAuthToken();
  const defaultHeaders = {
    "Content-Type": "application/json",
    Accept: "application/json"
  };
  if (token) {
    defaultHeaders.Authorization = `Bearer ${token}`;
  }
  const response = await fetch(`${API_BASE_URL}${endpoint}`, {
    ...options,
    headers: {
      ...defaultHeaders,
      ...options.headers
    }
  });
  const data = await response.json();
  if (!response.ok) {
    throw new Error(data.error || `HTTP error! status: ${response.status}`);
  }
  return data;
}
var authAPI = {
  // Email/Password Login
  login: async (email, password) => {
    return apiRequest("/login", {
      method: "POST",
      body: JSON.stringify({ email, password })
    });
  },
  // Send OTP to mobile number
  sendOTP: async (mobile_number) => {
    return apiRequest("/send-otp", {
      method: "POST",
      body: JSON.stringify({ mobile_number })
    });
  },
  // Verify OTP and login
  verifyOTP: async (mobile_number, otp_number, request_type = "login", additionalData) => {
    const payload = {
      request_type,
      otp_number,
      mobile_number
    };
    if (additionalData) {
      Object.assign(payload, additionalData);
    }
    return apiRequest("/verify-otp", {
      method: "POST",
      body: JSON.stringify(payload)
    });
  },
  // Logout
  logout: async () => {
    return apiRequest("/logout", {
      method: "POST"
    });
  },
  // Forgot Password - Send OTP to mobile
  forgotPassword: async (email) => {
    return apiRequest("/forgot-password", {
      method: "POST",
      body: JSON.stringify({ email })
    });
  },
  // Reset Password
  resetPassword: async (email) => {
    return apiRequest("/reset-password", {
      method: "POST",
      body: JSON.stringify({ email })
    });
  },
  // Save Profile Picture
  saveProfilePicture: async (uuid, image) => {
    return apiRequest("/save-profile-picture", {
      method: "POST",
      body: JSON.stringify({ uuid, image })
    });
  },
  // Save Additional Information
  saveAdditionalInfo: async (data) => {
    return apiRequest("/additional-info-save", {
      method: "POST",
      body: JSON.stringify(data)
    });
  }
};
var locationsAPI = {
  // Get all locations
  getLocations: async () => {
    return apiRequest("/locations", {
      method: "GET"
    });
  }
};
var isAuthenticated = () => {
  return getAuthToken() !== null;
};
var handleAuthSuccess = (response) => {
  if (response.token) {
    setAuthToken(response.token);
    console.log("Auth token set");
  }
  if (response.user) {
    setUserData(response.user);
    console.log("User data set");
  }
};
var handleLogout = async () => {
  try {
    await authAPI.logout();
  } catch (error) {
    console.error("Logout error:", error);
  } finally {
    removeAuthToken();
  }
};

export {
  getUserData,
  authAPI,
  locationsAPI,
  isAuthenticated,
  handleAuthSuccess,
  handleLogout
};
//# sourceMappingURL=build/_shared/chunk-4X4B3Y7G.js.map
