import {
  authAPI,
  handleAuthSuccess
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  useLocation,
  useNavigate
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/auth/OtpVerification.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\OtpVerification.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\OtpVerification.tsx"
  );
  import.meta.hot.lastModified = "1760464886202.9197";
}
var OtpVerification = () => {
  _s();
  const navigate = useNavigate();
  const location = useLocation();
  const [isVisible, setIsVisible] = (0, import_react.useState)(false);
  const [otp, setOtp] = (0, import_react.useState)(["", "", "", "", "", ""]);
  const [isLoading, setIsLoading] = (0, import_react.useState)(false);
  const [error, setError] = (0, import_react.useState)(null);
  const [resendTimer, setResendTimer] = (0, import_react.useState)(30);
  const [canResend, setCanResend] = (0, import_react.useState)(false);
  const phoneNumber = location.state?.phoneNumber || "+1 XXX XXX XXXX";
  const requestType = location.state?.requestType || "login";
  const signupData = location.state?.signupData;
  (0, import_react.useEffect)(() => {
    setIsVisible(true);
    const timer = setInterval(() => {
      setResendTimer((prev) => {
        if (prev <= 1) {
          setCanResend(true);
          clearInterval(timer);
          return 0;
        }
        return prev - 1;
      });
    }, 1e3);
    return () => clearInterval(timer);
  }, []);
  const handleOtpChange = (index, value) => {
    if (value.length > 1)
      return;
    const newOtp = [...otp];
    newOtp[index] = value;
    setOtp(newOtp);
    if (value && index < 5) {
      const nextInput = document.getElementById(`otp-${index + 1}`);
      nextInput?.focus();
    }
    if (error)
      setError(null);
  };
  const handleKeyDown = (index, e) => {
    if (e.key === "Backspace" && !otp[index] && index > 0) {
      const prevInput = document.getElementById(`otp-${index - 1}`);
      prevInput?.focus();
    }
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    const otpString = otp.join("");
    if (otpString.length !== 6) {
      setError("Please enter the complete 6-digit code");
      return;
    }
    setIsLoading(true);
    setError(null);
    try {
      let response;
      if (requestType === "signup" && signupData) {
        response = await authAPI.verifyOTP(phoneNumber, otpString, requestType, signupData);
      } else {
        response = await authAPI.verifyOTP(phoneNumber, otpString, requestType);
      }
      if (response.status) {
        if (requestType === "signup") {
          navigate("/upload-profile-picture", {
            state: {
              uuid: response.uuid,
              userData: signupData
            }
          });
        } else {
          handleAuthSuccess(response);
          setTimeout(() => {
            window.location.href = "/home";
          }, 100);
        }
      } else {
        setError(response.error || "Invalid verification code. Please try again.");
      }
    } catch (err) {
      console.error("OTP verification error:", err);
      setError(err instanceof Error ? err.message : "Verification failed. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  const handleResend = async () => {
    if (!canResend)
      return;
    setIsLoading(true);
    setError(null);
    try {
      const response = await authAPI.sendOTP(phoneNumber);
      if (response.status) {
        setResendTimer(30);
        setCanResend(false);
        setOtp(["", "", "", "", "", ""]);
        const timer = setInterval(() => {
          setResendTimer((prev) => {
            if (prev <= 1) {
              setCanResend(true);
              clearInterval(timer);
              return 0;
            }
            return prev - 1;
          });
        }, 1e3);
      } else {
        setError(response.error || "Failed to resend code. Please try again.");
      }
    } catch (err) {
      console.error("Resend OTP error:", err);
      setError(err instanceof Error ? err.message : "Failed to resend code. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 160,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 161,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/OtpVerification.tsx",
      lineNumber: 159,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 166,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 170,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 173,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 176,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/OtpVerification.tsx",
      lineNumber: 165,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "CONFIRM YOUR PHONE" }, void 0, false, {
          fileName: "app/components/auth/OtpVerification.tsx",
          lineNumber: 186,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: [
          "Please input 6-digit code we just sent to ",
          phoneNumber
        ] }, void 0, true, {
          fileName: "app/components/auth/OtpVerification.tsx",
          lineNumber: 189,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 185,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-full max-w-md transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/OtpVerification.tsx",
          lineNumber: 198,
          columnNumber: 23
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("form", { onSubmit: handleSubmit, className: "space-y-8", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex justify-center space-x-3", children: otp.map((digit, index) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { id: `otp-${index}`, type: "text", inputMode: "numeric", maxLength: 1, value: digit, onChange: (e) => handleOtpChange(index, e.target.value), onKeyDown: (e) => handleKeyDown(index, e), className: "w-12 h-14 text-center text-2xl font-bold bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 text-white backdrop-blur-sm transition-all", disabled: isLoading, autoComplete: "off" }, index, false, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 205,
            columnNumber: 44
          }, this)) }, void 0, false, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 204,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center", children: !canResend ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-white/60 text-sm", children: [
            "Didn't get an SMS? Resend in ",
            resendTimer,
            " seconds"
          ] }, void 0, true, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 210,
            columnNumber: 31
          }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", onClick: handleResend, disabled: isLoading, children: "Resend code" }, void 0, false, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 212,
            columnNumber: 26
          }, this) }, void 0, false, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 209,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading || otp.some((digit) => !digit), arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
              fileName: "app/components/auth/OtpVerification.tsx",
              lineNumber: 220,
              columnNumber: 21
            }, this),
            "Verifying..."
          ] }, void 0, true, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 219,
            columnNumber: 30
          }, this) : "Submit" }, void 0, false, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 218,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center text-white/60 text-sm pt-4", children: [
            "Wrong phone number?",
            " ",
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", className: "ml-2", onClick: () => navigate("/login"), children: "Login" }, void 0, false, {
              fileName: "app/components/auth/OtpVerification.tsx",
              lineNumber: 228,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/OtpVerification.tsx",
            lineNumber: 226,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/OtpVerification.tsx",
          lineNumber: 202,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 196,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/OtpVerification.tsx",
        lineNumber: 195,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/OtpVerification.tsx",
      lineNumber: 183,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/OtpVerification.tsx",
    lineNumber: 157,
    columnNumber: 10
  }, this);
};
_s(OtpVerification, "EE10t0M7C5lXc7sBvp9Qxs6YgDs=", false, function() {
  return [useNavigate, useLocation];
});
_c = OtpVerification;
var OtpVerification_default = OtpVerification;
var _c;
$RefreshReg$(_c, "OtpVerification");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

export {
  OtpVerification_default
};
//# sourceMappingURL=build/_shared/chunk-D2XZC4TD.js.map
