import {
  authAPI,
  locationsAPI
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  useLocation,
  useNavigate
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/auth/AdditionalInformation.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\AdditionalInformation.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\AdditionalInformation.tsx"
  );
  import.meta.hot.lastModified = "1760464886201.9048";
}
var AdditionalInformation = () => {
  _s();
  const navigate = useNavigate();
  const location = useLocation();
  const [isVisible, setIsVisible] = (0, import_react.useState)(false);
  const [isLoading, setIsLoading] = (0, import_react.useState)(false);
  const [error, setError] = (0, import_react.useState)(null);
  const uuid = location.state?.uuid;
  const userData = location.state?.userData;
  const [formData, setFormData] = (0, import_react.useState)({
    home_city: "",
    creator_interest: [],
    profile_link: "",
    instagram_link: "",
    facebook_link: "",
    twitter_link: "",
    sm_link: "",
    referred_by: ""
  });
  const creativeInterests = ["Fine Art", "Fashion", "Music", "Photography", "Video", "Maker Space"];
  const [locations, setLocations] = (0, import_react.useState)([]);
  const [locationsLoading, setLocationsLoading] = (0, import_react.useState)(true);
  (0, import_react.useEffect)(() => {
    if (!uuid) {
      navigate("/signup");
      return;
    }
    setIsVisible(true);
    const fetchLocations = async () => {
      try {
        setLocationsLoading(true);
        const response = await locationsAPI.getLocations();
        if (response.status && response.data) {
          const uniqueLocations = response.data.filter((location2, index, self) => index === self.findIndex((l) => l.id === location2.id && l.location === location2.location));
          setLocations(uniqueLocations);
        } else {
          console.error("Failed to fetch locations:", response.error);
        }
      } catch (error2) {
        console.error("Error fetching locations:", error2);
      } finally {
        setLocationsLoading(false);
      }
    };
    fetchLocations();
  }, [uuid, navigate]);
  const handleInputChange = (e) => {
    const {
      name,
      value
    } = e.target;
    setFormData((prev) => ({
      ...prev,
      [name]: value
    }));
    if (error)
      setError(null);
  };
  const handleInterestToggle = (interest) => {
    setFormData((prev) => ({
      ...prev,
      creator_interest: prev.creator_interest.includes(interest) ? prev.creator_interest.filter((i) => i !== interest) : [...prev.creator_interest, interest]
    }));
    if (error)
      setError(null);
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    if (!formData.home_city.trim()) {
      setError("Home city is required");
      return;
    }
    setIsLoading(true);
    setError(null);
    try {
      const response = await authAPI.saveAdditionalInfo({
        uuid,
        home_city: formData.home_city,
        // Send location name instead of ID
        creator_interest: formData.creator_interest,
        profile_link: formData.profile_link || void 0,
        instagram_link: formData.instagram_link || void 0,
        facebook_link: formData.facebook_link || void 0,
        twitter_link: formData.twitter_link || void 0,
        sm_link: formData.sm_link || void 0,
        referred_by: formData.referred_by || void 0
      });
      if (response.status) {
        navigate("/login", {
          state: {
            message: "Account created successfully! Please login to continue.",
            type: "success"
          }
        });
      } else {
        setError(response.error || "Failed to save information. Please try again.");
      }
    } catch (err) {
      console.error("Additional info save error:", err);
      setError(err instanceof Error ? err.message : "An unexpected error occurred. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("style", { children: `
        select option {
          background-color: #1f2937 !important;
          color: white !important;
          padding: 8px !important;
        }
        select option:hover {
          background-color: #374151 !important;
        }
        select option:checked {
          background-color: #f97316 !important;
        }
      ` }, void 0, false, {
      fileName: "app/components/auth/AdditionalInformation.tsx",
      lineNumber: 140,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 156,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 157,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/AdditionalInformation.tsx",
        lineNumber: 155,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
          animationDelay: "0s",
          animationDuration: "3s"
        } }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 162,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
          animationDelay: "1s"
        } }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 166,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
          animationDelay: "2s"
        } }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 169,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
          animationDelay: "1.5s",
          animationDuration: "4s"
        } }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 172,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/AdditionalInformation.tsx",
        lineNumber: 161,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0 py-12", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "We would like to know you more" }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 182,
          columnNumber: 13
        }, this) }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 181,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-full max-w-2xl transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
          error && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
            fileName: "app/components/auth/AdditionalInformation.tsx",
            lineNumber: 191,
            columnNumber: 25
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("form", { onSubmit: handleSubmit, className: "space-y-6", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "What is your home city? *" }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 198,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("select", { name: "home_city", value: formData.home_city, onChange: handleInputChange, className: "w-full px-4 py-4 bg-gray-800/90 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 text-white backdrop-blur-sm transition-all appearance-none cursor-pointer hover:bg-gray-700/90", required: true, disabled: isLoading || locationsLoading, style: {
                  colorScheme: "dark"
                }, children: [
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("option", { value: "", className: "bg-gray-800 text-gray-400", children: locationsLoading ? "Loading locations..." : "Select a location" }, void 0, false, {
                    fileName: "app/components/auth/AdditionalInformation.tsx",
                    lineNumber: 205,
                    columnNumber: 23
                  }, this),
                  locations.map((location2) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("option", { value: location2.id.toString(), className: "bg-gray-800 text-white py-2", children: location2.location }, `${location2.id}-${location2.location}`, false, {
                    fileName: "app/components/auth/AdditionalInformation.tsx",
                    lineNumber: 208,
                    columnNumber: 50
                  }, this))
                ] }, void 0, true, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 202,
                  columnNumber: 21
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 text-white/60 pointer-events-none", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M19 9l-7 7-7-7" }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 213,
                  columnNumber: 23
                }, this) }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 212,
                  columnNumber: 21
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 201,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 197,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-4", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "What are you creating?" }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 220,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "grid grid-cols-2 gap-4", children: creativeInterests.map((interest) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `flex items-center p-4 rounded-xl border-2 cursor-pointer transition-all ${formData.creator_interest.includes(interest) ? "border-orange-400 bg-orange-500/20" : "border-white/20 bg-white/5 hover:bg-white/10"}`, onClick: () => handleInterestToggle(interest), children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-5 h-5 rounded border-2 transition-all duration-200 ${formData.creator_interest.includes(interest) ? "border-orange-400 bg-orange-400" : "border-white/40"}`, children: formData.creator_interest.includes(interest) && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-3 h-3 text-white ml-0.5 mt-0.5", fill: "currentColor", viewBox: "0 0 20 20", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { fillRule: "evenodd", d: "M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z", clipRule: "evenodd" }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 227,
                  columnNumber: 31
                }, this) }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 226,
                  columnNumber: 76
                }, this) }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 225,
                  columnNumber: 25
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-white ml-3 font-medium", children: interest }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 230,
                  columnNumber: 25
                }, this)
              ] }, interest, true, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 224,
                columnNumber: 56
              }, this)) }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 223,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 219,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Link to profile" }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 239,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "url", name: "profile_link", placeholder: "Link", value: formData.profile_link, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 242,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 238,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-4", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Link to social media" }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 247,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-3", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "url", name: "instagram_link", placeholder: "Link to Instagram", value: formData.instagram_link, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", disabled: isLoading }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 251,
                  columnNumber: 21
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "url", name: "facebook_link", placeholder: "Link to Facebook", value: formData.facebook_link, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", disabled: isLoading }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 252,
                  columnNumber: 21
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "url", name: "twitter_link", placeholder: "Link to Twitter", value: formData.twitter_link, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", disabled: isLoading }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 253,
                  columnNumber: 21
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "url", name: "sm_link", placeholder: "Link to SM", value: formData.sm_link, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", disabled: isLoading }, void 0, false, {
                  fileName: "app/components/auth/AdditionalInformation.tsx",
                  lineNumber: 254,
                  columnNumber: 21
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 250,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 246,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Please provide the name of the member who referred you" }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 260,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "text", name: "referred_by", placeholder: "Name", value: formData.referred_by, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 263,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 259,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "pt-6", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
                fileName: "app/components/auth/AdditionalInformation.tsx",
                lineNumber: 270,
                columnNumber: 25
              }, this),
              "Saving..."
            ] }, void 0, true, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 269,
              columnNumber: 34
            }, this) : "Save" }, void 0, false, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 268,
              columnNumber: 19
            }, this) }, void 0, false, {
              fileName: "app/components/auth/AdditionalInformation.tsx",
              lineNumber: 267,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/AdditionalInformation.tsx",
            lineNumber: 195,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 189,
          columnNumber: 13
        }, this) }, void 0, false, {
          fileName: "app/components/auth/AdditionalInformation.tsx",
          lineNumber: 188,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/AdditionalInformation.tsx",
        lineNumber: 179,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/AdditionalInformation.tsx",
      lineNumber: 153,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/AdditionalInformation.tsx",
    lineNumber: 139,
    columnNumber: 10
  }, this);
};
_s(AdditionalInformation, "CwM68mOY18LbxI/sWwBTyESULmQ=", false, function() {
  return [useNavigate, useLocation];
});
_c = AdditionalInformation;
var AdditionalInformation_default = AdditionalInformation;
var _c;
$RefreshReg$(_c, "AdditionalInformation");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

export {
  AdditionalInformation_default
};
//# sourceMappingURL=build/_shared/chunk-IVXLRPSU.js.map
