import {
  authAPI,
  getUserData,
  handleAuthSuccess,
  handleLogout,
  isAuthenticated
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  Link,
  useLocation,
  useNavigate,
  useSearchParams
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/auth/SignIn.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\SignIn.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\SignIn.tsx"
  );
  import.meta.hot.lastModified = "1760464886203.3677";
}
var SignIn = () => {
  _s();
  const navigate = useNavigate();
  const location = useLocation();
  const [isVisible, setIsVisible] = (0, import_react.useState)(false);
  const [phoneFormData, setPhoneFormData] = (0, import_react.useState)({
    mobileNumber: "",
    keepLoggedIn: true
  });
  const [selectedCountry, setSelectedCountry] = (0, import_react.useState)({
    code: "+1",
    country: "United States",
    flag: "\u{1F1FA}\u{1F1F8}"
  });
  const [isDropdownOpen, setIsDropdownOpen] = (0, import_react.useState)(false);
  const [isLoading, setIsLoading] = (0, import_react.useState)(false);
  const [error, setError] = (0, import_react.useState)(null);
  const [successMessage, setSuccessMessage] = (0, import_react.useState)(null);
  const countryCodes = [{
    code: "+61",
    country: "Australia",
    flag: "\u{1F1E6}\u{1F1FA}"
  }, {
    code: "+43",
    country: "Austria",
    flag: "\u{1F1E6}\u{1F1F9}"
  }, {
    code: "+54",
    country: "Argentina",
    flag: "\u{1F1E6}\u{1F1F7}"
  }, {
    code: "+32",
    country: "Belgium",
    flag: "\u{1F1E7}\u{1F1EA}"
  }, {
    code: "+359",
    country: "Bulgaria",
    flag: "\u{1F1E7}\u{1F1EC}"
  }, {
    code: "+55",
    country: "Brazil",
    flag: "\u{1F1E7}\u{1F1F7}"
  }, {
    code: "+56",
    country: "Chile",
    flag: "\u{1F1E8}\u{1F1F1}"
  }, {
    code: "+86",
    country: "China",
    flag: "\u{1F1E8}\u{1F1F3}"
  }, {
    code: "+420",
    country: "Czech Republic",
    flag: "\u{1F1E8}\u{1F1FF}"
  }, {
    code: "+385",
    country: "Croatia",
    flag: "\u{1F1ED}\u{1F1F7}"
  }, {
    code: "+20",
    country: "Egypt",
    flag: "\u{1F1EA}\u{1F1EC}"
  }, {
    code: "+33",
    country: "France",
    flag: "\u{1F1EB}\u{1F1F7}"
  }, {
    code: "+358",
    country: "Finland",
    flag: "\u{1F1EB}\u{1F1EE}"
  }, {
    code: "+30",
    country: "Greece",
    flag: "\u{1F1EC}\u{1F1F7}"
  }, {
    code: "+49",
    country: "Germany",
    flag: "\u{1F1E9}\u{1F1EA}"
  }, {
    code: "+353",
    country: "Ireland",
    flag: "\u{1F1EE}\u{1F1EA}"
  }, {
    code: "+91",
    country: "India",
    flag: "\u{1F1EE}\u{1F1F3}"
  }, {
    code: "+972",
    country: "Israel",
    flag: "\u{1F1EE}\u{1F1F1}"
  }, {
    code: "+62",
    country: "Indonesia",
    flag: "\u{1F1EE}\u{1F1E9}"
  }, {
    code: "+81",
    country: "Japan",
    flag: "\u{1F1EF}\u{1F1F5}"
  }, {
    code: "+254",
    country: "Kenya",
    flag: "\u{1F1F0}\u{1F1EA}"
  }, {
    code: "+82",
    country: "South Korea",
    flag: "\u{1F1F0}\u{1F1F7}"
  }, {
    code: "+36",
    country: "Hungary",
    flag: "\u{1F1ED}\u{1F1FA}"
  }, {
    code: "+385",
    country: "Croatia",
    flag: "\u{1F1ED}\u{1F1F7}"
  }, {
    code: "+39",
    country: "Italy",
    flag: "\u{1F1EE}\u{1F1F9}"
  }, {
    code: "+353",
    country: "Ireland",
    flag: "\u{1F1EE}\u{1F1EA}"
  }, {
    code: "+234",
    country: "Nigeria",
    flag: "\u{1F1F3}\u{1F1EC}"
  }, {
    code: "+31",
    country: "Netherlands",
    flag: "\u{1F1F3}\u{1F1F1}"
  }, {
    code: "+64",
    country: "New Zealand",
    flag: "\u{1F1F3}\u{1F1FF}"
  }, {
    code: "+351",
    country: "Portugal",
    flag: "\u{1F1F5}\u{1F1F9}"
  }, {
    code: "+48",
    country: "Poland",
    flag: "\u{1F1F5}\u{1F1F1}"
  }, {
    code: "+51",
    country: "Peru",
    flag: "\u{1F1F5}\u{1F1EA}"
  }, {
    code: "+63",
    country: "Philippines",
    flag: "\u{1F1F5}\u{1F1ED}"
  }, {
    code: "+966",
    country: "Saudi Arabia",
    flag: "\u{1F1F8}\u{1F1E6}"
  }, {
    code: "+65",
    country: "Singapore",
    flag: "\u{1F1F8}\u{1F1EC}"
  }, {
    code: "+46",
    country: "Sweden",
    flag: "\u{1F1F8}\u{1F1EA}"
  }, {
    code: "+41",
    country: "Switzerland",
    flag: "\u{1F1E8}\u{1F1ED}"
  }, {
    code: "+90",
    country: "Turkey",
    flag: "\u{1F1F9}\u{1F1F7}"
  }, {
    code: "+66",
    country: "Thailand",
    flag: "\u{1F1F9}\u{1F1ED}"
  }, {
    code: "+27",
    country: "South Africa",
    flag: "\u{1F1FF}\u{1F1E6}"
  }, {
    code: "+44",
    country: "United Kingdom",
    flag: "\u{1F1EC}\u{1F1E7}"
  }, {
    code: "+1",
    country: "United States",
    flag: "\u{1F1FA}\u{1F1F8}"
  }, {
    code: "+971",
    country: "UAE",
    flag: "\u{1F1E6}\u{1F1EA}"
  }, {
    code: "+380",
    country: "Ukraine",
    flag: "\u{1F1FA}\u{1F1E6}"
  }, {
    code: "+34",
    country: "Spain",
    flag: "\u{1F1EA}\u{1F1F8}"
  }, {
    code: "+91",
    country: "India",
    flag: "\u{1F1EE}\u{1F1F3}"
  }, {
    code: "+84",
    country: "Vietnam",
    flag: "\u{1F1FB}\u{1F1F3}"
  }, {
    code: "+58",
    country: "Venezuela",
    flag: "\u{1F1FB}\u{1F1EA}"
  }, {
    code: "+52",
    country: "Mexico",
    flag: "\u{1F1F2}\u{1F1FD}"
  }];
  (0, import_react.useEffect)(() => {
    setIsVisible(true);
    if (location.state?.message && location.state?.type === "success") {
      setSuccessMessage(location.state.message);
      window.history.replaceState({}, document.title);
    }
  }, [location.state]);
  (0, import_react.useEffect)(() => {
    const handleKeyPress = (e) => {
      if (isDropdownOpen) {
        const key = e.key.toLowerCase();
        const matchingCountry = countryCodes.find((country) => country.country.toLowerCase().startsWith(key));
        if (matchingCountry) {
          const countryElement = document.querySelector(`[data-country="${matchingCountry.country}"]`);
          if (countryElement) {
            countryElement.scrollIntoView({
              block: "nearest"
            });
            countryElement.focus();
          }
        }
      }
    };
    if (isDropdownOpen) {
      document.addEventListener("keydown", handleKeyPress);
    }
    return () => {
      document.removeEventListener("keydown", handleKeyPress);
    };
  }, [isDropdownOpen]);
  const handlePhoneInputChange = (e) => {
    const {
      name,
      value,
      type,
      checked
    } = e.target;
    setPhoneFormData((prev) => ({
      ...prev,
      [name]: type === "checkbox" ? checked : value
    }));
    if (error)
      setError(null);
  };
  const handleCountrySelect = (country) => {
    setSelectedCountry(country);
    setIsDropdownOpen(false);
  };
  const handleSendOTP = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    setError(null);
    try {
      const fullNumber = `${selectedCountry.code}${phoneFormData.mobileNumber}`;
      const response = await authAPI.sendOTP(fullNumber);
      if (response.status) {
        navigate("/otp-verification", {
          state: {
            phoneNumber: fullNumber,
            requestType: "login"
          }
        });
      } else {
        setError(response.error || "Failed to send OTP. Please try again.");
      }
    } catch (err) {
      console.error("Send OTP error:", err);
      setError(err instanceof Error ? err.message : "An unexpected error occurred. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 323,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 324,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignIn.tsx",
      lineNumber: 322,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 329,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 333,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 336,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 339,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignIn.tsx",
      lineNumber: 328,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "WELCOME BACK" }, void 0, false, {
          fileName: "app/components/auth/SignIn.tsx",
          lineNumber: 349,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: "Continue your creative journey" }, void 0, false, {
          fileName: "app/components/auth/SignIn.tsx",
          lineNumber: 352,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 348,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-full max-w-md transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h2", { className: "text-2xl font-semibold mb-8 text-white text-center uppercase tracking-wider", children: "Sign In" }, void 0, false, {
          fileName: "app/components/auth/SignIn.tsx",
          lineNumber: 360,
          columnNumber: 13
        }, this),
        successMessage && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-green-500/20 border border-green-500/30 text-green-200 rounded-xl text-sm backdrop-blur-sm", children: successMessage }, void 0, false, {
          fileName: "app/components/auth/SignIn.tsx",
          lineNumber: 365,
          columnNumber: 32
        }, this),
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/SignIn.tsx",
          lineNumber: 370,
          columnNumber: 23
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("form", { onSubmit: handleSendOTP, className: "space-y-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Mobile Number" }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 378,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex relative", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { type: "button", onClick: () => setIsDropdownOpen(!isDropdownOpen), className: "flex items-center px-4 py-4 bg-white/10 border border-white/20 border-r-0 hover:bg-white/20 focus:outline-none focus:ring-2 focus:ring-orange-400 backdrop-blur-sm transition-all", children: [
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-lg mr-2", children: selectedCountry.flag }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 385,
                    columnNumber: 23
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-sm text-white/80 mr-1", children: selectedCountry.code }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 388,
                    columnNumber: 23
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-4 h-4 text-white/60", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M19 9l-7 7-7-7" }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 392,
                    columnNumber: 25
                  }, this) }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 391,
                    columnNumber: 23
                  }, this)
                ] }, void 0, true, {
                  fileName: "app/components/auth/SignIn.tsx",
                  lineNumber: 384,
                  columnNumber: 21
                }, this),
                isDropdownOpen && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute z-20 top-full left-0 w-64 bg-black border border-white/20 shadow-2xl max-h-60 overflow-y-auto", children: countryCodes.map((country, index) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { type: "button", onClick: () => handleCountrySelect(country), "data-country": country.country, className: "w-full flex items-center px-4 py-3 text-left hover:bg-white/20 focus:outline-none focus:bg-white/20 transition-colors", children: [
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-lg mr-3", children: country.flag }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 399,
                    columnNumber: 29
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-sm text-white/80 mr-2", children: country.code }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 400,
                    columnNumber: 29
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-sm text-white truncate", children: country.country }, void 0, false, {
                    fileName: "app/components/auth/SignIn.tsx",
                    lineNumber: 403,
                    columnNumber: 29
                  }, this)
                ] }, index, true, {
                  fileName: "app/components/auth/SignIn.tsx",
                  lineNumber: 398,
                  columnNumber: 63
                }, this)) }, void 0, false, {
                  fileName: "app/components/auth/SignIn.tsx",
                  lineNumber: 397,
                  columnNumber: 40
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/SignIn.tsx",
                lineNumber: 383,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "tel", name: "mobileNumber", placeholder: "Enter your mobile number", value: phoneFormData.mobileNumber, onChange: handlePhoneInputChange, className: "flex-1 px-4 py-4 bg-white/10 border border-white/20 focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true }, void 0, false, {
                fileName: "app/components/auth/SignIn.tsx",
                lineNumber: 410,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 381,
              columnNumber: 17
            }, this),
            isDropdownOpen && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "fixed inset-0 z-10", onClick: () => setIsDropdownOpen(false) }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 414,
              columnNumber: 36
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignIn.tsx",
            lineNumber: 377,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center justify-between", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "checkbox", id: "keepLoggedInPhone", name: "keepLoggedIn", checked: phoneFormData.keepLoggedIn, onChange: handlePhoneInputChange, className: "w-5 h-5 text-orange-500 bg-white/10 border-white/20 rounded focus:ring-orange-400 focus:ring-2" }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 420,
              columnNumber: 19
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { htmlFor: "keepLoggedInPhone", className: "ml-3 text-sm text-white/80", children: "Keep me logged in" }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 421,
              columnNumber: 19
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignIn.tsx",
            lineNumber: 419,
            columnNumber: 17
          }, this) }, void 0, false, {
            fileName: "app/components/auth/SignIn.tsx",
            lineNumber: 418,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 430,
              columnNumber: 21
            }, this),
            "Sending OTP..."
          ] }, void 0, true, {
            fileName: "app/components/auth/SignIn.tsx",
            lineNumber: 429,
            columnNumber: 30
          }, this) : "Send OTP" }, void 0, false, {
            fileName: "app/components/auth/SignIn.tsx",
            lineNumber: 428,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center space-y-4 pt-4", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "md", className: "w-full", onClick: () => navigate("/login-email"), children: "Login with email instead" }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 437,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "md", className: "w-full", onClick: () => navigate("/reset-password"), children: "Forgot Password?" }, void 0, false, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 441,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-white/60 text-sm", children: [
              "Don't have an account?",
              " ",
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", className: "ml-2", onClick: () => navigate("/signup"), children: "Sign up" }, void 0, false, {
                fileName: "app/components/auth/SignIn.tsx",
                lineNumber: 447,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignIn.tsx",
              lineNumber: 445,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignIn.tsx",
            lineNumber: 436,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignIn.tsx",
          lineNumber: 375,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 359,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/SignIn.tsx",
        lineNumber: 358,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignIn.tsx",
      lineNumber: 346,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/SignIn.tsx",
    lineNumber: 320,
    columnNumber: 10
  }, this);
};
_s(SignIn, "m2i143yeuddUXPIjXVy8Ma/v5Ec=", false, function() {
  return [useNavigate, useLocation];
});
_c = SignIn;
var SignIn_default = SignIn;
var _c;
$RefreshReg$(_c, "SignIn");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/auth/SignInEmail.tsx
var import_react3 = __toESM(require_react(), 1);
var import_jsx_dev_runtime2 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\SignInEmail.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s2 = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\SignInEmail.tsx"
  );
  import.meta.hot.lastModified = "1760464886203.3677";
}
var SignInEmail = () => {
  _s2();
  const navigate = useNavigate();
  const [isVisible, setIsVisible] = (0, import_react3.useState)(false);
  const [showPassword, setShowPassword] = (0, import_react3.useState)(false);
  const [emailFormData, setEmailFormData] = (0, import_react3.useState)({
    email: "",
    password: "",
    keepLoggedIn: true
  });
  const [isLoading, setIsLoading] = (0, import_react3.useState)(false);
  const [error, setError] = (0, import_react3.useState)(null);
  (0, import_react3.useEffect)(() => {
    setIsVisible(true);
  }, []);
  const handleEmailInputChange = (e) => {
    const {
      name,
      value,
      type,
      checked
    } = e.target;
    setEmailFormData((prev) => ({
      ...prev,
      [name]: type === "checkbox" ? checked : value
    }));
    if (error)
      setError(null);
  };
  const handleEmailSubmit = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    setError(null);
    try {
      const response = await authAPI.login(emailFormData.email, emailFormData.password);
      if (response.status && response.token) {
        handleAuthSuccess(response);
        setTimeout(() => {
          window.location.href = "/home";
        }, 100);
      } else {
        setError(response.error || "Login failed. Please try again.");
      }
    } catch (err) {
      console.error("Login error:", err);
      setError(err instanceof Error ? err.message : "An unexpected error occurred. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 78,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 79,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignInEmail.tsx",
      lineNumber: 77,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 84,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 88,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 91,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 94,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignInEmail.tsx",
      lineNumber: 83,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "SIGN IN" }, void 0, false, {
          fileName: "app/components/auth/SignInEmail.tsx",
          lineNumber: 104,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: "Access your creative workspace" }, void 0, false, {
          fileName: "app/components/auth/SignInEmail.tsx",
          lineNumber: 107,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 103,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: `w-full max-w-md transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("h2", { className: "text-2xl font-semibold mb-8 text-white text-center uppercase tracking-wider", children: "Email Login" }, void 0, false, {
          fileName: "app/components/auth/SignInEmail.tsx",
          lineNumber: 115,
          columnNumber: 13
        }, this),
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/SignInEmail.tsx",
          lineNumber: 120,
          columnNumber: 23
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("form", { onSubmit: handleEmailSubmit, className: "space-y-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Email Address" }, void 0, false, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 128,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("input", { type: "email", name: "email", placeholder: "Enter your email", value: emailFormData.email, onChange: handleEmailInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 131,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignInEmail.tsx",
            lineNumber: 127,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Password" }, void 0, false, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 136,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "relative", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("input", { type: showPassword ? "text" : "password", name: "password", placeholder: "Enter your password", value: emailFormData.password, onChange: handleEmailInputChange, className: "w-full px-4 py-4 pr-12 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 140,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("button", { type: "button", onClick: () => setShowPassword(!showPassword), className: "absolute right-4 top-1/2 transform -translate-y-1/2 text-white/60 hover:text-white/80 transition-colors", disabled: isLoading, children: showPassword ? /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("svg", { className: "w-5 h-5", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 143,
                columnNumber: 25
              }, this) }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 142,
                columnNumber: 37
              }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("svg", { className: "w-5 h-5", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z" }, void 0, false, {
                  fileName: "app/components/auth/SignInEmail.tsx",
                  lineNumber: 145,
                  columnNumber: 25
                }, this),
                /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" }, void 0, false, {
                  fileName: "app/components/auth/SignInEmail.tsx",
                  lineNumber: 146,
                  columnNumber: 25
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 144,
                columnNumber: 32
              }, this) }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 141,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 139,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignInEmail.tsx",
            lineNumber: 135,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "flex items-center justify-between", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "flex items-center", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("input", { type: "checkbox", id: "keepLoggedInEmail", name: "keepLoggedIn", checked: emailFormData.keepLoggedIn, onChange: handleEmailInputChange, className: "w-5 h-5 text-orange-500 bg-white/10 border-white/20 rounded focus:ring-orange-400 focus:ring-2" }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 155,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("label", { htmlFor: "keepLoggedInEmail", className: "ml-3 text-sm text-white/80", children: "Keep me logged in" }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 156,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 154,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", onClick: () => navigate("/reset-password"), children: "Forgot Password?" }, void 0, false, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 160,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignInEmail.tsx",
            lineNumber: 153,
            columnNumber: 17
          }, this),
          "              ",
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(import_jsx_dev_runtime2.Fragment, { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 166,
              columnNumber: 21
            }, this),
            "Signing in..."
          ] }, void 0, true, {
            fileName: "app/components/auth/SignInEmail.tsx",
            lineNumber: 165,
            columnNumber: 30
          }, this) : "Sign In" }, void 0, false, {
            fileName: "app/components/auth/SignInEmail.tsx",
            lineNumber: 164,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "text-center space-y-4 pt-4", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "md", className: "w-full", onClick: () => navigate("/login"), children: "Login with phone instead" }, void 0, false, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 173,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "text-white/60 text-sm", children: [
              "Don't have an account?",
              " ",
              /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", className: "ml-2", onClick: () => navigate("/signup"), children: "Sign up" }, void 0, false, {
                fileName: "app/components/auth/SignInEmail.tsx",
                lineNumber: 179,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignInEmail.tsx",
              lineNumber: 177,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignInEmail.tsx",
            lineNumber: 172,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignInEmail.tsx",
          lineNumber: 125,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 114,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/SignInEmail.tsx",
        lineNumber: 113,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignInEmail.tsx",
      lineNumber: 101,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/SignInEmail.tsx",
    lineNumber: 75,
    columnNumber: 10
  }, this);
};
_s2(SignInEmail, "80dEUUlaQPrAlA1Os0o+k2CoNZo=", false, function() {
  return [useNavigate];
});
_c2 = SignInEmail;
var SignInEmail_default = SignInEmail;
var _c2;
$RefreshReg$(_c2, "SignInEmail");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/auth/SignupFirst.tsx
var import_react5 = __toESM(require_react(), 1);
var import_jsx_dev_runtime3 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\SignupFirst.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s3 = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\SignupFirst.tsx"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}
var SignupFirst = () => {
  _s3();
  const navigate = useNavigate();
  const [isVisible, setIsVisible] = (0, import_react5.useState)(false);
  const [selectedTier, setSelectedTier] = (0, import_react5.useState)(null);
  const [selectedAddOns, setSelectedAddOns] = (0, import_react5.useState)([]);
  (0, import_react5.useEffect)(() => {
    setIsVisible(true);
  }, []);
  const membershipTiers = [{
    name: "Guest",
    price: "$0",
    period: "month",
    points: "0 Pts",
    features: ["Just one day/one by member", "Zero guests"],
    buttonText: "Choose plan"
  }, {
    name: "Starving Artist",
    price: "$1149",
    period: "month",
    points: "10000 Pts",
    features: ["Book up 1 month in advance", "One guests"],
    buttonText: "Choose plan"
  }, {
    name: "Up and coming",
    price: "$1899",
    period: "month",
    points: "17500 Pts",
    features: ["Book up 1 month in advance", "Two guests"],
    buttonText: "Choose plan",
    isPopular: true
  }, {
    name: "Almost Famous",
    price: "$2500",
    period: "month",
    points: "2500 Pts",
    features: ["Book up 3 month in advance", "Four guests"],
    buttonText: "Choose plan"
  }];
  const addOnServices = [{
    id: "test-service",
    name: "Test Service",
    price: "$20.00",
    description: "Additional testing and quality assurance services"
  }, {
    id: "asdfds",
    name: "Premium Support",
    price: "$10.00",
    description: "24/7 priority support and consultation services"
  }];
  const handleAddOnToggle = (serviceId) => {
    setSelectedAddOns((prev) => prev.includes(serviceId) ? prev.filter((id) => id !== serviceId) : [...prev, serviceId]);
  };
  const handleTierSelect = (index) => {
    setSelectedTier(index);
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-30" }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 84,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/90 via-[#030303]/70 to-[#030303]/90" }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 85,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignupFirst.tsx",
      lineNumber: 83,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 90,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 94,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 97,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 100,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignupFirst.tsx",
      lineNumber: 89,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "relative z-10 min-h-screen px-4 lg:px-8 py-12", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `text-center mb-16 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "JOIN THE COMMUNITY" }, void 0, false, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 110,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light mb-8", children: "Choose your creative journey" }, void 0, false, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 113,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-white/60 text-sm space-y-1", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("p", { children: "\u2728 14 days relocation/year" }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 117,
            columnNumber: 13
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("p", { children: "\u{1F3AC} 14 days Studio time/year" }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 118,
            columnNumber: 13
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 116,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 109,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `max-w-7xl mx-auto mb-16 transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6", children: membershipTiers.map((tier, index) => /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `relative bg-white/10 backdrop-blur-lg border rounded-2xl p-6 shadow-2xl transition-all duration-300 cursor-pointer transform hover:scale-105 ${tier.isPopular ? "border-orange-400 ring-2 ring-orange-400/50" : "border-white/20 hover:border-orange-400/50"} ${selectedTier === index ? "ring-2 ring-orange-400 scale-105" : ""}`, onClick: () => handleTierSelect(index), children: [
        tier.isPopular && /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute -top-3 left-1/2 transform -translate-x-1/2", children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "bg-gradient-to-r from-orange-500 to-orange-600 text-white text-xs px-4 py-1 rounded-full uppercase tracking-wider font-semibold", children: "Most Popular" }, void 0, false, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 128,
          columnNumber: 21
        }, this) }, void 0, false, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 127,
          columnNumber: 36
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-center", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("h3", { className: "text-white text-xl font-bold mb-4 uppercase tracking-wider", children: tier.name }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 136,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "mb-6", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-4xl font-bold text-white mb-1", children: tier.price }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 142,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-white/60 text-sm", children: [
              "per ",
              tier.period
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 145,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-orange-400 font-semibold mt-2", children: tier.points }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 148,
              columnNumber: 21
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 141,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("ul", { className: "text-white/80 text-sm space-y-3 mb-8", children: tier.features.map((feature, featureIndex) => /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("li", { className: "flex items-start", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("svg", { className: "w-4 h-4 text-orange-400 mr-3 mt-0.5 flex-shrink-0", fill: "currentColor", viewBox: "0 0 20 20", children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("path", { fillRule: "evenodd", d: "M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z", clipRule: "evenodd" }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 157,
              columnNumber: 27
            }, this) }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 156,
              columnNumber: 25
            }, this),
            feature
          ] }, featureIndex, true, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 155,
            columnNumber: 67
          }, this)) }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 154,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)(Button, { variant: selectedTier === index ? "fill-black" : tier.isPopular ? "fill-white" : "outline-white", size: "md", className: "w-full", children: selectedTier === index ? /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("span", { className: "flex items-center justify-center", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("svg", { className: "w-5 h-5 mr-2", fill: "currentColor", viewBox: "0 0 20 20", children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("path", { fillRule: "evenodd", d: "M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z", clipRule: "evenodd" }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 167,
              columnNumber: 27
            }, this) }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 166,
              columnNumber: 25
            }, this),
            "Selected"
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 165,
            columnNumber: 47
          }, this) : tier.buttonText }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 164,
            columnNumber: 19
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 134,
          columnNumber: 17
        }, this)
      ] }, index, true, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 125,
        columnNumber: 51
      }, this)) }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 124,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 123,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `max-w-4xl mx-auto mb-16 transform transition-all duration-1000 delay-500 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-center mb-8", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("h2", { className: "text-3xl lg:text-4xl font-bold text-white uppercase tracking-tight mb-4", children: "Select Add-on Services" }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 180,
            columnNumber: 13
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("p", { className: "text-white/60 text-sm", children: "Enhance your membership with optional premium services" }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 183,
            columnNumber: 13
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 179,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: addOnServices.map((service) => /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `bg-white/10 backdrop-blur-lg border rounded-2xl p-6 shadow-2xl transition-all duration-300 cursor-pointer transform hover:scale-105 ${selectedAddOns.includes(service.id) ? "border-orange-400 ring-2 ring-orange-400/50 bg-orange-500/10" : "border-white/20 hover:border-orange-400/50"}`, onClick: () => handleAddOnToggle(service.id), children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex items-start justify-between mb-4", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex-1", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("h3", { className: "text-white text-xl font-bold mb-2 uppercase tracking-wider", children: service.name }, void 0, false, {
                fileName: "app/components/auth/SignupFirst.tsx",
                lineNumber: 192,
                columnNumber: 21
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("p", { className: "text-white/70 text-sm mb-4", children: service.description }, void 0, false, {
                fileName: "app/components/auth/SignupFirst.tsx",
                lineNumber: 195,
                columnNumber: 21
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 191,
              columnNumber: 19
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "ml-4", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-2xl font-bold text-orange-400", children: service.price }, void 0, false, {
                fileName: "app/components/auth/SignupFirst.tsx",
                lineNumber: 200,
                columnNumber: 21
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-white/60 text-xs text-right", children: "per month" }, void 0, false, {
                fileName: "app/components/auth/SignupFirst.tsx",
                lineNumber: 203,
                columnNumber: 21
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 199,
              columnNumber: 19
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 190,
            columnNumber: 17
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex items-center justify-between", children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex items-center", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `w-5 h-5 rounded border-2 transition-all duration-200 ${selectedAddOns.includes(service.id) ? "border-orange-400 bg-orange-400" : "border-white/40"}`, children: selectedAddOns.includes(service.id) && /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("svg", { className: "w-3 h-3 text-white ml-0.5 mt-0.5", fill: "currentColor", viewBox: "0 0 20 20", children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("path", { fillRule: "evenodd", d: "M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z", clipRule: "evenodd" }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 213,
              columnNumber: 27
            }, this) }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 212,
              columnNumber: 63
            }, this) }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 211,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("span", { className: "text-white/80 text-sm ml-3", children: selectedAddOns.includes(service.id) ? "Selected" : "Add to plan" }, void 0, false, {
              fileName: "app/components/auth/SignupFirst.tsx",
              lineNumber: 216,
              columnNumber: 21
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 210,
            columnNumber: 19
          }, this) }, void 0, false, {
            fileName: "app/components/auth/SignupFirst.tsx",
            lineNumber: 209,
            columnNumber: 17
          }, this)
        ] }, service.id, true, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 189,
          columnNumber: 43
        }, this)) }, void 0, false, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 188,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 178,
        columnNumber: 9
      }, this),
      selectedTier !== null && /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `text-center mb-16 transform transition-all duration-1000 delay-700 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)(Button, { variant: "fill-white", size: "lg", arrowRight: true, onClick: () => {
        const selectedTierData = membershipTiers[selectedTier];
        navigate("/signup-details", {
          state: {
            selectedTier: selectedTierData,
            selectedAddOns: selectedAddOns.map((id) => addOnServices.find((service) => service.id === id)).filter(Boolean)
          }
        });
      }, children: "Subscribe" }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 227,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 226,
        columnNumber: 35
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: `text-center mt-16 transform transition-all duration-1000 delay-500 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "text-white/60 text-sm mb-4", children: [
        "Already have an account?",
        " ",
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)(Button, { variant: "outline-white", size: "sm", className: "ml-2", onClick: () => navigate("/login"), children: "Sign in" }, void 0, false, {
          fileName: "app/components/auth/SignupFirst.tsx",
          lineNumber: 244,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 242,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/SignupFirst.tsx",
        lineNumber: 241,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignupFirst.tsx",
      lineNumber: 107,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/SignupFirst.tsx",
    lineNumber: 81,
    columnNumber: 10
  }, this);
};
_s3(SignupFirst, "gJz+DDSbn7vmWlvAflMDswe9y2g=", false, function() {
  return [useNavigate];
});
_c3 = SignupFirst;
var SignupFirst_default = SignupFirst;
var _c3;
$RefreshReg$(_c3, "SignupFirst");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/auth/SignupSecond.tsx
var import_react7 = __toESM(require_react(), 1);
var import_jsx_dev_runtime4 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\SignupSecond.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s4 = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\SignupSecond.tsx"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}
var SignupSecond = () => {
  _s4();
  const navigate = useNavigate();
  const location = useLocation();
  const [searchParams] = useSearchParams();
  const [isVisible, setIsVisible] = (0, import_react7.useState)(false);
  const [isLoading, setIsLoading] = (0, import_react7.useState)(false);
  const [error, setError] = (0, import_react7.useState)(null);
  const selectedTierData = location.state?.selectedTier;
  const selectedAddOnsData = location.state?.selectedAddOns || [];
  const selectedPlan = selectedTierData?.name || searchParams.get("plan") || "Guest";
  const selectedPrice = selectedTierData?.price || searchParams.get("price") || "$0";
  const [formData, setFormData] = (0, import_react7.useState)({
    firstName: "",
    lastName: "",
    email: "",
    mobileNumber: ""
  });
  const [selectedCountry, setSelectedCountry] = (0, import_react7.useState)({
    code: "+1",
    country: "United States",
    flag: "\u{1F1FA}\u{1F1F8}"
  });
  const [isDropdownOpen, setIsDropdownOpen] = (0, import_react7.useState)(false);
  const countryCodes = [{
    code: "+61",
    country: "Australia",
    flag: "\u{1F1E6}\u{1F1FA}"
  }, {
    code: "+43",
    country: "Austria",
    flag: "\u{1F1E6}\u{1F1F9}"
  }, {
    code: "+54",
    country: "Argentina",
    flag: "\u{1F1E6}\u{1F1F7}"
  }, {
    code: "+32",
    country: "Belgium",
    flag: "\u{1F1E7}\u{1F1EA}"
  }, {
    code: "+359",
    country: "Bulgaria",
    flag: "\u{1F1E7}\u{1F1EC}"
  }, {
    code: "+55",
    country: "Brazil",
    flag: "\u{1F1E7}\u{1F1F7}"
  }, {
    code: "+56",
    country: "Chile",
    flag: "\u{1F1E8}\u{1F1F1}"
  }, {
    code: "+86",
    country: "China",
    flag: "\u{1F1E8}\u{1F1F3}"
  }, {
    code: "+420",
    country: "Czech Republic",
    flag: "\u{1F1E8}\u{1F1FF}"
  }, {
    code: "+385",
    country: "Croatia",
    flag: "\u{1F1ED}\u{1F1F7}"
  }, {
    code: "+20",
    country: "Egypt",
    flag: "\u{1F1EA}\u{1F1EC}"
  }, {
    code: "+33",
    country: "France",
    flag: "\u{1F1EB}\u{1F1F7}"
  }, {
    code: "+358",
    country: "Finland",
    flag: "\u{1F1EB}\u{1F1EE}"
  }, {
    code: "+30",
    country: "Greece",
    flag: "\u{1F1EC}\u{1F1F7}"
  }, {
    code: "+49",
    country: "Germany",
    flag: "\u{1F1E9}\u{1F1EA}"
  }, {
    code: "+353",
    country: "Ireland",
    flag: "\u{1F1EE}\u{1F1EA}"
  }, {
    code: "+91",
    country: "India",
    flag: "\u{1F1EE}\u{1F1F3}"
  }, {
    code: "+972",
    country: "Israel",
    flag: "\u{1F1EE}\u{1F1F1}"
  }, {
    code: "+62",
    country: "Indonesia",
    flag: "\u{1F1EE}\u{1F1E9}"
  }, {
    code: "+81",
    country: "Japan",
    flag: "\u{1F1EF}\u{1F1F5}"
  }, {
    code: "+254",
    country: "Kenya",
    flag: "\u{1F1F0}\u{1F1EA}"
  }, {
    code: "+82",
    country: "South Korea",
    flag: "\u{1F1F0}\u{1F1F7}"
  }, {
    code: "+36",
    country: "Hungary",
    flag: "\u{1F1ED}\u{1F1FA}"
  }, {
    code: "+385",
    country: "Croatia",
    flag: "\u{1F1ED}\u{1F1F7}"
  }, {
    code: "+39",
    country: "Italy",
    flag: "\u{1F1EE}\u{1F1F9}"
  }, {
    code: "+353",
    country: "Ireland",
    flag: "\u{1F1EE}\u{1F1EA}"
  }, {
    code: "+234",
    country: "Nigeria",
    flag: "\u{1F1F3}\u{1F1EC}"
  }, {
    code: "+31",
    country: "Netherlands",
    flag: "\u{1F1F3}\u{1F1F1}"
  }, {
    code: "+64",
    country: "New Zealand",
    flag: "\u{1F1F3}\u{1F1FF}"
  }, {
    code: "+351",
    country: "Portugal",
    flag: "\u{1F1F5}\u{1F1F9}"
  }, {
    code: "+48",
    country: "Poland",
    flag: "\u{1F1F5}\u{1F1F1}"
  }, {
    code: "+51",
    country: "Peru",
    flag: "\u{1F1F5}\u{1F1EA}"
  }, {
    code: "+63",
    country: "Philippines",
    flag: "\u{1F1F5}\u{1F1ED}"
  }, {
    code: "+966",
    country: "Saudi Arabia",
    flag: "\u{1F1F8}\u{1F1E6}"
  }, {
    code: "+65",
    country: "Singapore",
    flag: "\u{1F1F8}\u{1F1EC}"
  }, {
    code: "+46",
    country: "Sweden",
    flag: "\u{1F1F8}\u{1F1EA}"
  }, {
    code: "+41",
    country: "Switzerland",
    flag: "\u{1F1E8}\u{1F1ED}"
  }, {
    code: "+90",
    country: "Turkey",
    flag: "\u{1F1F9}\u{1F1F7}"
  }, {
    code: "+66",
    country: "Thailand",
    flag: "\u{1F1F9}\u{1F1ED}"
  }, {
    code: "+27",
    country: "South Africa",
    flag: "\u{1F1FF}\u{1F1E6}"
  }, {
    code: "+44",
    country: "United Kingdom",
    flag: "\u{1F1EC}\u{1F1E7}"
  }, {
    code: "+1",
    country: "United States",
    flag: "\u{1F1FA}\u{1F1F8}"
  }, {
    code: "+971",
    country: "UAE",
    flag: "\u{1F1E6}\u{1F1EA}"
  }, {
    code: "+380",
    country: "Ukraine",
    flag: "\u{1F1FA}\u{1F1E6}"
  }, {
    code: "+34",
    country: "Spain",
    flag: "\u{1F1EA}\u{1F1F8}"
  }, {
    code: "+91",
    country: "India",
    flag: "\u{1F1EE}\u{1F1F3}"
  }, {
    code: "+84",
    country: "Vietnam",
    flag: "\u{1F1FB}\u{1F1F3}"
  }, {
    code: "+58",
    country: "Venezuela",
    flag: "\u{1F1FB}\u{1F1EA}"
  }, {
    code: "+52",
    country: "Mexico",
    flag: "\u{1F1F2}\u{1F1FD}"
  }];
  (0, import_react7.useEffect)(() => {
    setIsVisible(true);
    if (!selectedPlan || selectedPlan === "Guest" && !location.state?.selectedTier) {
    }
  }, [selectedPlan, location.state]);
  (0, import_react7.useEffect)(() => {
    const handleKeyPress = (e) => {
      if (isDropdownOpen) {
        const key = e.key.toLowerCase();
        const matchingCountry = countryCodes.find((country) => country.country.toLowerCase().startsWith(key));
        if (matchingCountry) {
          const countryElement = document.querySelector(`[data-country="${matchingCountry.country}"]`);
          if (countryElement) {
            countryElement.scrollIntoView({
              block: "nearest"
            });
            countryElement.focus();
          }
        }
      }
    };
    if (isDropdownOpen) {
      document.addEventListener("keydown", handleKeyPress);
    }
    return () => {
      document.removeEventListener("keydown", handleKeyPress);
    };
  }, [isDropdownOpen]);
  const handleInputChange = (e) => {
    const {
      name,
      value
    } = e.target;
    setFormData((prev) => ({
      ...prev,
      [name]: value
    }));
    if (error)
      setError(null);
  };
  const handleCountrySelect = (country) => {
    setSelectedCountry(country);
    setIsDropdownOpen(false);
    if (error)
      setError(null);
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    setError(null);
    try {
      const fullPhoneNumber = `${selectedCountry.code}${formData.mobileNumber}`;
      const otpResponse = await authAPI.sendOTP(fullPhoneNumber);
      if (otpResponse.status) {
        navigate("/otp-verification", {
          state: {
            phoneNumber: fullPhoneNumber,
            requestType: "signup",
            signupData: {
              fname: formData.firstName,
              lname: formData.lastName,
              email: formData.email,
              mobile_number: fullPhoneNumber,
              plan: selectedPlan,
              addon_services: selectedAddOnsData.map((addon) => addon.id).join(",")
            }
          }
        });
      } else {
        setError(otpResponse.error || "Failed to send OTP. Please try again.");
      }
    } catch (error2) {
      console.error("Signup error:", error2);
      setError(error2 instanceof Error ? error2.message : "An unexpected error occurred. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 336,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 337,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignupSecond.tsx",
      lineNumber: 335,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 342,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 346,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 349,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 352,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignupSecond.tsx",
      lineNumber: 341,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0 py-12", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "COMPLETE SIGNUP" }, void 0, false, {
          fileName: "app/components/auth/SignupSecond.tsx",
          lineNumber: 362,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: "You're one step away from joining the community" }, void 0, false, {
          fileName: "app/components/auth/SignupSecond.tsx",
          lineNumber: 365,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 361,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: `w-full max-w-lg transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "mb-8 text-center", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "inline-flex items-center bg-orange-500/20 border border-orange-400/30 rounded-xl px-6 py-3 mb-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "text-orange-400 text-sm font-semibold uppercase tracking-wider", children: [
            "Selected Plan: ",
            selectedPlan
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 376,
            columnNumber: 17
          }, this) }, void 0, false, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 375,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "text-white/80 text-lg font-medium", children: [
            selectedPrice,
            "/month"
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 380,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(Link, { to: "/signup", className: "text-orange-400 hover:text-orange-300 text-sm font-medium transition-colors mt-2 inline-block", children: "Change plan \u2192" }, void 0, false, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 383,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignupSecond.tsx",
          lineNumber: 374,
          columnNumber: 13
        }, this),
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/SignupSecond.tsx",
          lineNumber: 389,
          columnNumber: 23
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("form", { onSubmit: handleSubmit, className: "space-y-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "grid grid-cols-2 gap-4", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "space-y-2", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "First Name" }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 398,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("input", { type: "text", name: "firstName", placeholder: "John", value: formData.firstName, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 401,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 397,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "space-y-2", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Last Name" }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 406,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("input", { type: "text", name: "lastName", placeholder: "Doe", value: formData.lastName, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 409,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 405,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 395,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Email Address" }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 415,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("input", { type: "email", name: "email", placeholder: "john.doe@example.com", value: formData.email, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 418,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 414,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Mobile Number" }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 423,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "flex relative", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "relative", children: [
                /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("button", { type: "button", onClick: () => setIsDropdownOpen(!isDropdownOpen), disabled: isLoading, className: "flex items-center px-4 py-4 bg-white/10 border border-white/20 border-r-0 rounded-l-xl hover:bg-white/20 focus:outline-none focus:ring-2 focus:ring-orange-400 backdrop-blur-sm transition-all disabled:opacity-50", children: [
                  /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("span", { className: "text-lg mr-2", children: selectedCountry.flag }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 430,
                    columnNumber: 23
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("span", { className: "text-sm text-white/80 mr-1", children: selectedCountry.code }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 433,
                    columnNumber: 23
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("svg", { className: "w-4 h-4 text-white/60", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M19 9l-7 7-7-7" }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 437,
                    columnNumber: 25
                  }, this) }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 436,
                    columnNumber: 23
                  }, this)
                ] }, void 0, true, {
                  fileName: "app/components/auth/SignupSecond.tsx",
                  lineNumber: 429,
                  columnNumber: 21
                }, this),
                isDropdownOpen && /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "absolute z-20 top-full left-0 w-64 bg-black border border-white/20 rounded-xl shadow-2xl max-h-60 overflow-y-auto", children: countryCodes.map((country, index) => /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("button", { type: "button", onClick: () => handleCountrySelect(country), "data-country": country.country, className: "w-full flex items-center px-4 py-3 text-left hover:bg-white/20 focus:outline-none focus:bg-white/20 transition-colors", children: [
                  /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("span", { className: "text-lg mr-3", children: country.flag }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 444,
                    columnNumber: 29
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("span", { className: "text-sm text-white/80 mr-2", children: country.code }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 445,
                    columnNumber: 29
                  }, this),
                  /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("span", { className: "text-sm text-white truncate", children: country.country }, void 0, false, {
                    fileName: "app/components/auth/SignupSecond.tsx",
                    lineNumber: 448,
                    columnNumber: 29
                  }, this)
                ] }, index, true, {
                  fileName: "app/components/auth/SignupSecond.tsx",
                  lineNumber: 443,
                  columnNumber: 63
                }, this)) }, void 0, false, {
                  fileName: "app/components/auth/SignupSecond.tsx",
                  lineNumber: 442,
                  columnNumber: 40
                }, this)
              ] }, void 0, true, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 428,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("input", { type: "tel", name: "mobileNumber", placeholder: "Enter your mobile number", value: formData.mobileNumber, onChange: handleInputChange, className: "flex-1 px-4 py-4 bg-white/10 border border-white/20 rounded-r-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 455,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 426,
              columnNumber: 17
            }, this),
            isDropdownOpen && /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "fixed inset-0 z-10", onClick: () => setIsDropdownOpen(false) }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 459,
              columnNumber: 36
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 422,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "bg-white/5 rounded-xl p-4 border border-white/10", children: /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "text-xs text-white/70 space-y-2", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("p", { children: [
              "By clicking 'Complete Signup', you agree to our",
              " ",
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("a", { href: "#", className: "text-orange-400 hover:text-orange-300 transition-colors", children: "Terms of Service" }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 467,
                columnNumber: 21
              }, this),
              " ",
              "and",
              " ",
              /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("a", { href: "#", className: "text-orange-400 hover:text-orange-300 transition-colors", children: "Privacy Policy" }, void 0, false, {
                fileName: "app/components/auth/SignupSecond.tsx",
                lineNumber: 471,
                columnNumber: 21
              }, this),
              "."
            ] }, void 0, true, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 465,
              columnNumber: 19
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("p", { children: "We'll send SMS verification to your mobile number." }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 476,
              columnNumber: 19
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 464,
            columnNumber: 17
          }, this) }, void 0, false, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 463,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(import_jsx_dev_runtime4.Fragment, { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 483,
              columnNumber: 21
            }, this),
            "Creating Account..."
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 482,
            columnNumber: 30
          }, this) : "Complete Signup" }, void 0, false, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 481,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "text-center text-white/60 text-sm pt-4", children: [
            "Already have an account?",
            " ",
            /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", className: "ml-2", onClick: () => navigate("/login"), children: "Sign in" }, void 0, false, {
              fileName: "app/components/auth/SignupSecond.tsx",
              lineNumber: 491,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/SignupSecond.tsx",
            lineNumber: 489,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/SignupSecond.tsx",
          lineNumber: 393,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 372,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/SignupSecond.tsx",
        lineNumber: 371,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/SignupSecond.tsx",
      lineNumber: 359,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/SignupSecond.tsx",
    lineNumber: 333,
    columnNumber: 10
  }, this);
};
_s4(SignupSecond, "cMl3jJSbisBZbL5s/Zuaf3IOFTQ=", false, function() {
  return [useNavigate, useLocation, useSearchParams];
});
_c4 = SignupSecond;
var SignupSecond_default = SignupSecond;
var _c4;
$RefreshReg$(_c4, "SignupSecond");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/auth/AuthStatus.tsx
var import_react9 = __toESM(require_react(), 1);
var import_jsx_dev_runtime5 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\AuthStatus.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s5 = $RefreshSig$();
var _s22 = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\AuthStatus.tsx"
  );
  import.meta.hot.lastModified = "1759744975079.7283";
}
var AuthStatus = ({
  className = ""
}) => {
  _s5();
  const navigate = useNavigate();
  const [user, setUser] = import_react9.default.useState(null);
  const [isLoggedIn, setIsLoggedIn] = import_react9.default.useState(false);
  import_react9.default.useEffect(() => {
    const checkAuthStatus = () => {
      const authenticated = isAuthenticated();
      setIsLoggedIn(authenticated);
      if (authenticated) {
        const userData = getUserData();
        setUser(userData);
      }
    };
    checkAuthStatus();
    const interval = setInterval(checkAuthStatus, 5e3);
    return () => clearInterval(interval);
  }, []);
  const handleLogoutClick = async () => {
    try {
      await handleLogout();
      setIsLoggedIn(false);
      setUser(null);
      navigate("/login");
    } catch (error) {
      console.error("Logout error:", error);
    }
  };
  if (!isLoggedIn) {
    return /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("div", { className: `flex gap-2 ${className}`, children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("button", { onClick: () => navigate("/login"), className: "px-4 py-2 text-sm text-gray-600 hover:text-gray-800", children: "Login" }, void 0, false, {
        fileName: "app/components/auth/AuthStatus.tsx",
        lineNumber: 60,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("button", { onClick: () => navigate("/signup"), className: "px-4 py-2 text-sm bg-orange-400 text-white rounded-md hover:bg-orange-500", children: "Sign Up" }, void 0, false, {
        fileName: "app/components/auth/AuthStatus.tsx",
        lineNumber: 63,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/AuthStatus.tsx",
      lineNumber: 59,
      columnNumber: 12
    }, this);
  }
  return /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("div", { className: `flex items-center gap-3 ${className}`, children: [
    user && /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("span", { className: "text-sm text-gray-600", children: [
      "Welcome, ",
      user.fname,
      "!"
    ] }, void 0, true, {
      fileName: "app/components/auth/AuthStatus.tsx",
      lineNumber: 69,
      columnNumber: 16
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("button", { onClick: handleLogoutClick, className: "px-4 py-2 text-sm text-red-600 hover:text-red-800", children: "Logout" }, void 0, false, {
      fileName: "app/components/auth/AuthStatus.tsx",
      lineNumber: 72,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/AuthStatus.tsx",
    lineNumber: 68,
    columnNumber: 10
  }, this);
};
_s5(AuthStatus, "+KXJLcnnK+yF1iGLxELrcBH1iS0=", false, function() {
  return [useNavigate];
});
_c5 = AuthStatus;
var ProtectedRoute = ({
  children,
  fallback
}) => {
  _s22();
  const navigate = useNavigate();
  const [isLoggedIn, setIsLoggedIn] = import_react9.default.useState(null);
  import_react9.default.useEffect(() => {
    const authenticated = isAuthenticated();
    setIsLoggedIn(authenticated);
    if (!authenticated) {
      navigate("/login");
    }
  }, [navigate]);
  if (isLoggedIn === null) {
    return /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("div", { className: "flex items-center justify-center min-h-screen", children: /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)("div", { className: "animate-spin rounded-full h-8 w-8 border-b-2 border-orange-500" }, void 0, false, {
      fileName: "app/components/auth/AuthStatus.tsx",
      lineNumber: 97,
      columnNumber: 9
    }, this) }, void 0, false, {
      fileName: "app/components/auth/AuthStatus.tsx",
      lineNumber: 96,
      columnNumber: 12
    }, this);
  }
  if (!isLoggedIn) {
    return fallback || null;
  }
  return /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)(import_jsx_dev_runtime5.Fragment, { children }, void 0, false, {
    fileName: "app/components/auth/AuthStatus.tsx",
    lineNumber: 103,
    columnNumber: 10
  }, this);
};
_s22(ProtectedRoute, "jrr/u2Vz6WayCT5/HyGRTc+KSe8=", false, function() {
  return [useNavigate];
});
_c22 = ProtectedRoute;
var _c5;
var _c22;
$RefreshReg$(_c5, "AuthStatus");
$RefreshReg$(_c22, "ProtectedRoute");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/auth/index.ts
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\index.ts"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}

export {
  SignIn_default,
  SignInEmail_default,
  SignupFirst_default,
  SignupSecond_default
};
//# sourceMappingURL=build/_shared/chunk-KLQMAT3U.js.map
