import {
  Link
} from "./build/_shared/chunk-5EQN7Y3V.js";
import "./build/_shared/chunk-2Y2CKKWM.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import "./build/_shared/chunk-ZFLKADV3.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/routes/events.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\routes\\\\events.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\routes\\events.tsx"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}
var meta = () => {
  return [{
    title: "Events - Nomadics Studios"
  }, {
    name: "description",
    content: "Discover and join exciting events at Nomadics Studios. Connect with creative professionals and explore new opportunities."
  }];
};
var locations = ["All Locations", "Bali, Indonesia", "New York, Brooklyn", "Bangkok, Thailand", "Mexico", "Costa Rica", "Mumbai"];
var staticImage = "/event.png";
var eventsData = [{
  id: 1,
  date: "23",
  month: "JUL",
  time: "11:50 PM",
  name: "Test event",
  image: staticImage,
  slug: "test-event"
}, {
  id: 2,
  date: "28",
  month: "JUN",
  time: "12:30 AM",
  name: "Music event",
  image: "/bw (2).png",
  slug: "music-event"
}, {
  id: 3,
  date: "15",
  month: "AUG",
  time: "06:00 PM",
  name: "Art Workshop",
  image: "/bw (3).png",
  slug: "art-workshop"
}, {
  id: 4,
  date: "10",
  month: "SEP",
  time: "02:30 PM",
  name: "Photography Session",
  image: "/bw (4).png",
  slug: "photography-session"
}, {
  id: 5,
  date: "22",
  month: "SEP",
  time: "07:45 PM",
  name: "Film Screening",
  image: "/bw (5).png",
  slug: "film-screening"
}, {
  id: 6,
  date: "05",
  month: "OCT",
  time: "04:15 PM",
  name: "Creative Meetup",
  image: staticImage,
  slug: "creative-meetup"
}, {
  id: 7,
  date: "18",
  month: "OCT",
  time: "08:00 PM",
  name: "Design Conference",
  image: "/bw (1).png",
  slug: "design-conference"
}, {
  id: 8,
  date: "30",
  month: "OCT",
  time: "05:30 PM",
  name: "Studio Tour",
  image: "/bw (2).png",
  slug: "studio-tour"
}, {
  id: 9,
  date: "12",
  month: "NOV",
  time: "01:00 PM",
  name: "Networking Event",
  image: "/bw (3).png",
  slug: "networking-event"
}];
function Events() {
  _s();
  const [selectedLocation, setSelectedLocation] = (0, import_react.useState)("All Locations");
  const eventRows = Array(3).fill(0).map((_, rowIdx) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-8", children: Array(3).fill(0).map((_2, colIdx) => {
    const eventIndex = rowIdx * 3 + colIdx;
    const event = eventsData[eventIndex];
    return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Link, { to: `/events-details/${event.slug}`, className: "group block bg-white rounded-lg shadow-sm overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02] cursor-pointer", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative overflow-hidden", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: event.image, alt: event.name, className: "w-full h-40 object-cover transition-transform duration-500 group-hover:scale-110", onError: (e) => {
          e.currentTarget.src = staticImage;
        } }, void 0, false, {
          fileName: "app/routes/events.tsx",
          lineNumber: 119,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-black/0 group-hover:bg-black/20 transition-all duration-300" }, void 0, false, {
          fileName: "app/routes/events.tsx",
          lineNumber: 122,
          columnNumber: 19
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/events.tsx",
        lineNumber: 118,
        columnNumber: 17
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center gap-4 px-4 py-3 group-hover:bg-gray-50 transition-colors duration-300", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center min-w-[40px]", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-lg font-bold text-black group-hover:text-black/80 transition-colors", children: event.date }, void 0, false, {
            fileName: "app/routes/events.tsx",
            lineNumber: 126,
            columnNumber: 21
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-xs text-gray-500 group-hover:text-gray-600 transition-colors", children: event.month }, void 0, false, {
            fileName: "app/routes/events.tsx",
            lineNumber: 129,
            columnNumber: 21
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/events.tsx",
          lineNumber: 125,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex-1", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "font-semibold text-black group-hover:text-black/90 transition-colors", children: event.name }, void 0, false, {
            fileName: "app/routes/events.tsx",
            lineNumber: 134,
            columnNumber: 21
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-xs text-gray-500 group-hover:text-gray-600 transition-colors", children: event.time }, void 0, false, {
            fileName: "app/routes/events.tsx",
            lineNumber: 137,
            columnNumber: 21
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/events.tsx",
          lineNumber: 133,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "opacity-0 group-hover:opacity-100 transition-opacity duration-300", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-5 h-5 text-gray-400", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M9 5l7 7-7 7" }, void 0, false, {
          fileName: "app/routes/events.tsx",
          lineNumber: 143,
          columnNumber: 23
        }, this) }, void 0, false, {
          fileName: "app/routes/events.tsx",
          lineNumber: 142,
          columnNumber: 21
        }, this) }, void 0, false, {
          fileName: "app/routes/events.tsx",
          lineNumber: 141,
          columnNumber: 19
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/events.tsx",
        lineNumber: 124,
        columnNumber: 17
      }, this)
    ] }, colIdx, true, {
      fileName: "app/routes/events.tsx",
      lineNumber: 117,
      columnNumber: 14
    }, this);
  }) }, rowIdx, false, {
    fileName: "app/routes/events.tsx",
    lineNumber: 113,
    columnNumber: 57
  }, this));
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("main", { className: "bg-white min-h-screen pb-24", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "max-w-7xl mx-auto pt-8 px-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "block text-sm font-medium text-gray-700 mb-2", children: "LOCATION" }, void 0, false, {
        fileName: "app/routes/events.tsx",
        lineNumber: 154,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex flex-wrap gap-3", children: locations.map((loc) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { className: `px-5 py-2 rounded-full border font-medium text-sm transition ${selectedLocation === loc ? "bg-black text-white" : "bg-white text-black border-black hover:bg-gray-100"}`, onClick: () => setSelectedLocation(loc), children: loc }, loc, false, {
        fileName: "app/routes/events.tsx",
        lineNumber: 158,
        columnNumber: 35
      }, this)) }, void 0, false, {
        fileName: "app/routes/events.tsx",
        lineNumber: 157,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/events.tsx",
      lineNumber: 153,
      columnNumber: 9
    }, this) }, void 0, false, {
      fileName: "app/routes/events.tsx",
      lineNumber: 152,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "max-w-7xl mx-auto px-4", children: eventRows }, void 0, false, {
      fileName: "app/routes/events.tsx",
      lineNumber: 166,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/routes/events.tsx",
    lineNumber: 150,
    columnNumber: 10
  }, this);
}
_s(Events, "acywcNSK/NNUZsxds9jv/KV7Xyc=");
_c = Events;
var _c;
$RefreshReg$(_c, "Events");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;
export {
  Events as default,
  meta
};
//# sourceMappingURL=build/routes/events-OGWUYPIQ.js.map
