# Nomadics Web Application

A modern web platform for creative studio bookings and community management.

## Documentation

- 📚 **[Developer Guide](./DEVELOPER_GUIDE.md)** - Complete development documentation
- 🚀 **[Quick Start](./QUICK_START.md)** - Get up and running in 5 minutes

## Setup

```bash
bun install
bun run dev
```

Open [http://localhost:5173](http://localhost:5173)

## Project Structure

```
app/
├── routes/        # Pages
├── components/    # UI Components  
├── config/        # Data configuration
└── lib/          # Utilities
```

## Tech Stack

- **Remix** - React framework
- **TypeScript** - Type safety
- **Tailwind CSS** - Styling
- **Vite** - Build tool

## Available Scripts

- `bun run dev` - Start development server
- `bun run build` - Build for production  
- `bun run start` - Run production build
- `bun run typecheck` - TypeScript checking

## Routes

- `/` - Homepage
- `/locations/[location]` - Location pages (bali, bangkok, mexico, etc.)
- `/studios/[type]` - Studio type pages (music, photo, video)
- `/book-studio/[studioId]` - Studio booking pages
- `/people` - Team members
- `/events` - Events listing
- `/equipment` - Equipment catalog

## Development Workflow

1. All data is currently in `/app/config/` files
2. Components receive data via props
3. Routes load data and pass to components
4. Follow existing patterns for consistency

See [Developer Guide](./DEVELOPER_GUIDE.md) for detailed information.
