import { useState } from "react";
import { PersonCard } from "~/components/shared/PeopleSection/components/PersonCard";
import { PeopleToolbar } from "~/components/shared/PeopleSection/components/PeopleToolbar";

interface PersonData {
  id: string;
  photo: string;
  name: string;
  surname: string;
  role: string;
  location: string;
  href: string;
}

interface FilterOptions {
  locations: string[];
  roles: string[];
}

interface CrewData {
  title: string;
  people: PersonData[];
  filterOptions: FilterOptions;
}

interface CrewSectionProps {
  data: CrewData;
}

export function CrewSection({ data }: CrewSectionProps) {
  const [filters, setFilters] = useState({
    location: "",
    role: "",
  });

  const filteredPeople = data.people.filter((person) => {
    const locationMatch =
      !filters.location || person.location === filters.location;
    const roleMatch = !filters.role || person.role === filters.role;
    return locationMatch && roleMatch;
  });

  const handleFilterChange = (newFilters: typeof filters) => {
    setFilters(newFilters);
  };

  return (
    <div className="mt-8 space-y-8">
      <h2 className="text-heading-3 !text-neutral-900">{data.title}</h2>

      {/* Toolbar - Responsive */}
      <div className="mb-4">
        <div className="lg:block">
          <PeopleToolbar
            filters={filters}
            filterOptions={data.filterOptions}
            onChange={handleFilterChange}
          />
        </div>
      </div>

      {/* People Grid */}
      <div className="grid grid-cols-2 lg:grid-cols-4 gap-3 lg:gap-6">
        {filteredPeople.map((person) => (
          <PersonCard key={person.id} {...person} />
        ))}
      </div>
    </div>
  );
}