import {
  PhotoGallery,
  type PhotoGalleryImage,
} from "~/components/shared/PhotoGallery";
import { Tag } from "~/components/shared/Tag";
import { LocationIcon } from "~/components/pages/locations/PlanYourVisitSection/components/LocationIcon";

interface StudioHeroData {
  studioType: string;
  location: string;
  country: string;
  address: string;
  description: string;
  images: PhotoGalleryImage[];
}

interface StudioHeroSectionProps {
  data: StudioHeroData;
}

export function StudioHeroSection({ data }: StudioHeroSectionProps) {
  return (
    <PhotoGallery images={data.images} />
  );
}

interface StudioInfoSectionProps {
  data: {
    studioType: string;
    location: string;
    country: string;
    address: string;
    description: string;
  };
}

export function StudioInfoSection({ data }: StudioInfoSectionProps) {
  return (
    <div className="space-y-6">
      {/* Tags */}
      <div className="flex flex-wrap gap-2">
        <Tag>NOMADIC SATELLITE</Tag>
        <Tag>{data.studioType}</Tag>
        <Tag>
          {data.location.toUpperCase()}, {data.country}
        </Tag>
      </div>

      {/* Title */}
      <h1 className="text-stat-number font-bold text-gray-900 leading-tight">
        PROFESSIONAL {data.studioType} FOR CREATIVES
      </h1>

      {/* Address */}
      <div className="flex items-start space-x-2 text-gray-600">
        <LocationIcon />
        <p className="text-sm">{data.address}</p>
      </div>

      {/* Description */}
      <p className="text-gray-700 leading-relaxed">
        {data.description}
      </p>
    </div>
  );
}