import { Button } from "~/components/ui/button";
import { SectionHeader } from "~/components/shared/SectionHeader";
import { EquipmentAccordion } from "./components/EquipmentAccordion";

export interface Equipment {
  id: string;
  title: string;
  content: string;
}

const equipmentData: Equipment[] = [
  {
    id: "1",
    title: "CONSISTENT GEAR, WHEREVER YOU ARE",
    content:
      "Familiar tools make all the difference in achieving professional results. We equip our spaces globally with the gear you trust to maintain consistency in your work no matter which location you visit—one can rely on getting what you want—not to learning new setups.",
  },
  {
    id: "2",
    title: "INTERCONNECTED FOR SEAMLESS COLLABORATION",
    content:
      "Our equipment ecosystems are designed to work together seamlessly, enabling efficient workflows and real-time collaboration across different creative disciplines and locations.",
  },
  {
    id: "3",
    title: "SPECIALIZED RENTALS FOR UNIQUE NEEDS",
    content:
      "Beyond our standard equipment roster, we offer specialized rental options for unique project requirements, ensuring you have access to the exact tools needed for your creative vision.",
  },
  {
    id: "4",
    title: "STOCKED WITH ESSENTIALS",
    content:
      "From cameras and audio equipment to lighting and post-production tools, our studios come fully stocked with industry-standard equipment maintained to the highest standards.",
  },
  {
    id: "5",
    title: "EXPERT GUIDANCE ON-SITE",
    content:
      "Our technical staff is always available to provide guidance on equipment usage, troubleshooting, and optimization to ensure your creative process runs smoothly.",
  },
];

export function EquipmentSection() {
  return (
    <section className="relative w-full bg-neutral-900 text-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        {/* Header */}
        <div className="mb-10 lg:mb-16">
          <SectionHeader
            eyebrow="EQUIPMENT"
            title="THE EQUIPMENT YOU NEED TO CREATE"
            className="flex-1 max-w-[991px] [&_span]:text-white/60 [&_h2]:text-white"
          />
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-16 items-stretch">
          {/* Left Side - Image and CTA */}
          <div className="flex flex-col">
            {/* Equipment Image */}
            <div className="aspect-[624/748] overflow-hidden rounded-lg mb-8 flex-1">
              <img
                src="/images/home/equipment/studio-setup.png"
                alt="Professional studio equipment setup"
                className="h-full w-full object-cover"
                loading="lazy"
              />
            </div>
          </div>

          {/* Right Side - Accordion */}
          <div className="flex flex-col">
            <div className="flex-1 flex flex-col justify-center">
              <EquipmentAccordion equipment={equipmentData} />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
