import { Button } from "~/components/ui/button";
import { SectionHeader } from "~/components/shared/SectionHeader";
import { EventsGrid } from "~/components/shared/EventsGrid";

export function EventsSection() {
  return (
    <section className="relative w-full bg-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        <div className="grid grid-cols-1 gap-8 lg:gap-16 items-start">
          <div>
            {/* Header */}
            <div className="mb-6 lg:mb-8 flex  gap-4">
              <SectionHeader
                eyebrow="EVENTS"
                title="WORKSHOPS & NETWORKING"
                layout="vertical"
                className="[&_span]:text-black/60 [&_h2]:text-black mt-auto"
              />
              {/* Description */}
              <div className="*:flex flex-col gap-4">
                <p className="text-body-3 lg:text-body-2 !text-black/80 max-w-[500px]">
                  Expand your knowledge and spark new ideas through our
                  exclusive events. Workshops, discussions, and networking
                  mixers connect you with creative minds, helping you grow and
                  gain inspiration along the way.
                </p>
                {/* CTA Button */}
                <div className="flex mt-8">
                  <Button
                    variant="outline-black"
                    size="lg"
                    arrowRight
                    className="!text-black"
                  >
                    SEE UPCOMING EVENTS
                  </Button>
                </div>
              </div>
            </div>
          </div>

          <EventsGrid data={[]} />
        </div>
      </div>
    </section>
  );
}
