import type { Event } from "../EventsSection";

interface EventCardProps extends Event {}

export function EventCard({ image, date, time, title, href }: EventCardProps) {
  return (
    <a href={href} className="group block transition-all duration-300">
      <div className="flex flex-col">
        {/* Event Image */}
        <div className="aspect-[4/3] overflow-hidden rounded-lg bg-neutral-100 mb-4">
          <img
            src={image}
            alt={title}
            className="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
            loading="lazy"
          />
        </div>

        <div className="flex items-center h-[80px] ">
          {/* Date Section */}
          <div className="flex flex-col items-center justify-center px-6 py-4 border border-black/10 bg-gray-50/50">
            <div className="text-heading-5 leading-none !text-black">
              {date.day}
            </div>
            <div className="text-body-3 uppercase !text-black/60 mt-1">
              {date.month}
            </div>
          </div>

          {/* Event Details */}
          <div className="flex-1 px-6 py-4">
            <h3 className="text-heading-5 !text-black uppercase tracking-wider">
              {title}
            </h3>
            <p className="text-body-3 !text-black/50 mt-1">{time}</p>
          </div>
        </div>
      </div>
    </a>
  );
}
