import { SectionHeader } from "~/components/shared/SectionHeader";
import { LocationAccordion } from "./components/LocationAccordion";

export interface Location {
  id: string;
  name: string;
  country: string;
  meta: string;
  content: string;
  href: string;
  image: string;
}

const locationsData = [
  {
    id: "1",
    name: "BALI",
    country: "INDONESIA",
    meta: "VIDEO STUDIO / MUSIC STUDIO",
    content:
      "Bali is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
    href: "/locations/bali",
    image: "/images/home/locations/bali.png",
  },
  {
    id: "2",
    name: "BANGKOK",
    country: "THAILAND",
    meta: "VIDEO STUDIO / MUSIC STUDIO",
    content:
      "Bangkok is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
    href: "/locations/bangkok",
    image: "/images/home/locations/bali.png",
  },
  {
    id: "3",
    name: "MEXICO",
    country: "",
    meta: "PHOTOGRAPHY STUDIO / MUSIC STUDIO",
    content:
      "Mexico is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
    href: "/locations/mexico",
    image: "/images/home/locations/bali.png",
  },
  {
    id: "4",
    name: "COSTA RICA",
    country: "",
    meta: "VIDEO STUDIO / MUSIC STUDIO",
    content:
      "Costa Rica is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
    href: "/locations/costa-rica",
    image: "/images/home/locations/bali.png",
  },
  {
    id: "5",
    name: "NEW YORK",
    country: "",
    meta: "PHOTOGRAPHY STUDIO / FASHION STUDIO",
    content:
      "New York is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
    href: "/locations/new-york",
    image: "/images/home/locations/bali.png",
  },
  {
    id: "6",
    name: "MUMBAI",
    country: "",
    meta: "MUSIC STUDIO / ART STUDIO / FASHION STUDIO",
    content:
      "Mumbai is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
    href: "/locations/mumbai",
    image: "/images/home/locations/bali.png",
  },
];

export function LocationsSection() {
  return (
    <section className="relative w-full bg-neutral-900 text-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        {/* Header */}
        <div className="mb-10 lg:mb-16">
          <SectionHeader
            eyebrow="COMMUNITIES"
            title="SEE OUR LOCATIONS"
            className="flex-1 max-w-[991px] [&_span]:text-white/60 [&_h2]:text-white"
          />
        </div>

        {/* Accordion List */}
        <LocationAccordion locations={locationsData} />
      </div>
    </section>
  );
}
