import { SectionHeader } from "~/components/shared/SectionHeader";
import { SupportTile } from "./components/SupportTile";

const UploadIcon = () => (
  <svg
    width="34"
    height="33"
    viewBox="0 0 34 33"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M17 2.08203C11.9375 2.08203 7.375 4.76953 4.875 9.08203C2.3125 13.457 2.3125 18.7695 4.875 23.082C7.375 27.457 11.9375 30.082 17 30.082C22 30.082 26.5625 27.457 29.0625 23.082C31.625 18.7695 31.625 13.457 29.0625 9.08203C26.5625 4.76953 22 2.08203 17 2.08203ZM17 32.082C11.25 32.082 6 29.082 3.125 24.082C0.25 19.1445 0.25 13.082 3.125 8.08203C6 3.14453 11.25 0.0820312 17 0.0820312C22.6875 0.0820312 27.9375 3.14453 30.8125 8.08203C33.6875 13.082 33.6875 19.1445 30.8125 24.082C27.9375 29.082 22.6875 32.082 17 32.082ZM17 7.08203C17.5625 7.08203 18.125 7.33203 18.5 7.70703L24.1875 12.957C24.6875 13.3945 25 14.0195 25 14.707C25 16.0195 23.875 17.082 22.5625 17.082H21V22.1445C21 23.7695 19.625 25.1445 18 25.1445H16C14.3125 25.1445 13 23.7695 13 22.1445V17.1445H11.375C10.0625 17.1445 9 16.0195 9 14.707C9 14.082 9.25 13.3945 9.75 12.957L15.4375 7.70703C15.875 7.33203 16.375 7.08203 17 7.08203ZM16.8125 9.20703L11.125 14.457C11 14.5195 11 14.582 11 14.707C11 14.957 11.125 15.082 11.375 15.082H14C14.5 15.082 15 15.582 15 16.082V22.1445C15 22.6445 15.4375 23.1445 16 23.1445H18C18.5 23.1445 19 22.6445 19 22.1445V16.1445C19 15.582 19.4375 15.1445 20 15.1445H22.5625C22.8125 15.1445 23 14.957 23 14.707C23 14.6445 22.9375 14.5195 22.875 14.457L17.1875 9.20703C17.125 9.14453 17.0625 9.08203 17 9.08203C16.875 9.08203 16.8125 9.14453 16.8125 9.20703Z"
      fill="white"
    />
  </svg>
);

const ScaleIcon = () => (
  <svg
    width="40"
    height="34"
    viewBox="0 0 40 34"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M32.9375 1.76953C33.125 2.33203 32.875 2.89453 32.3125 3.08203L23.9375 5.83203C23.625 7.39453 22.5 8.58203 21 8.95703V31.082H33C33.5625 31.082 34 31.582 34 32.082C34 32.6445 33.5625 33.082 33 33.082H20C19.4375 33.082 19 32.6445 19 32.082V8.95703C18.375 8.83203 17.8125 8.51953 17.3125 8.08203L8.3125 11.082C7.8125 11.207 7.25 10.957 7.0625 10.457C6.875 9.89453 7.1875 9.33203 7.6875 9.14453L16.1875 6.33203C16.0625 5.95703 16 5.51953 16 5.08203C16 2.89453 17.8125 1.08203 20 1.08203C21.75 1.08203 23.25 2.20703 23.8125 3.76953L31.6875 1.14453C32.25 0.957031 32.8125 1.26953 32.9375 1.76953ZM27.5 21.7695C28.5625 22.582 30.125 23.082 32 23.082C33.8125 23.082 35.375 22.582 36.4375 21.7695C37.5 20.957 38 20.0195 38 19.082H26V19.0195V19.082C26 20.0195 26.4375 20.957 27.5 21.7695ZM32 8.33203L26.625 17.082H37.3125L32 8.33203ZM24 19.082V19.0195C24 18.082 24.25 17.207 24.6875 16.3945L30.4375 6.95703C30.75 6.45703 31.375 6.08203 32 6.08203C32.5625 6.08203 33.1875 6.45703 33.5 6.95703L39.25 16.3945C39.6875 17.207 40 18.082 40 19.0195V19.082C40 22.3945 36.375 25.082 32 25.082C27.5625 25.082 24 22.3945 24 19.082ZM2 27.082C2 28.0195 2.4375 28.957 3.5 29.7695C4.5625 30.582 6.125 31.082 8 31.082C9.8125 31.082 11.375 30.582 12.4375 29.7695C13.5 28.957 14 28.0195 14 27.082H2V27.0195V27.082ZM2.625 25.082H13.3125L8 16.332L2.625 25.082ZM8 33.082C3.5625 33.082 0 30.3945 0 27.082V27.0195C0 26.082 0.25 25.207 0.6875 24.3945L6.4375 14.957C6.75 14.457 7.375 14.082 8 14.082C8.5625 14.082 9.1875 14.457 9.5 14.957L15.25 24.3945C15.6875 25.207 16 26.082 16 27.0195V27.082C16 30.3945 12.375 33.082 8 33.082ZM20 7.08203C21.125 7.08203 22 6.20703 22 5.08203C22 4.01953 21.125 3.08203 20 3.08203C18.9375 3.08203 18 4.01953 18 5.08203C18 6.20703 18.9375 7.08203 20 7.08203Z"
      fill="white"
    />
  </svg>
);

const CreditCardIcon = () => (
  <svg
    width="32"
    height="32"
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M10 5.08203C10 5.26953 10.0625 5.51953 10.5 5.89453C10.5625 5.95703 10.6875 6.08203 10.75 6.14453C9.8125 6.14453 8.875 6.26953 8 6.39453V5.08203C8 4.14453 8.5 3.39453 9.1875 2.76953C9.875 2.20703 10.8125 1.70703 11.875 1.33203C14 0.582031 16.875 0.0820312 20 0.0820312C23.125 0.0820312 25.9375 0.582031 28.0625 1.33203C29.125 1.70703 30.0625 2.20703 30.75 2.76953C31.4375 3.39453 32 4.14453 32 5.08203V11.582V18.707C32 19.707 31.4375 20.5195 30.75 21.082C30.125 21.707 29.1875 22.207 28.125 22.6445C27.4375 22.8945 26.75 23.082 26 23.2695V21.207C26.5 21.082 26.9375 20.8945 27.375 20.7695C28.3125 20.3945 29 20.0195 29.4375 19.6445C29.875 19.207 30 18.957 30 18.707V14.582C29.4375 14.957 28.8125 15.2695 28.125 15.5195C27.4375 15.7695 26.75 15.957 26 16.1445V14.082C26.5 13.957 26.9375 13.832 27.375 13.6445C28.3125 13.2695 29 12.8945 29.4375 12.5195C29.875 12.1445 30 11.832 30 11.6445V8.01953C29.4375 8.33203 28.8125 8.64453 28.125 8.89453C27 9.26953 25.75 9.58203 24.375 9.76953C24.25 9.64453 24.125 9.51953 24 9.45703C23.375 8.89453 22.625 8.39453 21.875 8.01953C24.0625 7.89453 25.9375 7.51953 27.4375 6.95703C28.3125 6.64453 29 6.26953 29.4375 5.89453C29.875 5.51953 30 5.26953 30 5.08203C30 4.95703 29.875 4.64453 29.4375 4.26953C29 3.95703 28.375 3.51953 27.4375 3.20703C25.5625 2.51953 22.9375 2.08203 20 2.08203C17 2.08203 14.375 2.51953 12.5625 3.20703C11.625 3.58203 10.9375 3.95703 10.5 4.33203C10.0625 4.70703 9.9375 4.95703 9.9375 5.08203H10ZM2 13.082C2 13.2695 2.0625 13.5195 2.5 13.8945C2.9375 14.2695 3.625 14.6445 4.5625 15.0195C6.375 15.6445 9 16.082 12 16.082C14.9375 16.082 17.5625 15.6445 19.4375 15.0195C20.3125 14.6445 21 14.2695 21.4375 13.8945C21.875 13.5195 22 13.2695 22 13.082C22 12.957 21.875 12.707 21.4375 12.332C21 11.957 20.375 11.582 19.4375 11.207C17.5625 10.5195 14.9375 10.082 12 10.082C9 10.082 6.375 10.5195 4.5625 11.207C3.625 11.582 2.9375 11.957 2.5 12.332C2.0625 12.707 1.9375 12.957 1.9375 13.082H2ZM0 13.082C0 12.1445 0.5 11.3945 1.1875 10.7695C1.875 10.207 2.8125 9.70703 3.875 9.33203C6 8.58203 8.875 8.08203 12 8.08203C15.125 8.08203 17.9375 8.58203 20.0625 9.33203C21.125 9.70703 22.0625 10.207 22.75 10.7695C23.4375 11.3945 24 12.1445 24 13.082V19.582V26.707C24 27.707 23.4375 28.457 22.75 29.082C22.125 29.707 21.1875 30.207 20.125 30.6445C18 31.457 15.125 31.8945 12 31.8945C8.875 31.8945 5.9375 31.457 3.8125 30.6445C2.75 30.207 1.875 29.707 1.1875 29.082C0.5 28.5195 0 27.707 0 26.707V19.582V13.082ZM22 16.0195C21.4375 16.332 20.8125 16.6445 20.0625 16.8945C17.9375 17.6445 15.125 18.082 12 18.082C8.875 18.082 6 17.6445 3.875 16.8945C3.1875 16.6445 2.5 16.332 2 16.0195V19.582C2 19.832 2.0625 20.082 2.5 20.5195C2.9375 20.8945 3.625 21.2695 4.5625 21.6445C6.375 22.332 9 22.7695 12 22.7695C14.9375 22.7695 17.5625 22.332 19.375 21.6445C20.3125 21.2695 21 20.8945 21.4375 20.5195C21.875 20.082 22 19.832 22 19.582V16.0195ZM2 26.707C2 26.8945 2.0625 27.207 2.5 27.6445C2.9375 28.0195 3.625 28.3945 4.5625 28.7695C6.375 29.457 9 29.8945 12 29.8945C14.9375 29.8945 17.5625 29.457 19.375 28.7695C20.3125 28.3945 21 28.0195 21.4375 27.6445C21.875 27.207 22 26.957 22 26.707V22.582C21.4375 22.957 20.8125 23.2695 20.125 23.5195C18 24.332 15.125 24.7695 12 24.7695C8.875 24.7695 5.9375 24.332 3.8125 23.5195C3.125 23.2695 2.5 22.957 2 22.582V26.707Z"
      fill="white"
    />
  </svg>
);

const DollarSign = () => (
  <svg
    width="32"
    height="33"
    viewBox="0 0 32 33"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M12.5625 9.08203L12.25 9.33203C8.8125 11.5195 2 16.8945 2 26.082C2 28.332 3.75 30.082 6 30.082H26C28.1875 30.082 30 28.332 30 26.082C30 16.8945 23.125 11.5195 19.6875 9.33203L19.375 9.08203H12.5625ZM18.6875 7.08203H18.75L19.125 6.51953L22.1875 2.08203H9.75L12.8125 6.51953L13.25 7.08203H18.6875ZM9.5 8.76953C10.125 8.33203 10.6875 7.95703 11.1875 7.64453L10 5.95703L7.5625 2.45703C6.9375 1.45703 7.625 0.0820312 8.8125 0.0820312H23.125C24.3125 0.0820312 25.0625 1.45703 24.375 2.45703L21.9375 5.95703L20.8125 7.64453C21.25 7.95703 21.8125 8.33203 22.4375 8.76953C26.25 11.582 32 17.207 32 26.082C32 29.3945 29.3125 32.082 26 32.082H6C2.6875 32.082 0 29.3945 0 26.082C0 17.207 5.6875 11.582 9.5 8.76953ZM17 13.582V14.707C17.5 14.7695 18 14.8945 18.5 15.0195C19 15.1445 19.3125 15.707 19.1875 16.207C19.0625 16.7695 18.5 17.082 17.9375 16.957C17.25 16.7695 16.5625 16.6445 15.9375 16.582C15.4375 16.582 14.875 16.707 14.5 16.957C14.125 17.1445 14 17.3945 14 17.7695C14 17.957 14.0625 18.1445 14.4375 18.3945C14.875 18.6445 15.4375 18.832 16.25 19.082H16.3125C17 19.2695 17.875 19.582 18.5625 19.957C19.3125 20.457 19.9375 21.207 20 22.3945C20 23.582 19.375 24.457 18.5625 24.957C18.0625 25.2695 17.5 25.457 17 25.5195V26.582C17 27.1445 16.5 27.582 16 27.582C15.4375 27.582 15 27.1445 15 26.582V25.5195C14.25 25.3945 13.625 25.1445 13.0625 24.957C12.9375 24.8945 12.75 24.832 12.625 24.832C12.125 24.6445 11.875 24.082 12 23.582C12.1875 23.0195 12.75 22.7695 13.3125 22.8945C13.4375 22.957 13.5625 23.0195 13.75 23.082C14.5625 23.332 15.25 23.582 16 23.6445C16.5625 23.6445 17.125 23.5195 17.5 23.2695C17.8125 23.082 18 22.832 17.9375 22.3945C17.9375 22.1445 17.875 21.8945 17.5 21.707C17.0625 21.3945 16.4375 21.207 15.6875 20.957H15.5625C14.875 20.7695 14.0625 20.5195 13.375 20.082C12.625 19.6445 12 18.8945 12 17.7695C12 16.582 12.625 15.707 13.4375 15.207C13.9375 14.957 14.4375 14.7695 15 14.707V13.582C15 13.082 15.4375 12.582 16 12.582C16.5 12.582 17 13.082 17 13.582Z"
      fill="white"
    />
  </svg>
);

export interface SupportItem {
  id: string;
  icon: React.ReactNode;
  title: string;
  description?: string;
  href?: string;
}

const supportData: SupportItem[] = [
  {
    id: "amplify",
    icon: <UploadIcon />,
    title: "AMPLIFY YOUR REACH",
  },
  {
    id: "protect",
    icon: <ScaleIcon />,
    title: "PROTECT WHAT'S YOURS",
  },
  {
    id: "finances",
    icon: <CreditCardIcon />,
    title: "MASTER YOUR FINANCES",
  },
  {
    id: "monetize",
    icon: <DollarSign />,
    title: "MONETIZE YOUR CREATIVITY",
  },
];

export function SupportSection() {
  return (
    <section className="relative w-full bg-neutral-900">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-16">
          {/* Left side - Header and Title */}
          <div className="flex flex-col justify-center">
            <SectionHeader
              eyebrow="ADDITIONAL SERVICES"
              title="SUPPORT YOU NEED"
              layout="vertical"
              className="[&_span]:text-white/60 [&_h2]:text-white"
            />
          </div>

          {/* Right side - Description */}
          <div className="flex flex-col justify-center">
            <p className="text-body-3 lg:text-body-2 text-white/80">
              Nomadic Studios supports your creative journey with a full range
              of services designed to simplify your workload, protect your work,
              and elevate your craft. From managing your online presence to
              securing your intellectual property and ensuring your finances are
              in order, we provide the expertise you need to thrive.
            </p>
          </div>
        </div>

        {/* Support Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mt-12 lg:mt-16">
          {supportData.map((item) => (
            <SupportTile key={item.id} {...item} />
          ))}
        </div>
      </div>
    </section>
  );
}
