interface HeroSectionProps {
  backgroundImage: string;
  title: string;
  subtitle?:
    | {
        mobile?: string;
        desktop?: string;
      }
    | string;
  children?: React.ReactNode;
}

export function HeroSection({
  backgroundImage,
  title,
  subtitle,
  children,
}: HeroSectionProps) {
  return (
    <section className="relative w-full h-[calc(100vh-4rem)] lg:h-[calc(100vh-5rem)] flex flex-col">
      {/* Background */}
      <div className="absolute inset-0 bg-[#030303]" />
      <img
        src={backgroundImage}
        alt=""
        className="absolute inset-0 h-full w-full object-cover"
      />

      {/* Content - Centered */}
      <div className="absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 w-full flex flex-col items-center justify-center gap-4 px-4 lg:px-0">
        <div className="text-center">
          <h1
            className="text-heading-2-bold lg:text-heading-1 uppercase text-white mb-4"
            dangerouslySetInnerHTML={{ __html: title }}
          />

          {subtitle && (
            <>
              {typeof subtitle === "string" ? (
                <p className="text-center text-body-2 lg:text-body-1 text-white/80 max-w-[600px] mx-auto">
                  {subtitle}
                </p>
              ) : (
                <>
                  {subtitle.mobile && (
                    <p className="lg:hidden text-center text-body-2 text-white/80 max-w-[600px] mx-auto">
                      {subtitle.mobile}
                    </p>
                  )}
                </>
              )}
            </>
          )}
        </div>
      </div>

      {/* Bottom Actions */}
      {children && (
        <div className="relative flex-1 flex flex-col items-center justify-end px-4 lg:px-14 pb-8 lg:pb-12">
          <div className="flex items-center justify-center w-full max-w-[1328px]">
            {children}
            {subtitle &&
              typeof subtitle !== "string" &&
              "desktop" in subtitle && (
                <p className="hidden lg:block text-right text-body-1 text-white/80 max-w-[600px] ml-auto">
                  {subtitle.desktop}
                </p>
              )}
          </div>
        </div>
      )}
    </section>
  );
}
