import { SectionHeader } from "~/components/shared/SectionHeader";
import { EventsGrid } from "~/components/shared/EventsGrid";

interface EventsTitle {
  title: string;
}

export interface EventData {
  id: string;
  image: string;
  date: {
    day: string;
    month: string;
  };
  time: string;
  title: string;
  href: string;
}

interface EventsSectionProps {
  title: EventsTitle;
  data: EventData[];
}

export function EventsSection({ title, data }: EventsSectionProps) {
  return (
    <section className="relative w-full bg-white">
      <div className="mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24">
        <SectionHeader title={title} className="mb-4" />
        <EventsGrid data={data} />
      </div>
    </section>
  );
}
