import { HeroSection } from "../../home/WelcomeSection/components/HeroSection";
import { HeroActions } from "../../home/WelcomeSection/components/HeroActions";

interface WelcomeData {
  title: string;
  subtitle: string;
  backgroundImage: string;
  ctaLabel: string;
  ctaHref: string;
}

interface WelcomeSectionProps {
  data: WelcomeData;
}

export function WelcomeSection({ data }: WelcomeSectionProps) {
  const heroActions = [
    {
      label: data.ctaLabel,
      href: data.ctaHref,
      variant: "fill-white" as const,
      icon: true,
    },
  ];

  return (
    <HeroSection
      backgroundImage={data.backgroundImage}
      title={data.title}
      subtitle={data.subtitle}
    >
      <HeroActions actions={heroActions} />
    </HeroSection>
  );
}