import type { Person } from "../PeopleSection";

interface PersonCardProps extends Person {}

export function PersonCard({
  photo,
  name,
  surname,
  role,
  location,
  href,
}: PersonCardProps) {
  return (
    <a
      href={href}
      className="group block overflow-hidden transition-all duration-300 hover:scale-[1.02]"
    >
      {/* Photo */}
      <div className="aspect-[3/4] overflow-hidden bg-neutral-100 mb-2 lg:mb-4">
        <img
          src={photo}
          alt={`${name} ${surname} - ${role}`}
          className="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105 grayscale group-hover:grayscale-0"
          loading="lazy"
        />
      </div>

      {/* Person Info */}
      <div className="space-y-0.5 lg:space-y-1">
        <h3 className="text-body-3 lg:text-heading-5 tracking-[-0.01em] !text-black uppercase leading-tight">
          {name} {surname}
        </h3>
        <p className="text-button-small lg:text-body-3 !text-black/60 capitalize">
          {role}
        </p>
      </div>
    </a>
  );
}