import { cn } from "~/lib/utils";

interface TagProps {
  children: React.ReactNode;
  className?: string;
}

export function Tag({ children, className }: TagProps) {
  return (
    <span
      className={cn(
        "inline-flex items-center h-9 px-4 rounded-full border border-dark-solid bg-transparent text-button-medium text-black transition-colors hover:bg-dark-10",
        className
      )}
    >
      {children}
    </span>
  );
}
