export interface LocationData {
  meta: {
    title: string;
    description: string;
  };
  welcome: {
    title: string;
    subtitle: string;
    backgroundImage: string;
    meta: string;
  };
  info: {
    title: string;
    description: string;
    stats: Array<{
      number: string;
      label: string;
    }>;
  };
  studios: {
    sectionTitle: string;
    studios: Array<{
      id: string;
      image: string;
      title: string;
    }>;
  };
  events: {
    sectionTitle: string;
  };
  planVisit: {
    address: string;
    hours: string;
    phone: string;
    email: string;
    additionalInfo: string;
  };
  people: {
    title: string;
  };
}

export type LocationType =
  | "bali"
  | "bangkok"
  | "mexico"
  | "costa-rica"
  | "new-york"
  | "mumbai";

export const locationsConfig: Record<LocationType, LocationData> = {
  bali: {
    meta: {
      title: "Bali Location | Nomadics",
      description:
        "Nomadics Bali - Creative hub with video and music studios in the heart of Indonesia",
    },
    welcome: {
      title: "BALI, CREATIVE HUB",
      subtitle:
        "Welcome to Bali, your creative hub. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "VIDEO STUDIO / MUSIC STUDIO",
    },
    info: {
      title: "BALI IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "3", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "12", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "5", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN BALI",
      studios: [
        {
          id: "bali-video-studio",
          image: "/images/studios/studio-1.png",
          title: "VIDEO STUDIO",
        },
        {
          id: "bali-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "bali-photography-studio",
          image: "/images/studios/photo-1.png",
          title: "PHOTOGRAPHY STUDIO",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN BALI",
    },
    planVisit: {
      address:
        "Jl. Raya Ubud No.88, Ubud, Kecamatan Ubud, Kabupaten Gianyar, Bali 80571, Indonesia",
      hours: "6:00 AM - 11:00 PM",
      phone: "+91 8786564378",
      email: "bali@sativehub@gmail.com",
      additionalInfo: "You can go to us by bus from...",
    },
    people: {
      title: "MEET THE CREATIVES OF BALI",
    },
  },
  bangkok: {
    meta: {
      title: "Bangkok Location | Nomadics",
      description:
        "Nomadics Bangkok - Innovation center with video and music studios in Thailand's creative capital",
    },
    welcome: {
      title: "BANGKOK, INNOVATION CENTER",
      subtitle:
        "Bangkok is a city of innovation, culture, and creativity. Our studios provide the perfect environment for creators to thrive in Southeast Asia's most dynamic city.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "VIDEO STUDIO / MUSIC STUDIO",
    },
    info: {
      title: "BANGKOK IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "4", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "18", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "3", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN BANGKOK",
      studios: [
        {
          id: "bangkok-video-studio",
          image: "/images/studios/studio-1.png",
          title: "VIDEO STUDIO",
        },
        {
          id: "bangkok-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "bangkok-podcast-studio",
          image: "/images/studios/photo-1.png",
          title: "PODCAST STUDIO",
        },
        {
          id: "bangkok-livestream-studio",
          image: "/images/studios/studio-1.png",
          title: "LIVESTREAM STUDIO",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN BANGKOK",
    },
    planVisit: {
      address: "123 Sukhumvit Rd, Khlong Toei, Bangkok 10110, Thailand",
      hours: "9:00 AM - 9:00 PM",
      phone: "+66 2 123 4567",
      email: "bangkok@nomadics.com",
      additionalInfo: "Located near BTS Skytrain stations...",
    },
    people: {
      title: "MEET THE CREATIVES OF BANGKOK",
    },
  },
  mexico: {
    meta: {
      title: "Mexico Location | Nomadics",
      description:
        "Nomadics Mexico - Artistic heart with photography and music studios in Mexico City",
    },
    welcome: {
      title: "MEXICO, ARTISTIC HEART",
      subtitle:
        "Mexico's rich cultural heritage meets modern creative technology. Our studios offer a unique blend of traditional artistry and cutting-edge production facilities.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "PHOTOGRAPHY STUDIO / MUSIC STUDIO",
    },
    info: {
      title: "MEXICO IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "5", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "25", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "10", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN MEXICO",
      studios: [
        {
          id: "mexico-photography-studio",
          image: "/images/studios/photo-1.png",
          title: "PHOTOGRAPHY STUDIO",
        },
        {
          id: "mexico-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "mexico-art-studio",
          image: "/images/studios/studio-1.png",
          title: "ART STUDIO",
        },
        {
          id: "mexico-dance-studio",
          image: "/images/studios/photo-1.png",
          title: "DANCE STUDIO",
        },
        {
          id: "mexico-recording-studio",
          image: "/images/studios/music-1.png",
          title: "RECORDING STUDIO",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN MEXICO",
    },
    planVisit: {
      address: "Av. Insurgentes Sur 123, Roma Norte, CDMX 06700, Mexico",
      hours: "9:00 AM - 8:00 PM",
      phone: "+52 55 1234 5678",
      email: "mexico@nomadics.com",
      additionalInfo: "Easy access via Metro Line 1...",
    },
    people: {
      title: "MEET THE CREATIVES OF MEXICO",
    },
  },
  "costa-rica": {
    meta: {
      title: "Costa Rica Location | Nomadics",
      description:
        "Nomadics Costa Rica - Natural inspiration with video and music studios surrounded by beauty",
    },
    welcome: {
      title: "COSTA RICA, NATURAL INSPIRATION",
      subtitle:
        "Surrounded by natural beauty, our Costa Rica location provides a serene environment for focused creative work and inspired productions.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "VIDEO STUDIO / MUSIC STUDIO",
    },
    info: {
      title: "COSTA RICA IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "3", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "15", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "8", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN COSTA RICA",
      studios: [
        {
          id: "costa-rica-video-studio",
          image: "/images/studios/studio-1.png",
          title: "VIDEO STUDIO",
        },
        {
          id: "costa-rica-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "costa-rica-creative-suite",
          image: "/images/studios/photo-1.png",
          title: "CREATIVE SUITE",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN COSTA RICA",
    },
    planVisit: {
      address: "Avenida Central, San José, Costa Rica",
      hours: "8:00 AM - 7:00 PM",
      phone: "+506 1234 5678",
      email: "costarica@nomadics.com",
      additionalInfo: "Downtown location near main attractions...",
    },
    people: {
      title: "MEET THE CREATIVES OF COSTA RICA",
    },
  },
  "new-york": {
    meta: {
      title: "New York Location | Nomadics",
      description:
        "Nomadics New York - Global epicenter with photography and fashion studios in Manhattan",
    },
    welcome: {
      title: "NEW YORK, GLOBAL EPICENTER",
      subtitle:
        "In the heart of the world's creative capital, our New York studios offer unparalleled resources for fashion, photography, and artistic innovation.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "PHOTOGRAPHY STUDIO / FASHION STUDIO",
    },
    info: {
      title: "NEW YORK IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "8", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "35", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "2", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN NEW YORK",
      studios: [
        {
          id: "new-york-photography-studio",
          image: "/images/studios/photo-1.png",
          title: "PHOTOGRAPHY STUDIO",
        },
        {
          id: "new-york-fashion-studio",
          image: "/images/studios/studio-1.png",
          title: "FASHION STUDIO",
        },
        {
          id: "new-york-video-studio",
          image: "/images/studios/studio-1.png",
          title: "VIDEO STUDIO",
        },
        {
          id: "new-york-art-studio",
          image: "/images/studios/photo-1.png",
          title: "ART STUDIO",
        },
        {
          id: "new-york-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "new-york-dance-studio",
          image: "/images/studios/studio-1.png",
          title: "DANCE STUDIO",
        },
        {
          id: "new-york-podcast-studio",
          image: "/images/studios/photo-1.png",
          title: "PODCAST STUDIO",
        },
        {
          id: "new-york-livestream-studio",
          image: "/images/studios/music-1.png",
          title: "LIVESTREAM STUDIO",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN NEW YORK",
    },
    planVisit: {
      address: "123 Broadway, Manhattan, New York, NY 10013, USA",
      hours: "24/7 Access for Members",
      phone: "+1 212 123 4567",
      email: "newyork@nomadics.com",
      additionalInfo: "Accessible via multiple subway lines...",
    },
    people: {
      title: "MEET THE CREATIVES OF NEW YORK",
    },
  },
  mumbai: {
    meta: {
      title: "Mumbai Location | Nomadics",
      description:
        "Nomadics Mumbai - Cultural fusion with music, art, and fashion studios in India's entertainment capital",
    },
    welcome: {
      title: "MUMBAI, CULTURAL FUSION",
      subtitle:
        "Mumbai's vibrant energy fuels creativity. Our studios here blend Bollywood's magic with international production standards.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "MUSIC STUDIO / ART STUDIO / FASHION STUDIO",
    },
    info: {
      title: "MUMBAI IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "6", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "22", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "7", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN MUMBAI",
      studios: [
        {
          id: "mumbai-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "mumbai-art-studio",
          image: "/images/studios/studio-1.png",
          title: "ART STUDIO",
        },
        {
          id: "mumbai-fashion-studio",
          image: "/images/studios/photo-1.png",
          title: "FASHION STUDIO",
        },
        {
          id: "mumbai-recording-studio",
          image: "/images/studios/music-1.png",
          title: "RECORDING STUDIO",
        },
        {
          id: "mumbai-dance-studio",
          image: "/images/studios/studio-1.png",
          title: "DANCE STUDIO",
        },
        {
          id: "mumbai-video-studio",
          image: "/images/studios/photo-1.png",
          title: "VIDEO STUDIO",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN MUMBAI",
    },
    planVisit: {
      address: "123 Linking Road, Bandra West, Mumbai 400050, India",
      hours: "7:00 AM - 11:00 PM",
      phone: "+91 22 1234 5678",
      email: "mumbai@nomadics.com",
      additionalInfo: "Near Bandra railway station...",
    },
    people: {
      title: "MEET THE CREATIVES OF MUMBAI",
    },
  },
  "costa-rica1": {
    meta: {
      title: "Costa Rica Location | Nomadics",
      description:
        "Nomadics Costa Rica - Natural inspiration with video and music studios surrounded by beauty",
    },
    welcome: {
      title: "COSTA RICA, NATURAL INSPIRATION",
      subtitle:
        "Surrounded by natural beauty, our Costa Rica location provides a serene environment for focused creative work and inspired productions.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "VIDEO STUDIO / MUSIC STUDIO",
    },
    info: {
      title: "COSTA RICA IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "3", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "15", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "8", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN COSTA RICA",
      studios: [
        {
          id: "costa-rica-video-studio",
          image: "/images/studios/studio-1.png",
          title: "VIDEO STUDIO",
        },
        {
          id: "costa-rica-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "costa-rica-creative-suite",
          image: "/images/studios/photo-1.png",
          title: "CREATIVE SUITE",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN COSTA RICA",
    },
    planVisit: {
      address: "Avenida Central, San José, Costa Rica",
      hours: "8:00 AM - 7:00 PM",
      phone: "+506 1234 5678",
      email: "costarica@nomadics.com",
      additionalInfo: "Downtown location near main attractions...",
    },
    people: {
      title: "MEET THE CREATIVES OF COSTA RICA",
    },
  },
  "new-york1": {
    meta: {
      title: "New York Location | Nomadics",
      description:
        "Nomadics New York - Global epicenter with photography and fashion studios in Manhattan",
    },
    welcome: {
      title: "NEW YORK, GLOBAL EPICENTER",
      subtitle:
        "In the heart of the world's creative capital, our New York studios offer unparalleled resources for fashion, photography, and artistic innovation.",
      backgroundImage: "/images/home/locations/bali.png",
      meta: "PHOTOGRAPHY STUDIO / FASHION STUDIO",
    },
    info: {
      title: "NEW YORK IS A CITY OF INNOVATION, CULTURE AND CREATIVITY",
      description:
        "Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need here.",
      stats: [
        { number: "8", label: "STUDIO SPACES\nAVAILABLE" },
        { number: "35", label: "PROFESSIONALS\nCOLLABORATING\nMONTHLY" },
        { number: "2", label: "MINUTES FROM\nTHE CITY CENTER" },
      ],
    },
    studios: {
      sectionTitle: "STUDIOS TO CREATE IN NEW YORK",
      studios: [
        {
          id: "new-york-photography-studio",
          image: "/images/studios/photo-1.png",
          title: "PHOTOGRAPHY STUDIO",
        },
        {
          id: "new-york-fashion-studio",
          image: "/images/studios/studio-1.png",
          title: "FASHION STUDIO",
        },
        {
          id: "new-york-video-studio",
          image: "/images/studios/studio-1.png",
          title: "VIDEO STUDIO",
        },
        {
          id: "new-york-art-studio",
          image: "/images/studios/photo-1.png",
          title: "ART STUDIO",
        },
        {
          id: "new-york-music-studio",
          image: "/images/studios/music-1.png",
          title: "MUSIC STUDIO",
        },
        {
          id: "new-york-dance-studio",
          image: "/images/studios/studio-1.png",
          title: "DANCE STUDIO",
        },
        {
          id: "new-york-podcast-studio",
          image: "/images/studios/photo-1.png",
          title: "PODCAST STUDIO",
        },
        {
          id: "new-york-livestream-studio",
          image: "/images/studios/music-1.png",
          title: "LIVESTREAM STUDIO",
        },
      ],
    },
    events: {
      sectionTitle: "EVENTS IN NEW YORK",
    },
    planVisit: {
      address: "123 Broadway, Manhattan, New York, NY 10013, USA",
      hours: "24/7 Access for Members",
      phone: "+1 212 123 4567",
      email: "newyork@nomadics.com",
      additionalInfo: "Accessible via multiple subway lines...",
    },
    people: {
      title: "MEET THE CREATIVES OF NEW YORK",
    },
  },
};
