import type { MetaFunction } from "@remix-run/node";
import { ProtectedRoute } from "~/components/RouteProtection";

export const meta: MetaFunction = () => {
  return [
    { title: "Account Settings - Nomadics Studios" },
    {
      name: "description",
      content: "Manage your account settings and preferences.",
    },
  ];
};

export default function AccountSettings() {
  return (
    <ProtectedRoute>
      <div className="min-h-screen flex items-center justify-center bg-black text-white">
        <div className="text-center px-4">
          <div className="mb-8">
            <img 
              src="/images/logo-white.png" 
              alt="Nomadics Studios" 
              className="h-16 lg:h-20 w-auto mx-auto mb-8"
            />
          </div>
          
          <h1 className="text-4xl lg:text-6xl font-bold mb-6 tracking-wider">
            ACCOUNT SETTINGS
          </h1>
          
          <p className="text-lg lg:text-xl text-white/80 mb-8 max-w-2xl mx-auto leading-relaxed">
            Account settings page is under development.
            <br />
            You can manage your profile, preferences, and more here soon.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <div className="text-sm text-white/60 uppercase tracking-widest">
              Coming Soon
            </div>
          </div>
        </div>
      </div>
    </ProtectedRoute>
  );
}